/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.h2.command.dml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.glowroot.agent.embedded.shaded.org.h2.command.Prepared;
import org.glowroot.agent.embedded.shaded.org.h2.command.dml.ScriptBase;
import org.glowroot.agent.embedded.shaded.org.h2.engine.Constants;
import org.glowroot.agent.embedded.shaded.org.h2.engine.Session;
import org.glowroot.agent.embedded.shaded.org.h2.message.DbException;
import org.glowroot.agent.embedded.shaded.org.h2.result.ResultInterface;
import org.glowroot.agent.embedded.shaded.org.h2.util.ScriptReader;

public class RunScriptCommand
extends ScriptBase {
    private Charset charset = Constants.UTF8;

    public RunScriptCommand(Session session) {
        super(session);
    }

    @Override
    public int update() {
        this.session.getUser().checkAdmin();
        int n = 0;
        try {
            String string;
            this.openInput();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.in, this.charset));
            bufferedReader.mark(1);
            if (bufferedReader.read() != 65279) {
                bufferedReader.reset();
            }
            ScriptReader scriptReader = new ScriptReader(bufferedReader);
            while ((string = scriptReader.readStatement()) != null) {
                this.execute(string);
                if ((++n & 0x7F) != 0) continue;
                this.checkCanceled();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
        finally {
            this.closeIO();
        }
        return n;
    }

    private void execute(String string) {
        try {
            Prepared prepared = this.session.prepare(string);
            if (prepared.isQuery()) {
                prepared.query(0);
            } else {
                prepared.update();
            }
            if (this.session.getAutoCommit()) {
                this.session.commit(false);
            }
        }
        catch (DbException dbException) {
            throw dbException.addSQL(string);
        }
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 64;
    }
}

