/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.EmbeddedWebConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ActiveAgentRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.AgentDisplayRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.AggregateRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.AlertingDisabledRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.EnvironmentRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.GaugeValueRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.IncidentRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.RepoAdmin;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.SyntheticResultRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.TraceAttributeNameRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.TraceRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.TransactionTypeRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.HttpClient;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.MailService;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.RollupLevelService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.AdminJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.AlertConfigJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.CommonHandler;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ConfigJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ErrorCommonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ErrorJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GaugeConfigJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GaugeValueJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GlowrootLogHttpService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.HealthCheckHttpService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.HttpServer;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.HttpSessionManager;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.IncidentJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.IndexHtmlHttpService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.InstrumentationConfigJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JvmJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.LayoutJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.LayoutService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ReportJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.RoleConfigJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.SessionMapFactory;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.SyntheticMonitorConfigJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.SyntheticResultJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.TraceCommonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.TraceDetailHttpService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.TraceExportHttpService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.TraceJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.TracePointJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.TransactionCommonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.TransactionJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.UserConfigJsonService;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Supplier;
import org.glowroot.agent.shaded.com.google.common.base.Suppliers;
import org.glowroot.agent.shaded.com.google.common.base.Ticker;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.glowroot.agent.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveAggregateRepository;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveJvmService;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveTraceRepository;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveWeavingService;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.immutables.builder.Builder;

public class UiModule {
    private static final Logger logger = LoggerFactory.getLogger(UiModule.class);
    private final @Nullable HttpServer httpServer;
    private final @Nullable CommonHandler commonHandler;
    private final ExecutorService reportingExecutor;

    @Builder.Factory
    public static UiModule createUiModule(boolean central, boolean servlet, boolean offlineViewer, boolean webPortReadOnly, @Nullable String bindAddress, @Nullable Integer port, @Nullable Boolean https, @Nullable String contextPath, List<File> confDirs, File logDir, Pattern logFileNamePattern, @Nullable Ticker ticker, Clock clock, @Nullable LiveJvmService liveJvmService, AgentDisplayRepository agentDisplayRepository, final ConfigRepository configRepository, AlertingDisabledRepository alertingDisabledRepository, ActiveAgentRepository activeAgentRepository, EnvironmentRepository environmentRepository, TransactionTypeRepository transactionTypeRepository, AggregateRepository aggregateRepository, TraceAttributeNameRepository traceAttributeNameRepository, TraceRepository traceRepository, GaugeValueRepository gaugeValueRepository, @Nullable SyntheticResultRepository syntheticResultRepository, IncidentRepository incidentRepository, RepoAdmin repoAdmin, RollupLevelService rollupLevelService, LiveTraceRepository liveTraceRepository, LiveAggregateRepository liveAggregateRepository, @Nullable LiveWeavingService liveWeavingService, SessionMapFactory sessionMapFactory, HttpClient httpClient, int numWorkerThreads, String version) throws Exception {
        int initialPort;
        HttpServer httpServer;
        Object reportingExecutor;
        TransactionCommonService transactionCommonService = new TransactionCommonService(aggregateRepository, liveAggregateRepository, configRepository, clock);
        TraceCommonService traceCommonService = new TraceCommonService(traceRepository, liveTraceRepository, agentDisplayRepository);
        ErrorCommonService errorCommonService = new ErrorCommonService(aggregateRepository, liveAggregateRepository);
        MailService mailService = new MailService();
        AdminJsonService adminJsonService = new AdminJsonService(central, offlineViewer, webPortReadOnly, confDirs, configRepository, repoAdmin, liveAggregateRepository, mailService, httpClient);
        LayoutService layoutService = new LayoutService(central, offlineViewer, version, agentDisplayRepository, configRepository, transactionTypeRepository, traceAttributeNameRepository, environmentRepository, liveAggregateRepository, liveTraceRepository);
        if (central) {
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("Glowroot-UI-Report-Worker").build();
            reportingExecutor = new ThreadPoolExecutor(0, 10, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        } else {
            reportingExecutor = MoreExecutors.newDirectExecutorService();
        }
        ArrayList jsonServices = Lists.newArrayList();
        jsonServices.add(new LayoutJsonService(activeAgentRepository, layoutService));
        jsonServices.add(new TransactionJsonService(transactionCommonService, traceCommonService, aggregateRepository, configRepository, rollupLevelService, clock));
        jsonServices.add(new TracePointJsonService(traceRepository, liveTraceRepository, configRepository, ticker, clock));
        jsonServices.add(new TraceJsonService(traceCommonService));
        jsonServices.add(new ErrorJsonService(errorCommonService, transactionCommonService, traceRepository, configRepository, rollupLevelService, clock));
        jsonServices.add(new GaugeValueJsonService(gaugeValueRepository, rollupLevelService, configRepository));
        jsonServices.add(new JvmJsonService(environmentRepository, configRepository, liveJvmService));
        jsonServices.add(new IncidentJsonService(central, incidentRepository, agentDisplayRepository, configRepository, syntheticResultRepository, clock));
        jsonServices.add(new ReportJsonService(agentDisplayRepository, configRepository, activeAgentRepository, transactionTypeRepository, aggregateRepository, gaugeValueRepository, liveAggregateRepository, rollupLevelService, (ExecutorService)reportingExecutor));
        jsonServices.add(new ConfigJsonService(transactionTypeRepository, gaugeValueRepository, liveAggregateRepository, configRepository));
        jsonServices.add(new AlertConfigJsonService(configRepository, alertingDisabledRepository, gaugeValueRepository, syntheticResultRepository, clock, central));
        jsonServices.add(new UserConfigJsonService(configRepository));
        jsonServices.add(new RoleConfigJsonService(central, configRepository, activeAgentRepository));
        jsonServices.add(new GaugeConfigJsonService(configRepository, liveJvmService));
        jsonServices.add(new InstrumentationConfigJsonService(central, configRepository, liveWeavingService, liveJvmService));
        jsonServices.add(adminJsonService);
        if (central) {
            Preconditions.checkNotNull((Object)syntheticResultRepository);
            jsonServices.add(new SyntheticResultJsonService(syntheticResultRepository, rollupLevelService, configRepository, clock));
            jsonServices.add(new SyntheticMonitorConfigJsonService(configRepository));
        }
        HttpSessionManager httpSessionManager = new HttpSessionManager(central, offlineViewer, configRepository, clock, layoutService, sessionMapFactory);
        IndexHtmlHttpService indexHtmlHttpService = new IndexHtmlHttpService(layoutService);
        TraceDetailHttpService traceDetailHttpService = new TraceDetailHttpService(traceCommonService);
        TraceExportHttpService traceExportHttpService = new TraceExportHttpService(traceCommonService, version);
        GlowrootLogHttpService glowrootLogHttpService = new GlowrootLogHttpService(logDir, logFileNamePattern);
        HealthCheckHttpService healthCheckHttpService = new HealthCheckHttpService(repoAdmin);
        HashMap httpServices = Maps.newHashMap();
        httpServices.put(Pattern.compile("^/$"), indexHtmlHttpService);
        httpServices.put(Pattern.compile("^/transaction/.*$"), indexHtmlHttpService);
        httpServices.put(Pattern.compile("^/error/.*$"), indexHtmlHttpService);
        httpServices.put(Pattern.compile("^/jvm/.*$"), indexHtmlHttpService);
        httpServices.put(Pattern.compile("^/incidents$"), indexHtmlHttpService);
        httpServices.put(Pattern.compile("^/report/.*$"), indexHtmlHttpService);
        httpServices.put(Pattern.compile("^/config/.*$"), indexHtmlHttpService);
        httpServices.put(Pattern.compile("^/admin/.*$"), indexHtmlHttpService);
        httpServices.put(Pattern.compile("^/profile/.*$"), indexHtmlHttpService);
        httpServices.put(Pattern.compile("^/login$"), indexHtmlHttpService);
        httpServices.put(Pattern.compile("^/export/trace$"), traceExportHttpService);
        httpServices.put(Pattern.compile("^/backend/trace/entries$"), traceDetailHttpService);
        httpServices.put(Pattern.compile("^/backend/trace/queries$"), traceDetailHttpService);
        httpServices.put(Pattern.compile("^/backend/trace/main-thread-profile$"), traceDetailHttpService);
        httpServices.put(Pattern.compile("^/backend/trace/aux-thread-profile$"), traceDetailHttpService);
        httpServices.put(Pattern.compile("^/log$"), glowrootLogHttpService);
        httpServices.put(Pattern.compile("^/health$"), healthCheckHttpService);
        if (central) {
            httpServices.put(Pattern.compile("^/synthetic-monitors$"), indexHtmlHttpService);
        }
        CommonHandler commonHandler = new CommonHandler(central, layoutService, httpServices, httpSessionManager, jsonServices, clock);
        if (servlet) {
            return new UiModule(commonHandler, (ExecutorService)reportingExecutor);
        }
        if (central) {
            httpServer = new HttpServer((String)Preconditions.checkNotNull((Object)bindAddress), (Boolean)Preconditions.checkNotNull((Object)https), (Supplier<String>)Suppliers.ofInstance((Object)((String)Preconditions.checkNotNull((Object)contextPath))), numWorkerThreads, commonHandler, confDirs, central, offlineViewer);
            initialPort = (Integer)Preconditions.checkNotNull((Object)port);
        } else {
            final EmbeddedWebConfig initialWebConfig = configRepository.getEmbeddedWebConfig();
            Supplier<String> contextPathSupplier = new Supplier<String>(){

                public String get() {
                    try {
                        return configRepository.getEmbeddedWebConfig().contextPath();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        return initialWebConfig.contextPath();
                    }
                }
            };
            httpServer = new HttpServer(initialWebConfig.bindAddress(), initialWebConfig.https(), contextPathSupplier, numWorkerThreads, commonHandler, confDirs, central, offlineViewer);
            initialPort = initialWebConfig.port();
        }
        adminJsonService.setHttpServer(httpServer);
        httpServer.bindEventually(initialPort);
        return new UiModule(httpServer, (ExecutorService)reportingExecutor);
    }

    private UiModule(HttpServer httpServer, ExecutorService reportingExecutor) {
        this.httpServer = httpServer;
        this.commonHandler = null;
        this.reportingExecutor = reportingExecutor;
    }

    private UiModule(CommonHandler commonHandler, ExecutorService reportingExecutor) {
        this.commonHandler = commonHandler;
        this.httpServer = null;
        this.reportingExecutor = reportingExecutor;
    }

    public CommonHandler getCommonHandler() {
        return (CommonHandler)Preconditions.checkNotNull((Object)this.commonHandler);
    }

    public void close(boolean jvmTermination) throws Exception {
        if (this.httpServer != null) {
            this.httpServer.close();
        }
        if (!jvmTermination) {
            this.reportingExecutor.shutdown();
        }
    }
}

