/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ChunkSource;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.CommonHandler;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.HttpService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.HttpSessionManager;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.TraceCommonService;
import org.glowroot.agent.shaded.com.google.common.base.Charsets;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.io.CharSource;
import org.glowroot.agent.shaded.com.google.common.io.Resources;
import org.glowroot.agent.shaded.com.google.common.net.MediaType;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

class TraceExportHttpService
implements HttpService {
    private static final Logger logger = LoggerFactory.getLogger(TraceExportHttpService.class);
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"audit");
    private final TraceCommonService traceCommonService;
    private final String version;

    TraceExportHttpService(TraceCommonService traceCommonService, String version) {
        this.traceCommonService = traceCommonService;
        this.version = version;
    }

    @Override
    public String getPermission() {
        return "agent:trace";
    }

    @Override
    public CommonHandler.CommonResponse handleRequest(CommonHandler.CommonRequest request, HttpSessionManager.Authentication authentication) throws Exception {
        auditLogger.info("{} - GET {}", (Object)authentication.caseAmbiguousUsername(), (Object)request.getUri());
        List<String> agentIds = request.getParameters("agent-id");
        String agentId = agentIds.isEmpty() ? "" : agentIds.get(0);
        List<String> traceIds = request.getParameters("trace-id");
        Preconditions.checkState((!traceIds.isEmpty() ? 1 : 0) != 0, (String)"Missing trace id in query string: %s", (Object)request.getUri());
        String traceId = traceIds.get(0);
        List<String> checkLiveTracesParams = request.getParameters("check-live-traces");
        boolean checkLiveTraces = !checkLiveTracesParams.isEmpty() && Boolean.parseBoolean(checkLiveTracesParams.get(0));
        logger.debug("handleRequest(): agentId={}, traceId={}, checkLiveTraces={}", new Object[]{agentId, traceId, checkLiveTraces});
        TraceCommonService.TraceExport traceExport = this.traceCommonService.getExport(agentId, traceId, checkLiveTraces, CassandraProfile.web);
        if (traceExport == null) {
            logger.warn("no trace found for id: {}", (Object)traceId);
            return new CommonHandler.CommonResponse(HttpResponseStatus.NOT_FOUND);
        }
        ChunkSource chunkSource = this.render(traceExport);
        CommonHandler.CommonResponse response = new CommonHandler.CommonResponse(HttpResponseStatus.OK, MediaType.ZIP, chunkSource);
        response.setZipFileName(traceExport.fileName());
        response.setHeader("Content-Disposition", "attachment; filename=" + traceExport.fileName() + ".zip");
        return response;
    }

    private ChunkSource render(TraceCommonService.TraceExport traceExport) throws IOException {
        String htmlStartTag = "<html>";
        String exportCssPlaceholder = "<link rel=\"stylesheet\" href=\"styles/export.css\">";
        String exportJsPlaceholder = "<script src=\"scripts/export.js\"></script>";
        String headerPlaceholder = "<script type=\"text/json\" id=\"headerJson\"></script>";
        String entriesPlaceholder = "<script type=\"text/json\" id=\"entriesJson\"></script>";
        String queriesPlaceholder = "<script type=\"text/json\" id=\"queriesJson\"></script>";
        String sharedQueryTextsPlaceholder = "<script type=\"text/json\" id=\"sharedQueryTextsJson\"></script>";
        String mainThreadProfilePlaceholder = "<script type=\"text/json\" id=\"mainThreadProfileJson\"></script>";
        String auxThreadProfilePlaceholder = "<script type=\"text/json\" id=\"auxThreadProfileJson\"></script>";
        String footerMessagePlaceholder = "<span id=\"footerMessage\"></span>";
        String templateContent = TraceExportHttpService.asCharSource("trace-export.html").read();
        Pattern pattern = Pattern.compile("(" + htmlStartTag + "|" + exportCssPlaceholder + "|" + exportJsPlaceholder + "|" + headerPlaceholder + "|" + entriesPlaceholder + "|" + queriesPlaceholder + "|" + sharedQueryTextsPlaceholder + "|" + mainThreadProfilePlaceholder + "|" + auxThreadProfilePlaceholder + "|" + footerMessagePlaceholder + ")");
        Matcher matcher = pattern.matcher(templateContent);
        int curr = 0;
        ArrayList chunkSources = Lists.newArrayList();
        while (matcher.find()) {
            chunkSources.add(ChunkSource.wrap(templateContent.substring(curr, matcher.start())));
            curr = matcher.end();
            String match = matcher.group();
            if (match.equals(htmlStartTag)) {
                chunkSources.add(ChunkSource.wrap("<!-- saved from url=(0014)about:internet -->\r\n<html>"));
                continue;
            }
            if (match.equals(exportCssPlaceholder)) {
                chunkSources.add(ChunkSource.wrap("<style>"));
                chunkSources.add(TraceExportHttpService.asChunkSource("styles/export.css"));
                chunkSources.add(ChunkSource.wrap("</style>"));
                continue;
            }
            if (match.equals(exportJsPlaceholder)) {
                chunkSources.add(ChunkSource.wrap("<script>"));
                chunkSources.add(TraceExportHttpService.asChunkSource("scripts/export.js"));
                chunkSources.add(ChunkSource.wrap("</script>"));
                continue;
            }
            if (match.equals(headerPlaceholder)) {
                chunkSources.add(ChunkSource.wrap("<script type=\"text/json\" id=\"headerJson\">"));
                chunkSources.add(ChunkSource.wrap(traceExport.headerJson()));
                chunkSources.add(ChunkSource.wrap("</script>"));
                continue;
            }
            if (match.equals(entriesPlaceholder)) {
                chunkSources.add(ChunkSource.wrap("<script type=\"text/json\" id=\"entriesJson\">"));
                String entriesJson = traceExport.entriesJson();
                if (entriesJson != null) {
                    chunkSources.add(ChunkSource.wrap(entriesJson));
                }
                chunkSources.add(ChunkSource.wrap("</script>"));
                continue;
            }
            if (match.equals(queriesPlaceholder)) {
                chunkSources.add(ChunkSource.wrap("<script type=\"text/json\" id=\"queriesJson\">"));
                String queriesJson = traceExport.queriesJson();
                if (queriesJson != null) {
                    chunkSources.add(ChunkSource.wrap(queriesJson));
                }
                chunkSources.add(ChunkSource.wrap("</script>"));
                continue;
            }
            if (match.equals(sharedQueryTextsPlaceholder)) {
                chunkSources.add(ChunkSource.wrap("<script type=\"text/json\" id=\"sharedQueryTextsJson\">"));
                String sharedQueryTextsJson = traceExport.sharedQueryTextsJson();
                if (sharedQueryTextsJson != null) {
                    chunkSources.add(ChunkSource.wrap(sharedQueryTextsJson));
                }
                chunkSources.add(ChunkSource.wrap("</script>"));
                continue;
            }
            if (match.equals(mainThreadProfilePlaceholder)) {
                chunkSources.add(ChunkSource.wrap("<script type=\"text/json\" id=\"mainThreadProfileJson\">"));
                String mainThreadProfileJson = traceExport.mainThreadProfileJson();
                if (mainThreadProfileJson != null) {
                    chunkSources.add(ChunkSource.wrap(mainThreadProfileJson));
                }
                chunkSources.add(ChunkSource.wrap("</script>"));
                continue;
            }
            if (match.equals(auxThreadProfilePlaceholder)) {
                chunkSources.add(ChunkSource.wrap("<script type=\"text/json\" id=\"auxThreadProfileJson\">"));
                String auxThreadProfileJson = traceExport.auxThreadProfileJson();
                if (auxThreadProfileJson != null) {
                    chunkSources.add(ChunkSource.wrap(auxThreadProfileJson));
                }
                chunkSources.add(ChunkSource.wrap("</script>"));
                continue;
            }
            if (match.equals(footerMessagePlaceholder)) {
                chunkSources.add(ChunkSource.wrap("Glowroot version " + this.version));
                continue;
            }
            logger.error("unexpected match: {}", (Object)match);
        }
        chunkSources.add(ChunkSource.wrap(templateContent.substring(curr)));
        return ChunkSource.concat(chunkSources);
    }

    private static ChunkSource asChunkSource(String exportResourceName) {
        return ChunkSource.create(TraceExportHttpService.asCharSource(exportResourceName));
    }

    private static CharSource asCharSource(String exportResourceName) {
        URL url = TraceExportHttpService.class.getResource("/org/glowroot/agent/embedded/shaded/org/glowroot/ui/export-dist/" + exportResourceName);
        return Resources.asCharSource((URL)((URL)Preconditions.checkNotNull((Object)url)), (Charset)Charsets.UTF_8);
    }
}

