/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.com.google.common.base.CaseFormat;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.cache.CacheBuilder;
import org.glowroot.agent.shaded.com.google.common.cache.CacheLoader;
import org.glowroot.agent.shaded.com.google.common.cache.LoadingCache;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;

class QueryStrings {
    private static LoadingCache<Class<?>, Map<String, Method>> settersCache = CacheBuilder.newBuilder().build((CacheLoader)new SettersCacheBuilder());

    private QueryStrings() {
    }

    static <T> T decode(Map<String, List<String>> queryParameters, Class<T> clazz) throws Exception {
        Class<?> immutableClass = QueryStrings.getImmutableClass(clazz);
        Method builderMethod = immutableClass.getDeclaredMethod("builder", new Class[0]);
        Object builder = builderMethod.invoke(null, new Object[0]);
        Preconditions.checkNotNull((Object)builder);
        Class<?> immutableBuilderClass = builder.getClass();
        Map setters = (Map)settersCache.getUnchecked(immutableBuilderClass);
        for (Map.Entry<String, List<String>> entry : queryParameters.entrySet()) {
            Object value;
            String key = entry.getKey();
            key = CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, key);
            key = key.replace("Mbean", "MBean");
            Method setter = (Method)setters.get(key);
            Preconditions.checkNotNull((Object)setter, (String)"Unexpected attribute: %s", (Object)key);
            Type valueType = setter.getGenericParameterTypes()[0];
            if (valueType instanceof ParameterizedType) {
                valueType = ((ParameterizedType)valueType).getActualTypeArguments()[0];
                ArrayList parsedValues = Lists.newArrayList();
                for (String stringValue : entry.getValue()) {
                    Object parsedValue = QueryStrings.parseString(stringValue, (Class)valueType);
                    if (parsedValue == null) continue;
                    parsedValues.add(parsedValue);
                }
                value = parsedValues;
            } else {
                value = QueryStrings.parseString(entry.getValue().get(0), (Class)valueType);
            }
            setter.invoke(builder, value);
        }
        Method build = immutableBuilderClass.getDeclaredMethod("build", new Class[0]);
        Object decoded = build.invoke(builder, new Object[0]);
        return (T)Preconditions.checkNotNull((Object)decoded);
    }

    static <T> Class<?> getImmutableClass(Class<T> clazz) throws ClassNotFoundException {
        String prefix = "";
        Package pkg = clazz.getPackage();
        if (pkg != null) {
            prefix = pkg.getName() + '.';
        }
        String immutableClassName = prefix + "Immutable" + clazz.getSimpleName();
        return Class.forName(immutableClassName, false, clazz.getClassLoader());
    }

    private static @Nullable Object parseString(String str, Class<?> targetClass) {
        if (targetClass == String.class) {
            return str;
        }
        if (QueryStrings.isInteger(targetClass)) {
            return (int)Double.parseDouble(str);
        }
        if (QueryStrings.isLong(targetClass)) {
            return (long)Double.parseDouble(str);
        }
        if (QueryStrings.isDouble(targetClass)) {
            return Double.parseDouble(str);
        }
        if (QueryStrings.isBoolean(targetClass)) {
            return Boolean.parseBoolean(str);
        }
        if (Enum.class.isAssignableFrom(targetClass)) {
            Enum enumValue = Enum.valueOf(targetClass.asSubclass(Enum.class), str.replace('-', '_').toUpperCase(Locale.ENGLISH));
            return enumValue;
        }
        throw new IllegalStateException("Unexpected class: " + targetClass);
    }

    private static boolean isInteger(Class<?> targetClass) {
        return targetClass == Integer.TYPE || targetClass == Integer.class;
    }

    private static boolean isLong(Class<?> targetClass) {
        return targetClass == Long.TYPE || targetClass == Long.class;
    }

    private static boolean isDouble(Class<?> targetClass) {
        return targetClass == Double.TYPE || targetClass == Double.class;
    }

    private static boolean isBoolean(Class<?> targetClass) {
        return targetClass == Boolean.TYPE || targetClass == Boolean.class;
    }

    private static class SettersCacheBuilder
    extends CacheLoader<Class<?>, Map<String, Method>> {
        private SettersCacheBuilder() {
        }

        public Map<String, Method> load(Class<?> key) throws Exception {
            HashMap setters = Maps.newHashMap();
            for (Method method : key.getMethods()) {
                if (method.getName().startsWith("add") && !method.getName().startsWith("addAll") || method.getParameterTypes().length != 1 || !SettersCacheBuilder.isSimpleSetter(method.getParameterTypes()[0])) continue;
                method.setAccessible(true);
                if (method.getName().startsWith("addAll")) {
                    String propertyName = method.getName().substring(6);
                    propertyName = Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
                    setters.put(propertyName, method);
                    continue;
                }
                setters.put(method.getName(), method);
            }
            return setters;
        }

        private static boolean isSimpleSetter(Class<?> targetClass) {
            return targetClass == String.class || QueryStrings.isInteger(targetClass) || QueryStrings.isLong(targetClass) || QueryStrings.isDouble(targetClass) || QueryStrings.isBoolean(targetClass) || Enum.class.isAssignableFrom(targetClass) || targetClass == Iterable.class;
        }
    }
}

