/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.AgentDisplayRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.IncidentRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.SyntheticResultRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.AlertConfigJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindAuthentication;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GET;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.HttpSessionManager;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableDisplayedIncident;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableIncidentResponse;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonServiceException;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.common.primitives.Ints;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.glowroot.agent.shaded.org.glowroot.common.util.ObjectMappers;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.immutables.value.Value;

@JsonService
class IncidentJsonService {
    private static final String EMBEDDED_AGENT_ID = "";
    private static final ObjectMapper mapper = ObjectMappers.create((Module[])new Module[0]);
    private final boolean central;
    private final IncidentRepository incidentRepository;
    private final AgentDisplayRepository agentDisplayRepository;
    private final ConfigRepository configRepository;
    private final @Nullable SyntheticResultRepository syntheticResultRepository;
    private final Clock clock;

    IncidentJsonService(boolean central, IncidentRepository incidentRepository, AgentDisplayRepository agentDisplayRepository, ConfigRepository configRepository, @Nullable SyntheticResultRepository syntheticResultRepository, Clock clock) {
        this.central = central;
        this.incidentRepository = incidentRepository;
        this.agentDisplayRepository = agentDisplayRepository;
        this.configRepository = configRepository;
        this.syntheticResultRepository = syntheticResultRepository;
        this.clock = clock;
    }

    @GET(path="/backend/incidents", permission="")
    String getIncidents(@BindAuthentication HttpSessionManager.Authentication authentication) throws Exception {
        if (!this.central && !authentication.isPermitted(EMBEDDED_AGENT_ID, "agent:incident")) {
            throw new JsonServiceException(HttpResponseStatus.FORBIDDEN);
        }
        ImmutableIncidentResponse.Builder response = ImmutableIncidentResponse.builder();
        List openIncidents = new BySeverityOrdering().compound((Comparator)((Object)new ByOpenTimeOrdering())).sortedCopy((Iterable)this.incidentRepository.readAllOpenIncidents(CassandraProfile.web).toCompletableFuture().get());
        for (IncidentRepository.OpenIncident openIncident : openIncidents) {
            if (!authentication.isPermittedForAgentRollup(openIncident.agentRollupId(), "agent:incident")) continue;
            response.addOpenIncidents(this.createDisplayedIncident(openIncident));
        }
        List<IncidentRepository.ResolvedIncident> resolvedIncidents = this.incidentRepository.readResolvedIncidents(this.clock.currentTimeMillis() - TimeUnit.DAYS.toMillis(30L)).toCompletableFuture().get();
        for (IncidentRepository.ResolvedIncident resolvedIncident : resolvedIncidents) {
            if (!authentication.isPermittedForAgentRollup(resolvedIncident.agentRollupId(), "agent:incident")) continue;
            response.addResolvedIncidents(this.createDisplayedIncident(resolvedIncident));
        }
        return mapper.writeValueAsString((Object)response.build());
    }

    private DisplayedIncident createDisplayedIncident(IncidentRepository.OpenIncident incident) throws Exception {
        ImmutableDisplayedIncident.Builder builder = ImmutableDisplayedIncident.builder().agentRollupDisplay(this.agentDisplayRepository.readFullDisplay(incident.agentRollupId()).toCompletableFuture().get()).openTime(incident.openTime()).durationMillis(this.clock.currentTimeMillis() - incident.openTime()).severity(IncidentJsonService.toString(incident.severity())).display(AlertConfigJsonService.getConditionDisplay(incident.agentRollupId(), incident.condition(), this.clock.currentTimeMillis(), this.configRepository, this.syntheticResultRepository)).agentRollupId(incident.agentRollupId());
        IncidentJsonService.setConditionFields(builder, incident.condition());
        return builder.build();
    }

    private DisplayedIncident createDisplayedIncident(IncidentRepository.ResolvedIncident incident) throws Exception {
        ImmutableDisplayedIncident.Builder builder = ImmutableDisplayedIncident.builder().agentRollupDisplay(this.agentDisplayRepository.readFullDisplay(incident.agentRollupId()).toCompletableFuture().get()).openTime(incident.openTime()).durationMillis(incident.resolveTime() - incident.openTime()).resolveTime(incident.resolveTime()).severity(IncidentJsonService.toString(incident.severity())).display(AlertConfigJsonService.getConditionDisplay(incident.agentRollupId(), incident.condition(), incident.resolveTime(), this.configRepository, this.syntheticResultRepository)).agentRollupId(incident.agentRollupId());
        IncidentJsonService.setConditionFields(builder, incident.condition());
        return builder.build();
    }

    private static void setConditionFields(ImmutableDisplayedIncident.Builder builder, AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition condition) {
        AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.ValCase conditionType = condition.getValCase();
        if (conditionType == AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.ValCase.METRIC_CONDITION) {
            AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.MetricCondition metricCondition = condition.getMetricCondition();
            builder.conditionType("metric").metric(metricCondition.getMetric()).transactionType(metricCondition.getTransactionType()).transactionName(metricCondition.getTransactionName()).timePeriodSeconds(metricCondition.getTimePeriodSeconds());
            if (metricCondition.hasPercentile()) {
                builder.percentile(metricCondition.getPercentile().getValue());
            }
        } else if (conditionType == AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.ValCase.SYNTHETIC_MONITOR_CONDITION) {
            AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.SyntheticMonitorCondition syntheticMonitorCondition = condition.getSyntheticMonitorCondition();
            builder.conditionType("synthetic-monitor").syntheticMonitorId(syntheticMonitorCondition.getSyntheticMonitorId()).thresholdMillis(syntheticMonitorCondition.getThresholdMillis());
        } else if (conditionType == AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.ValCase.HEARTBEAT_CONDITION) {
            builder.conditionType("heartbeat").timePeriodSeconds(condition.getHeartbeatCondition().getTimePeriodSeconds());
        } else {
            throw new IllegalStateException("Unexpected alert condition type: " + conditionType);
        }
    }

    private static String toString(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertSeverity alertSeverity) {
        String name = alertSeverity.name();
        return name.substring(0, 1) + name.substring(1).toLowerCase(Locale.ENGLISH);
    }

    @Value.Immutable
    static interface IncidentResponse {
        public List<DisplayedIncident> openIncidents();

        public List<DisplayedIncident> resolvedIncidents();
    }

    @Value.Immutable
    static interface DisplayedIncident {
        public String agentRollupDisplay();

        public long openTime();

        public long durationMillis();

        public @Nullable Long resolveTime();

        public String severity();

        public String display();

        public String agentRollupId();

        public String conditionType();

        public @Nullable String metric();

        public @Nullable String transactionType();

        public @Nullable String transactionName();

        public @Nullable Double percentile();

        public @Nullable String syntheticMonitorId();

        public @Nullable Integer thresholdMillis();

        public @Nullable Integer timePeriodSeconds();
    }

    private static class ByOpenTimeOrdering
    extends Ordering<IncidentRepository.OpenIncident> {
        private ByOpenTimeOrdering() {
        }

        public int compare(IncidentRepository.OpenIncident left, IncidentRepository.OpenIncident right) {
            return Longs.compare((long)left.openTime(), (long)right.openTime());
        }
    }

    private static class BySeverityOrdering
    extends Ordering<IncidentRepository.OpenIncident> {
        private BySeverityOrdering() {
        }

        public int compare(IncidentRepository.OpenIncident left, IncidentRepository.OpenIncident right) {
            return Ints.compare((int)left.severity().getNumber(), (int)right.severity().getNumber());
        }
    }
}

