/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.LayoutService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LayoutService.Permissions", generator="Immutables")
@Immutable
final class ImmutablePermissions
extends LayoutService.Permissions {
    private final LayoutService.TransactionPermissions transaction;
    private final LayoutService.ErrorPermissions error;
    private final LayoutService.JvmPermissions jvm;
    private final boolean syntheticMonitor;
    private final boolean incident;
    private final LayoutService.ConfigPermissions config;

    private ImmutablePermissions(LayoutService.TransactionPermissions transaction, LayoutService.ErrorPermissions error, LayoutService.JvmPermissions jvm, boolean syntheticMonitor, boolean incident, LayoutService.ConfigPermissions config) {
        this.transaction = transaction;
        this.error = error;
        this.jvm = jvm;
        this.syntheticMonitor = syntheticMonitor;
        this.incident = incident;
        this.config = config;
    }

    @Override
    @JsonProperty(value="transaction")
    LayoutService.TransactionPermissions transaction() {
        return this.transaction;
    }

    @Override
    @JsonProperty(value="error")
    LayoutService.ErrorPermissions error() {
        return this.error;
    }

    @Override
    @JsonProperty(value="jvm")
    LayoutService.JvmPermissions jvm() {
        return this.jvm;
    }

    @Override
    @JsonProperty(value="syntheticMonitor")
    boolean syntheticMonitor() {
        return this.syntheticMonitor;
    }

    @Override
    @JsonProperty(value="incident")
    boolean incident() {
        return this.incident;
    }

    @Override
    @JsonProperty(value="config")
    LayoutService.ConfigPermissions config() {
        return this.config;
    }

    public final ImmutablePermissions withTransaction(LayoutService.TransactionPermissions value) {
        if (this.transaction == value) {
            return this;
        }
        LayoutService.TransactionPermissions newValue = Objects.requireNonNull(value, "transaction");
        return new ImmutablePermissions(newValue, this.error, this.jvm, this.syntheticMonitor, this.incident, this.config);
    }

    public final ImmutablePermissions withError(LayoutService.ErrorPermissions value) {
        if (this.error == value) {
            return this;
        }
        LayoutService.ErrorPermissions newValue = Objects.requireNonNull(value, "error");
        return new ImmutablePermissions(this.transaction, newValue, this.jvm, this.syntheticMonitor, this.incident, this.config);
    }

    public final ImmutablePermissions withJvm(LayoutService.JvmPermissions value) {
        if (this.jvm == value) {
            return this;
        }
        LayoutService.JvmPermissions newValue = Objects.requireNonNull(value, "jvm");
        return new ImmutablePermissions(this.transaction, this.error, newValue, this.syntheticMonitor, this.incident, this.config);
    }

    public final ImmutablePermissions withSyntheticMonitor(boolean value) {
        if (this.syntheticMonitor == value) {
            return this;
        }
        return new ImmutablePermissions(this.transaction, this.error, this.jvm, value, this.incident, this.config);
    }

    public final ImmutablePermissions withIncident(boolean value) {
        if (this.incident == value) {
            return this;
        }
        return new ImmutablePermissions(this.transaction, this.error, this.jvm, this.syntheticMonitor, value, this.config);
    }

    public final ImmutablePermissions withConfig(LayoutService.ConfigPermissions value) {
        if (this.config == value) {
            return this;
        }
        LayoutService.ConfigPermissions newValue = Objects.requireNonNull(value, "config");
        return new ImmutablePermissions(this.transaction, this.error, this.jvm, this.syntheticMonitor, this.incident, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePermissions && this.equalTo(0, (ImmutablePermissions)another);
    }

    private boolean equalTo(int synthetic, ImmutablePermissions another) {
        return this.transaction.equals(another.transaction) && this.error.equals(another.error) && this.jvm.equals(another.jvm) && this.syntheticMonitor == another.syntheticMonitor && this.incident == another.incident && this.config.equals(another.config);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transaction.hashCode();
        h += (h << 5) + this.error.hashCode();
        h += (h << 5) + this.jvm.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.syntheticMonitor);
        h += (h << 5) + Booleans.hashCode((boolean)this.incident);
        h += (h << 5) + this.config.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Permissions").omitNullValues().add("transaction", (Object)this.transaction).add("error", (Object)this.error).add("jvm", (Object)this.jvm).add("syntheticMonitor", this.syntheticMonitor).add("incident", this.incident).add("config", (Object)this.config).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePermissions fromJson(Json json) {
        Builder builder = ImmutablePermissions.builder();
        if (json.transaction != null) {
            builder.transaction(json.transaction);
        }
        if (json.error != null) {
            builder.error(json.error);
        }
        if (json.jvm != null) {
            builder.jvm(json.jvm);
        }
        if (json.syntheticMonitorIsSet) {
            builder.syntheticMonitor(json.syntheticMonitor);
        }
        if (json.incidentIsSet) {
            builder.incident(json.incident);
        }
        if (json.config != null) {
            builder.config(json.config);
        }
        return builder.build();
    }

    public static ImmutablePermissions copyOf(LayoutService.Permissions instance) {
        if (instance instanceof ImmutablePermissions) {
            return (ImmutablePermissions)instance;
        }
        return ImmutablePermissions.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LayoutService.Permissions", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRANSACTION = 1L;
        private static final long INIT_BIT_ERROR = 2L;
        private static final long INIT_BIT_JVM = 4L;
        private static final long INIT_BIT_SYNTHETIC_MONITOR = 8L;
        private static final long INIT_BIT_INCIDENT = 16L;
        private static final long INIT_BIT_CONFIG = 32L;
        private long initBits = 63L;
        @Nullable
        private LayoutService.TransactionPermissions transaction;
        @Nullable
        private LayoutService.ErrorPermissions error;
        @Nullable
        private LayoutService.JvmPermissions jvm;
        private boolean syntheticMonitor;
        private boolean incident;
        @Nullable
        private LayoutService.ConfigPermissions config;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(LayoutService.Permissions instance) {
            Objects.requireNonNull(instance, "instance");
            this.transaction(instance.transaction());
            this.error(instance.error());
            this.jvm(instance.jvm());
            this.syntheticMonitor(instance.syntheticMonitor());
            this.incident(instance.incident());
            this.config(instance.config());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transaction(LayoutService.TransactionPermissions transaction) {
            this.transaction = Objects.requireNonNull(transaction, "transaction");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder error(LayoutService.ErrorPermissions error) {
            this.error = Objects.requireNonNull(error, "error");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder jvm(LayoutService.JvmPermissions jvm) {
            this.jvm = Objects.requireNonNull(jvm, "jvm");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder syntheticMonitor(boolean syntheticMonitor) {
            this.syntheticMonitor = syntheticMonitor;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder incident(boolean incident) {
            this.incident = incident;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder config(LayoutService.ConfigPermissions config) {
            this.config = Objects.requireNonNull(config, "config");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutablePermissions build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePermissions(this.transaction, this.error, this.jvm, this.syntheticMonitor, this.incident, this.config);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transaction");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("error");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("jvm");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("syntheticMonitor");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("incident");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("config");
            }
            return "Cannot build Permissions, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LayoutService.Permissions", generator="Immutables")
    static final class Json
    extends LayoutService.Permissions {
        @Nullable
        LayoutService.TransactionPermissions transaction;
        @Nullable
        LayoutService.ErrorPermissions error;
        @Nullable
        LayoutService.JvmPermissions jvm;
        boolean syntheticMonitor;
        boolean syntheticMonitorIsSet;
        boolean incident;
        boolean incidentIsSet;
        @Nullable
        LayoutService.ConfigPermissions config;

        Json() {
        }

        @JsonProperty(value="transaction")
        public void setTransaction(LayoutService.TransactionPermissions transaction) {
            this.transaction = transaction;
        }

        @JsonProperty(value="error")
        public void setError(LayoutService.ErrorPermissions error) {
            this.error = error;
        }

        @JsonProperty(value="jvm")
        public void setJvm(LayoutService.JvmPermissions jvm) {
            this.jvm = jvm;
        }

        @JsonProperty(value="syntheticMonitor")
        public void setSyntheticMonitor(boolean syntheticMonitor) {
            this.syntheticMonitor = syntheticMonitor;
            this.syntheticMonitorIsSet = true;
        }

        @JsonProperty(value="incident")
        public void setIncident(boolean incident) {
            this.incident = incident;
            this.incidentIsSet = true;
        }

        @JsonProperty(value="config")
        public void setConfig(LayoutService.ConfigPermissions config) {
            this.config = config;
        }

        @Override
        LayoutService.TransactionPermissions transaction() {
            throw new UnsupportedOperationException();
        }

        @Override
        LayoutService.ErrorPermissions error() {
            throw new UnsupportedOperationException();
        }

        @Override
        LayoutService.JvmPermissions jvm() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean syntheticMonitor() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean incident() {
            throw new UnsupportedOperationException();
        }

        @Override
        LayoutService.ConfigPermissions config() {
            throw new UnsupportedOperationException();
        }
    }
}

