/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.AggregateMerging;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.TransactionJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TransactionJsonService.PercentileMergedAggregate", generator="Immutables")
@Immutable
final class ImmutablePercentileMergedAggregate
implements TransactionJsonService.PercentileMergedAggregate {
    private final long transactionCount;
    private final double totalDurationNanos;
    private final ImmutableList<AggregateMerging.PercentileValue> percentileValues;

    private ImmutablePercentileMergedAggregate(long transactionCount, double totalDurationNanos, ImmutableList<AggregateMerging.PercentileValue> percentileValues) {
        this.transactionCount = transactionCount;
        this.totalDurationNanos = totalDurationNanos;
        this.percentileValues = percentileValues;
    }

    @Override
    @JsonProperty(value="transactionCount")
    public long transactionCount() {
        return this.transactionCount;
    }

    @Override
    @JsonProperty(value="totalDurationNanos")
    public double totalDurationNanos() {
        return this.totalDurationNanos;
    }

    @Override
    @JsonProperty(value="percentileValues")
    public ImmutableList<AggregateMerging.PercentileValue> percentileValues() {
        return this.percentileValues;
    }

    public final ImmutablePercentileMergedAggregate withTransactionCount(long value) {
        if (this.transactionCount == value) {
            return this;
        }
        return new ImmutablePercentileMergedAggregate(value, this.totalDurationNanos, this.percentileValues);
    }

    public final ImmutablePercentileMergedAggregate withTotalDurationNanos(double value) {
        if (Double.doubleToLongBits(this.totalDurationNanos) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutablePercentileMergedAggregate(this.transactionCount, value, this.percentileValues);
    }

    public final ImmutablePercentileMergedAggregate withPercentileValues(AggregateMerging.PercentileValue ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutablePercentileMergedAggregate(this.transactionCount, this.totalDurationNanos, (ImmutableList<AggregateMerging.PercentileValue>)newValue);
    }

    public final ImmutablePercentileMergedAggregate withPercentileValues(Iterable<? extends AggregateMerging.PercentileValue> elements) {
        if (this.percentileValues == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutablePercentileMergedAggregate(this.transactionCount, this.totalDurationNanos, (ImmutableList<AggregateMerging.PercentileValue>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePercentileMergedAggregate && this.equalTo(0, (ImmutablePercentileMergedAggregate)another);
    }

    private boolean equalTo(int synthetic, ImmutablePercentileMergedAggregate another) {
        return this.transactionCount == another.transactionCount && Double.doubleToLongBits(this.totalDurationNanos) == Double.doubleToLongBits(another.totalDurationNanos) && this.percentileValues.equals(another.percentileValues);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.transactionCount);
        h += (h << 5) + Doubles.hashCode((double)this.totalDurationNanos);
        h += (h << 5) + this.percentileValues.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PercentileMergedAggregate").omitNullValues().add("transactionCount", this.transactionCount).add("totalDurationNanos", this.totalDurationNanos).add("percentileValues", this.percentileValues).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePercentileMergedAggregate fromJson(Json json) {
        Builder builder = ImmutablePercentileMergedAggregate.builder();
        if (json.transactionCountIsSet) {
            builder.transactionCount(json.transactionCount);
        }
        if (json.totalDurationNanosIsSet) {
            builder.totalDurationNanos(json.totalDurationNanos);
        }
        if (json.percentileValues != null) {
            builder.addAllPercentileValues((Iterable<? extends AggregateMerging.PercentileValue>)json.percentileValues);
        }
        return builder.build();
    }

    public static ImmutablePercentileMergedAggregate copyOf(TransactionJsonService.PercentileMergedAggregate instance) {
        if (instance instanceof ImmutablePercentileMergedAggregate) {
            return (ImmutablePercentileMergedAggregate)instance;
        }
        return ImmutablePercentileMergedAggregate.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TransactionJsonService.PercentileMergedAggregate", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRANSACTION_COUNT = 1L;
        private static final long INIT_BIT_TOTAL_DURATION_NANOS = 2L;
        private long initBits = 3L;
        private long transactionCount;
        private double totalDurationNanos;
        private ImmutableList.Builder<AggregateMerging.PercentileValue> percentileValues = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(TransactionJsonService.PercentileMergedAggregate instance) {
            Objects.requireNonNull(instance, "instance");
            this.transactionCount(instance.transactionCount());
            this.totalDurationNanos(instance.totalDurationNanos());
            this.addAllPercentileValues((Iterable<? extends AggregateMerging.PercentileValue>)instance.percentileValues());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactionCount(long transactionCount) {
            this.transactionCount = transactionCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder totalDurationNanos(double totalDurationNanos) {
            this.totalDurationNanos = totalDurationNanos;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPercentileValues(AggregateMerging.PercentileValue element) {
            this.percentileValues.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPercentileValues(AggregateMerging.PercentileValue ... elements) {
            this.percentileValues.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder percentileValues(Iterable<? extends AggregateMerging.PercentileValue> elements) {
            this.percentileValues = ImmutableList.builder();
            return this.addAllPercentileValues(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPercentileValues(Iterable<? extends AggregateMerging.PercentileValue> elements) {
            this.percentileValues.addAll(elements);
            return this;
        }

        public ImmutablePercentileMergedAggregate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePercentileMergedAggregate(this.transactionCount, this.totalDurationNanos, this.percentileValues.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transactionCount");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("totalDurationNanos");
            }
            return "Cannot build PercentileMergedAggregate, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TransactionJsonService.PercentileMergedAggregate", generator="Immutables")
    static final class Json
    implements TransactionJsonService.PercentileMergedAggregate {
        long transactionCount;
        boolean transactionCountIsSet;
        double totalDurationNanos;
        boolean totalDurationNanosIsSet;
        @Nullable
        ImmutableList<AggregateMerging.PercentileValue> percentileValues = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="transactionCount")
        public void setTransactionCount(long transactionCount) {
            this.transactionCount = transactionCount;
            this.transactionCountIsSet = true;
        }

        @JsonProperty(value="totalDurationNanos")
        public void setTotalDurationNanos(double totalDurationNanos) {
            this.totalDurationNanos = totalDurationNanos;
            this.totalDurationNanosIsSet = true;
        }

        @JsonProperty(value="percentileValues")
        public void setPercentileValues(ImmutableList<AggregateMerging.PercentileValue> percentileValues) {
            this.percentileValues = percentileValues;
        }

        @Override
        public long transactionCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double totalDurationNanos() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableList<AggregateMerging.PercentileValue> percentileValues() {
            throw new UnsupportedOperationException();
        }
    }
}

