/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.AlertConfigJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AlertConfigJsonService.AlertConfigDto.MetricConditionDto", generator="Immutables")
@Immutable
public final class ImmutableMetricConditionDto
extends AlertConfigJsonService.AlertConfigDto.MetricConditionDto {
    private final String metric;
    private final @org.checkerframework.checker.nullness.qual.Nullable String transactionType;
    private final @org.checkerframework.checker.nullness.qual.Nullable String transactionName;
    private final @org.checkerframework.checker.nullness.qual.Nullable Double percentile;
    private final @org.checkerframework.checker.nullness.qual.Nullable String errorMessageFilter;
    private final double threshold;
    private final boolean lowerBoundThreshold;
    private final int timePeriodSeconds;
    private final @org.checkerframework.checker.nullness.qual.Nullable Long minTransactionCount;

    private ImmutableMetricConditionDto(Builder builder) {
        this.metric = builder.metric;
        this.transactionType = builder.transactionType;
        this.transactionName = builder.transactionName;
        this.percentile = builder.percentile;
        this.errorMessageFilter = builder.errorMessageFilter;
        this.threshold = builder.threshold;
        this.timePeriodSeconds = builder.timePeriodSeconds;
        this.minTransactionCount = builder.minTransactionCount;
        this.lowerBoundThreshold = builder.lowerBoundThresholdIsSet() ? builder.lowerBoundThreshold : super.lowerBoundThreshold();
    }

    private ImmutableMetricConditionDto(String metric, @org.checkerframework.checker.nullness.qual.Nullable String transactionType, @org.checkerframework.checker.nullness.qual.Nullable String transactionName, @org.checkerframework.checker.nullness.qual.Nullable Double percentile, @org.checkerframework.checker.nullness.qual.Nullable String errorMessageFilter, double threshold, boolean lowerBoundThreshold, int timePeriodSeconds, @org.checkerframework.checker.nullness.qual.Nullable Long minTransactionCount) {
        this.metric = metric;
        this.transactionType = transactionType;
        this.transactionName = transactionName;
        this.percentile = percentile;
        this.errorMessageFilter = errorMessageFilter;
        this.threshold = threshold;
        this.lowerBoundThreshold = lowerBoundThreshold;
        this.timePeriodSeconds = timePeriodSeconds;
        this.minTransactionCount = minTransactionCount;
    }

    @Override
    @JsonProperty(value="metric")
    String metric() {
        return this.metric;
    }

    @Override
    @JsonProperty(value="transactionType")
    @org.checkerframework.checker.nullness.qual.Nullable String transactionType() {
        return this.transactionType;
    }

    @Override
    @JsonProperty(value="transactionName")
    @org.checkerframework.checker.nullness.qual.Nullable String transactionName() {
        return this.transactionName;
    }

    @Override
    @JsonProperty(value="percentile")
    @org.checkerframework.checker.nullness.qual.Nullable Double percentile() {
        return this.percentile;
    }

    @Override
    @JsonProperty(value="errorMessageFilter")
    @org.checkerframework.checker.nullness.qual.Nullable String errorMessageFilter() {
        return this.errorMessageFilter;
    }

    @Override
    @JsonProperty(value="threshold")
    double threshold() {
        return this.threshold;
    }

    @Override
    @JsonProperty(value="lowerBoundThreshold")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    boolean lowerBoundThreshold() {
        return this.lowerBoundThreshold;
    }

    @Override
    @JsonProperty(value="timePeriodSeconds")
    int timePeriodSeconds() {
        return this.timePeriodSeconds;
    }

    @Override
    @JsonProperty(value="minTransactionCount")
    @org.checkerframework.checker.nullness.qual.Nullable Long minTransactionCount() {
        return this.minTransactionCount;
    }

    public final ImmutableMetricConditionDto withMetric(String value) {
        String newValue = Objects.requireNonNull(value, "metric");
        if (this.metric.equals(newValue)) {
            return this;
        }
        return new ImmutableMetricConditionDto(newValue, this.transactionType, this.transactionName, this.percentile, this.errorMessageFilter, this.threshold, this.lowerBoundThreshold, this.timePeriodSeconds, this.minTransactionCount);
    }

    public final ImmutableMetricConditionDto withTransactionType(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.transactionType, value)) {
            return this;
        }
        return new ImmutableMetricConditionDto(this.metric, value, this.transactionName, this.percentile, this.errorMessageFilter, this.threshold, this.lowerBoundThreshold, this.timePeriodSeconds, this.minTransactionCount);
    }

    public final ImmutableMetricConditionDto withTransactionName(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.transactionName, value)) {
            return this;
        }
        return new ImmutableMetricConditionDto(this.metric, this.transactionType, value, this.percentile, this.errorMessageFilter, this.threshold, this.lowerBoundThreshold, this.timePeriodSeconds, this.minTransactionCount);
    }

    public final ImmutableMetricConditionDto withPercentile(@org.checkerframework.checker.nullness.qual.Nullable Double value) {
        if (Objects.equals(this.percentile, value)) {
            return this;
        }
        return new ImmutableMetricConditionDto(this.metric, this.transactionType, this.transactionName, value, this.errorMessageFilter, this.threshold, this.lowerBoundThreshold, this.timePeriodSeconds, this.minTransactionCount);
    }

    public final ImmutableMetricConditionDto withErrorMessageFilter(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.errorMessageFilter, value)) {
            return this;
        }
        return new ImmutableMetricConditionDto(this.metric, this.transactionType, this.transactionName, this.percentile, value, this.threshold, this.lowerBoundThreshold, this.timePeriodSeconds, this.minTransactionCount);
    }

    public final ImmutableMetricConditionDto withThreshold(double value) {
        if (Double.doubleToLongBits(this.threshold) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableMetricConditionDto(this.metric, this.transactionType, this.transactionName, this.percentile, this.errorMessageFilter, value, this.lowerBoundThreshold, this.timePeriodSeconds, this.minTransactionCount);
    }

    public final ImmutableMetricConditionDto withLowerBoundThreshold(boolean value) {
        if (this.lowerBoundThreshold == value) {
            return this;
        }
        return new ImmutableMetricConditionDto(this.metric, this.transactionType, this.transactionName, this.percentile, this.errorMessageFilter, this.threshold, value, this.timePeriodSeconds, this.minTransactionCount);
    }

    public final ImmutableMetricConditionDto withTimePeriodSeconds(int value) {
        if (this.timePeriodSeconds == value) {
            return this;
        }
        return new ImmutableMetricConditionDto(this.metric, this.transactionType, this.transactionName, this.percentile, this.errorMessageFilter, this.threshold, this.lowerBoundThreshold, value, this.minTransactionCount);
    }

    public final ImmutableMetricConditionDto withMinTransactionCount(@org.checkerframework.checker.nullness.qual.Nullable Long value) {
        if (Objects.equals(this.minTransactionCount, value)) {
            return this;
        }
        return new ImmutableMetricConditionDto(this.metric, this.transactionType, this.transactionName, this.percentile, this.errorMessageFilter, this.threshold, this.lowerBoundThreshold, this.timePeriodSeconds, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMetricConditionDto && this.equalTo(0, (ImmutableMetricConditionDto)another);
    }

    private boolean equalTo(int synthetic, ImmutableMetricConditionDto another) {
        return this.metric.equals(another.metric) && Objects.equals(this.transactionType, another.transactionType) && Objects.equals(this.transactionName, another.transactionName) && Objects.equals(this.percentile, another.percentile) && Objects.equals(this.errorMessageFilter, another.errorMessageFilter) && Double.doubleToLongBits(this.threshold) == Double.doubleToLongBits(another.threshold) && this.lowerBoundThreshold == another.lowerBoundThreshold && this.timePeriodSeconds == another.timePeriodSeconds && Objects.equals(this.minTransactionCount, another.minTransactionCount);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.metric.hashCode();
        h += (h << 5) + Objects.hashCode(this.transactionType);
        h += (h << 5) + Objects.hashCode(this.transactionName);
        h += (h << 5) + Objects.hashCode(this.percentile);
        h += (h << 5) + Objects.hashCode(this.errorMessageFilter);
        h += (h << 5) + Doubles.hashCode((double)this.threshold);
        h += (h << 5) + Booleans.hashCode((boolean)this.lowerBoundThreshold);
        h += (h << 5) + this.timePeriodSeconds;
        h += (h << 5) + Objects.hashCode(this.minTransactionCount);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MetricConditionDto").omitNullValues().add("metric", (Object)this.metric).add("transactionType", (Object)this.transactionType).add("transactionName", (Object)this.transactionName).add("percentile", (Object)this.percentile).add("errorMessageFilter", (Object)this.errorMessageFilter).add("threshold", this.threshold).add("lowerBoundThreshold", this.lowerBoundThreshold).add("timePeriodSeconds", this.timePeriodSeconds).add("minTransactionCount", (Object)this.minTransactionCount).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMetricConditionDto fromJson(Json json) {
        Builder builder = ImmutableMetricConditionDto.builder();
        if (json.metric != null) {
            builder.metric(json.metric);
        }
        if (json.transactionType != null) {
            builder.transactionType(json.transactionType);
        }
        if (json.transactionName != null) {
            builder.transactionName(json.transactionName);
        }
        if (json.percentile != null) {
            builder.percentile(json.percentile);
        }
        if (json.errorMessageFilter != null) {
            builder.errorMessageFilter(json.errorMessageFilter);
        }
        if (json.thresholdIsSet) {
            builder.threshold(json.threshold);
        }
        if (json.lowerBoundThresholdIsSet) {
            builder.lowerBoundThreshold(json.lowerBoundThreshold);
        }
        if (json.timePeriodSecondsIsSet) {
            builder.timePeriodSeconds(json.timePeriodSeconds);
        }
        if (json.minTransactionCount != null) {
            builder.minTransactionCount(json.minTransactionCount);
        }
        return builder.build();
    }

    public static ImmutableMetricConditionDto copyOf(AlertConfigJsonService.AlertConfigDto.MetricConditionDto instance) {
        if (instance instanceof ImmutableMetricConditionDto) {
            return (ImmutableMetricConditionDto)instance;
        }
        return ImmutableMetricConditionDto.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AlertConfigJsonService.AlertConfigDto.MetricConditionDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_METRIC = 1L;
        private static final long INIT_BIT_THRESHOLD = 2L;
        private static final long INIT_BIT_TIME_PERIOD_SECONDS = 4L;
        private static final long OPT_BIT_LOWER_BOUND_THRESHOLD = 1L;
        private long initBits = 7L;
        private long optBits;
        @Nullable
        private String metric;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String transactionType;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String transactionName;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable Double percentile;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String errorMessageFilter;
        private double threshold;
        private boolean lowerBoundThreshold;
        private int timePeriodSeconds;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable Long minTransactionCount;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(AlertConfigJsonService.AlertConfigDto.MetricConditionDto instance) {
            String errorMessageFilterValue;
            Double percentileValue;
            String transactionNameValue;
            Objects.requireNonNull(instance, "instance");
            this.metric(instance.metric());
            @org.checkerframework.checker.nullness.qual.Nullable String transactionTypeValue = instance.transactionType();
            if (transactionTypeValue != null) {
                this.transactionType(transactionTypeValue);
            }
            if ((transactionNameValue = instance.transactionName()) != null) {
                this.transactionName(transactionNameValue);
            }
            if ((percentileValue = instance.percentile()) != null) {
                this.percentile(percentileValue);
            }
            if ((errorMessageFilterValue = instance.errorMessageFilter()) != null) {
                this.errorMessageFilter(errorMessageFilterValue);
            }
            this.threshold(instance.threshold());
            this.lowerBoundThreshold(instance.lowerBoundThreshold());
            this.timePeriodSeconds(instance.timePeriodSeconds());
            @org.checkerframework.checker.nullness.qual.Nullable Long minTransactionCountValue = instance.minTransactionCount();
            if (minTransactionCountValue != null) {
                this.minTransactionCount(minTransactionCountValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metric(String metric) {
            this.metric = Objects.requireNonNull(metric, "metric");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactionType(@org.checkerframework.checker.nullness.qual.Nullable String transactionType) {
            this.transactionType = transactionType;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactionName(@org.checkerframework.checker.nullness.qual.Nullable String transactionName) {
            this.transactionName = transactionName;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder percentile(@org.checkerframework.checker.nullness.qual.Nullable Double percentile) {
            this.percentile = percentile;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder errorMessageFilter(@org.checkerframework.checker.nullness.qual.Nullable String errorMessageFilter) {
            this.errorMessageFilter = errorMessageFilter;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder threshold(double threshold) {
            this.threshold = threshold;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lowerBoundThreshold(boolean lowerBoundThreshold) {
            this.lowerBoundThreshold = lowerBoundThreshold;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder timePeriodSeconds(int timePeriodSeconds) {
            this.timePeriodSeconds = timePeriodSeconds;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder minTransactionCount(@org.checkerframework.checker.nullness.qual.Nullable Long minTransactionCount) {
            this.minTransactionCount = minTransactionCount;
            return this;
        }

        public ImmutableMetricConditionDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMetricConditionDto(this);
        }

        private boolean lowerBoundThresholdIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("metric");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("threshold");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("timePeriodSeconds");
            }
            return "Cannot build MetricConditionDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AlertConfigJsonService.AlertConfigDto.MetricConditionDto", generator="Immutables")
    static final class Json
    extends AlertConfigJsonService.AlertConfigDto.MetricConditionDto {
        @Nullable
        String metric;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable String transactionType;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable String transactionName;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable Double percentile;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable String errorMessageFilter;
        double threshold;
        boolean thresholdIsSet;
        boolean lowerBoundThreshold;
        boolean lowerBoundThresholdIsSet;
        int timePeriodSeconds;
        boolean timePeriodSecondsIsSet;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable Long minTransactionCount;

        Json() {
        }

        @JsonProperty(value="metric")
        public void setMetric(String metric) {
            this.metric = metric;
        }

        @JsonProperty(value="transactionType")
        public void setTransactionType(@org.checkerframework.checker.nullness.qual.Nullable String transactionType) {
            this.transactionType = transactionType;
        }

        @JsonProperty(value="transactionName")
        public void setTransactionName(@org.checkerframework.checker.nullness.qual.Nullable String transactionName) {
            this.transactionName = transactionName;
        }

        @JsonProperty(value="percentile")
        public void setPercentile(@org.checkerframework.checker.nullness.qual.Nullable Double percentile) {
            this.percentile = percentile;
        }

        @JsonProperty(value="errorMessageFilter")
        public void setErrorMessageFilter(@org.checkerframework.checker.nullness.qual.Nullable String errorMessageFilter) {
            this.errorMessageFilter = errorMessageFilter;
        }

        @JsonProperty(value="threshold")
        public void setThreshold(double threshold) {
            this.threshold = threshold;
            this.thresholdIsSet = true;
        }

        @JsonProperty(value="lowerBoundThreshold")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setLowerBoundThreshold(boolean lowerBoundThreshold) {
            this.lowerBoundThreshold = lowerBoundThreshold;
            this.lowerBoundThresholdIsSet = true;
        }

        @JsonProperty(value="timePeriodSeconds")
        public void setTimePeriodSeconds(int timePeriodSeconds) {
            this.timePeriodSeconds = timePeriodSeconds;
            this.timePeriodSecondsIsSet = true;
        }

        @JsonProperty(value="minTransactionCount")
        public void setMinTransactionCount(@org.checkerframework.checker.nullness.qual.Nullable Long minTransactionCount) {
            this.minTransactionCount = minTransactionCount;
        }

        @Override
        String metric() {
            throw new UnsupportedOperationException();
        }

        @Override
        @org.checkerframework.checker.nullness.qual.Nullable String transactionType() {
            throw new UnsupportedOperationException();
        }

        @Override
        @org.checkerframework.checker.nullness.qual.Nullable String transactionName() {
            throw new UnsupportedOperationException();
        }

        @Override
        @org.checkerframework.checker.nullness.qual.Nullable Double percentile() {
            throw new UnsupportedOperationException();
        }

        @Override
        @org.checkerframework.checker.nullness.qual.Nullable String errorMessageFilter() {
            throw new UnsupportedOperationException();
        }

        @Override
        double threshold() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean lowerBoundThreshold() {
            throw new UnsupportedOperationException();
        }

        @Override
        int timePeriodSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        @org.checkerframework.checker.nullness.qual.Nullable Long minTransactionCount() {
            throw new UnsupportedOperationException();
        }
    }
}

