/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.TransactionJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TransactionJsonService.FlameGraphRequest", generator="Immutables")
@Immutable
final class ImmutableFlameGraphRequest
implements TransactionJsonService.FlameGraphRequest {
    private final String transactionType;
    private final @org.checkerframework.checker.nullness.qual.Nullable String transactionName;
    private final long from;
    private final long to;
    private final boolean auxiliary;
    private final ImmutableList<String> include;
    private final ImmutableList<String> exclude;
    private final double truncateBranchPercentage;

    private ImmutableFlameGraphRequest(String transactionType, @org.checkerframework.checker.nullness.qual.Nullable String transactionName, long from, long to, boolean auxiliary, ImmutableList<String> include, ImmutableList<String> exclude, double truncateBranchPercentage) {
        this.transactionType = transactionType;
        this.transactionName = transactionName;
        this.from = from;
        this.to = to;
        this.auxiliary = auxiliary;
        this.include = include;
        this.exclude = exclude;
        this.truncateBranchPercentage = truncateBranchPercentage;
    }

    @Override
    @JsonProperty(value="transactionType")
    public String transactionType() {
        return this.transactionType;
    }

    @Override
    @JsonProperty(value="transactionName")
    public @org.checkerframework.checker.nullness.qual.Nullable String transactionName() {
        return this.transactionName;
    }

    @Override
    @JsonProperty(value="from")
    public long from() {
        return this.from;
    }

    @Override
    @JsonProperty(value="to")
    public long to() {
        return this.to;
    }

    @Override
    @JsonProperty(value="auxiliary")
    public boolean auxiliary() {
        return this.auxiliary;
    }

    @Override
    @JsonProperty(value="include")
    public ImmutableList<String> include() {
        return this.include;
    }

    @Override
    @JsonProperty(value="exclude")
    public ImmutableList<String> exclude() {
        return this.exclude;
    }

    @Override
    @JsonProperty(value="truncateBranchPercentage")
    public double truncateBranchPercentage() {
        return this.truncateBranchPercentage;
    }

    public final ImmutableFlameGraphRequest withTransactionType(String value) {
        String newValue = Objects.requireNonNull(value, "transactionType");
        if (this.transactionType.equals(newValue)) {
            return this;
        }
        return new ImmutableFlameGraphRequest(newValue, this.transactionName, this.from, this.to, this.auxiliary, this.include, this.exclude, this.truncateBranchPercentage);
    }

    public final ImmutableFlameGraphRequest withTransactionName(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.transactionName, value)) {
            return this;
        }
        return new ImmutableFlameGraphRequest(this.transactionType, value, this.from, this.to, this.auxiliary, this.include, this.exclude, this.truncateBranchPercentage);
    }

    public final ImmutableFlameGraphRequest withFrom(long value) {
        if (this.from == value) {
            return this;
        }
        return new ImmutableFlameGraphRequest(this.transactionType, this.transactionName, value, this.to, this.auxiliary, this.include, this.exclude, this.truncateBranchPercentage);
    }

    public final ImmutableFlameGraphRequest withTo(long value) {
        if (this.to == value) {
            return this;
        }
        return new ImmutableFlameGraphRequest(this.transactionType, this.transactionName, this.from, value, this.auxiliary, this.include, this.exclude, this.truncateBranchPercentage);
    }

    public final ImmutableFlameGraphRequest withAuxiliary(boolean value) {
        if (this.auxiliary == value) {
            return this;
        }
        return new ImmutableFlameGraphRequest(this.transactionType, this.transactionName, this.from, this.to, value, this.include, this.exclude, this.truncateBranchPercentage);
    }

    public final ImmutableFlameGraphRequest withInclude(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableFlameGraphRequest(this.transactionType, this.transactionName, this.from, this.to, this.auxiliary, (ImmutableList<String>)newValue, this.exclude, this.truncateBranchPercentage);
    }

    public final ImmutableFlameGraphRequest withInclude(Iterable<String> elements) {
        if (this.include == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableFlameGraphRequest(this.transactionType, this.transactionName, this.from, this.to, this.auxiliary, (ImmutableList<String>)newValue, this.exclude, this.truncateBranchPercentage);
    }

    public final ImmutableFlameGraphRequest withExclude(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableFlameGraphRequest(this.transactionType, this.transactionName, this.from, this.to, this.auxiliary, this.include, (ImmutableList<String>)newValue, this.truncateBranchPercentage);
    }

    public final ImmutableFlameGraphRequest withExclude(Iterable<String> elements) {
        if (this.exclude == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableFlameGraphRequest(this.transactionType, this.transactionName, this.from, this.to, this.auxiliary, this.include, (ImmutableList<String>)newValue, this.truncateBranchPercentage);
    }

    public final ImmutableFlameGraphRequest withTruncateBranchPercentage(double value) {
        if (Double.doubleToLongBits(this.truncateBranchPercentage) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableFlameGraphRequest(this.transactionType, this.transactionName, this.from, this.to, this.auxiliary, this.include, this.exclude, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFlameGraphRequest && this.equalTo(0, (ImmutableFlameGraphRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableFlameGraphRequest another) {
        return this.transactionType.equals(another.transactionType) && Objects.equals(this.transactionName, another.transactionName) && this.from == another.from && this.to == another.to && this.auxiliary == another.auxiliary && this.include.equals(another.include) && this.exclude.equals(another.exclude) && Double.doubleToLongBits(this.truncateBranchPercentage) == Double.doubleToLongBits(another.truncateBranchPercentage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transactionType.hashCode();
        h += (h << 5) + Objects.hashCode(this.transactionName);
        h += (h << 5) + Longs.hashCode((long)this.from);
        h += (h << 5) + Longs.hashCode((long)this.to);
        h += (h << 5) + Booleans.hashCode((boolean)this.auxiliary);
        h += (h << 5) + this.include.hashCode();
        h += (h << 5) + this.exclude.hashCode();
        h += (h << 5) + Doubles.hashCode((double)this.truncateBranchPercentage);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FlameGraphRequest").omitNullValues().add("transactionType", (Object)this.transactionType).add("transactionName", (Object)this.transactionName).add("from", this.from).add("to", this.to).add("auxiliary", this.auxiliary).add("include", this.include).add("exclude", this.exclude).add("truncateBranchPercentage", this.truncateBranchPercentage).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFlameGraphRequest fromJson(Json json) {
        Builder builder = ImmutableFlameGraphRequest.builder();
        if (json.transactionType != null) {
            builder.transactionType(json.transactionType);
        }
        if (json.transactionName != null) {
            builder.transactionName(json.transactionName);
        }
        if (json.fromIsSet) {
            builder.from(json.from);
        }
        if (json.toIsSet) {
            builder.to(json.to);
        }
        if (json.auxiliaryIsSet) {
            builder.auxiliary(json.auxiliary);
        }
        if (json.include != null) {
            builder.addAllInclude((Iterable<String>)json.include);
        }
        if (json.exclude != null) {
            builder.addAllExclude((Iterable<String>)json.exclude);
        }
        if (json.truncateBranchPercentageIsSet) {
            builder.truncateBranchPercentage(json.truncateBranchPercentage);
        }
        return builder.build();
    }

    public static ImmutableFlameGraphRequest copyOf(TransactionJsonService.FlameGraphRequest instance) {
        if (instance instanceof ImmutableFlameGraphRequest) {
            return (ImmutableFlameGraphRequest)instance;
        }
        return ImmutableFlameGraphRequest.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TransactionJsonService.FlameGraphRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRANSACTION_TYPE = 1L;
        private static final long INIT_BIT_FROM = 2L;
        private static final long INIT_BIT_TO = 4L;
        private static final long INIT_BIT_AUXILIARY = 8L;
        private static final long INIT_BIT_TRUNCATE_BRANCH_PERCENTAGE = 16L;
        private long initBits = 31L;
        @Nullable
        private String transactionType;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String transactionName;
        private long from;
        private long to;
        private boolean auxiliary;
        private ImmutableList.Builder<String> include = ImmutableList.builder();
        private ImmutableList.Builder<String> exclude = ImmutableList.builder();
        private double truncateBranchPercentage;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(TransactionJsonService.FlameGraphRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(TransactionJsonService.RequestBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String transactionNameValue;
            TransactionJsonService.RequestBase instance;
            long bits = 0L;
            if (object instanceof TransactionJsonService.FlameGraphRequest) {
                instance = (TransactionJsonService.FlameGraphRequest)object;
                if ((bits & 2L) == 0L) {
                    this.transactionType(instance.transactionType());
                    bits |= 2L;
                }
                this.addAllInclude((Iterable<String>)instance.include());
                this.auxiliary(instance.auxiliary());
                this.truncateBranchPercentage(instance.truncateBranchPercentage());
                if ((bits & 4L) == 0L) {
                    this.from(instance.from());
                    bits |= 4L;
                }
                this.addAllExclude((Iterable<String>)instance.exclude());
                if ((bits & 8L) == 0L) {
                    this.to(instance.to());
                    bits |= 8L;
                }
                if ((bits & 1L) == 0L) {
                    transactionNameValue = instance.transactionName();
                    if (transactionNameValue != null) {
                        this.transactionName(transactionNameValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof TransactionJsonService.RequestBase) {
                instance = (TransactionJsonService.RequestBase)object;
                if ((bits & 2L) == 0L) {
                    this.transactionType(instance.transactionType());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.from(instance.from());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.to(instance.to());
                    bits |= 8L;
                }
                if ((bits & 1L) == 0L) {
                    transactionNameValue = instance.transactionName();
                    if (transactionNameValue != null) {
                        this.transactionName(transactionNameValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder transactionType(String transactionType) {
            this.transactionType = Objects.requireNonNull(transactionType, "transactionType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactionName(@org.checkerframework.checker.nullness.qual.Nullable String transactionName) {
            this.transactionName = transactionName;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(long from) {
            this.from = from;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder to(long to) {
            this.to = to;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder auxiliary(boolean auxiliary) {
            this.auxiliary = auxiliary;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInclude(String element) {
            this.include.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInclude(String ... elements) {
            this.include.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder include(Iterable<String> elements) {
            this.include = ImmutableList.builder();
            return this.addAllInclude(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllInclude(Iterable<String> elements) {
            this.include.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExclude(String element) {
            this.exclude.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExclude(String ... elements) {
            this.exclude.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder exclude(Iterable<String> elements) {
            this.exclude = ImmutableList.builder();
            return this.addAllExclude(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExclude(Iterable<String> elements) {
            this.exclude.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder truncateBranchPercentage(double truncateBranchPercentage) {
            this.truncateBranchPercentage = truncateBranchPercentage;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableFlameGraphRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFlameGraphRequest(this.transactionType, this.transactionName, this.from, this.to, this.auxiliary, this.include.build(), this.exclude.build(), this.truncateBranchPercentage);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transactionType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("from");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("to");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("auxiliary");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("truncateBranchPercentage");
            }
            return "Cannot build FlameGraphRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TransactionJsonService.FlameGraphRequest", generator="Immutables")
    static final class Json
    implements TransactionJsonService.FlameGraphRequest {
        @Nullable
        String transactionType;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable String transactionName;
        long from;
        boolean fromIsSet;
        long to;
        boolean toIsSet;
        boolean auxiliary;
        boolean auxiliaryIsSet;
        @Nullable
        ImmutableList<String> include = ImmutableList.of();
        @Nullable
        ImmutableList<String> exclude = ImmutableList.of();
        double truncateBranchPercentage;
        boolean truncateBranchPercentageIsSet;

        Json() {
        }

        @JsonProperty(value="transactionType")
        public void setTransactionType(String transactionType) {
            this.transactionType = transactionType;
        }

        @JsonProperty(value="transactionName")
        public void setTransactionName(@org.checkerframework.checker.nullness.qual.Nullable String transactionName) {
            this.transactionName = transactionName;
        }

        @JsonProperty(value="from")
        public void setFrom(long from) {
            this.from = from;
            this.fromIsSet = true;
        }

        @JsonProperty(value="to")
        public void setTo(long to) {
            this.to = to;
            this.toIsSet = true;
        }

        @JsonProperty(value="auxiliary")
        public void setAuxiliary(boolean auxiliary) {
            this.auxiliary = auxiliary;
            this.auxiliaryIsSet = true;
        }

        @JsonProperty(value="include")
        public void setInclude(ImmutableList<String> include) {
            this.include = include;
        }

        @JsonProperty(value="exclude")
        public void setExclude(ImmutableList<String> exclude) {
            this.exclude = exclude;
        }

        @JsonProperty(value="truncateBranchPercentage")
        public void setTruncateBranchPercentage(double truncateBranchPercentage) {
            this.truncateBranchPercentage = truncateBranchPercentage;
            this.truncateBranchPercentageIsSet = true;
        }

        @Override
        public String transactionType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable String transactionName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long from() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long to() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean auxiliary() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableList<String> include() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableList<String> exclude() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double truncateBranchPercentage() {
            throw new UnsupportedOperationException();
        }
    }
}

