/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.InstrumentationConfigJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="InstrumentationConfigJsonService.ClassNamesRequest", generator="Immutables")
@Immutable
final class ImmutableClassNamesRequest
implements InstrumentationConfigJsonService.ClassNamesRequest {
    private final String partialClassName;
    private final int limit;

    private ImmutableClassNamesRequest(String partialClassName, int limit) {
        this.partialClassName = partialClassName;
        this.limit = limit;
    }

    @Override
    @JsonProperty(value="partialClassName")
    public String partialClassName() {
        return this.partialClassName;
    }

    @Override
    @JsonProperty(value="limit")
    public int limit() {
        return this.limit;
    }

    public final ImmutableClassNamesRequest withPartialClassName(String value) {
        String newValue = Objects.requireNonNull(value, "partialClassName");
        if (this.partialClassName.equals(newValue)) {
            return this;
        }
        return new ImmutableClassNamesRequest(newValue, this.limit);
    }

    public final ImmutableClassNamesRequest withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableClassNamesRequest(this.partialClassName, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableClassNamesRequest && this.equalTo(0, (ImmutableClassNamesRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableClassNamesRequest another) {
        return this.partialClassName.equals(another.partialClassName) && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.partialClassName.hashCode();
        h += (h << 5) + this.limit;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ClassNamesRequest").omitNullValues().add("partialClassName", (Object)this.partialClassName).add("limit", this.limit).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableClassNamesRequest fromJson(Json json) {
        Builder builder = ImmutableClassNamesRequest.builder();
        if (json.partialClassName != null) {
            builder.partialClassName(json.partialClassName);
        }
        if (json.limitIsSet) {
            builder.limit(json.limit);
        }
        return builder.build();
    }

    public static ImmutableClassNamesRequest copyOf(InstrumentationConfigJsonService.ClassNamesRequest instance) {
        if (instance instanceof ImmutableClassNamesRequest) {
            return (ImmutableClassNamesRequest)instance;
        }
        return ImmutableClassNamesRequest.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="InstrumentationConfigJsonService.ClassNamesRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PARTIAL_CLASS_NAME = 1L;
        private static final long INIT_BIT_LIMIT = 2L;
        private long initBits = 3L;
        @Nullable
        private String partialClassName;
        private int limit;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(InstrumentationConfigJsonService.ClassNamesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.partialClassName(instance.partialClassName());
            this.limit(instance.limit());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder partialClassName(String partialClassName) {
            this.partialClassName = Objects.requireNonNull(partialClassName, "partialClassName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableClassNamesRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableClassNamesRequest(this.partialClassName, this.limit);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("partialClassName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build ClassNamesRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="InstrumentationConfigJsonService.ClassNamesRequest", generator="Immutables")
    static final class Json
    implements InstrumentationConfigJsonService.ClassNamesRequest {
        @Nullable
        String partialClassName;
        int limit;
        boolean limitIsSet;

        Json() {
        }

        @JsonProperty(value="partialClassName")
        public void setPartialClassName(String partialClassName) {
            this.partialClassName = partialClassName;
        }

        @JsonProperty(value="limit")
        public void setLimit(int limit) {
            this.limit = limit;
            this.limitIsSet = true;
        }

        @Override
        public String partialClassName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int limit() {
            throw new UnsupportedOperationException();
        }
    }
}

