/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ChartMarking;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMap;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ChartMarking", generator="Immutables")
@Immutable
final class ImmutableChartMarking
implements ChartMarking {
    private final long from;
    private final long to;
    private final ImmutableMap<String, List<ChartMarking.ChartMarkingInterval>> intervals;

    private ImmutableChartMarking(long from, long to, ImmutableMap<String, List<ChartMarking.ChartMarkingInterval>> intervals) {
        this.from = from;
        this.to = to;
        this.intervals = intervals;
    }

    @Override
    @JsonProperty(value="from")
    public long from() {
        return this.from;
    }

    @Override
    @JsonProperty(value="to")
    public long to() {
        return this.to;
    }

    @JsonProperty(value="intervals")
    public ImmutableMap<String, List<ChartMarking.ChartMarkingInterval>> intervals() {
        return this.intervals;
    }

    public final ImmutableChartMarking withFrom(long value) {
        if (this.from == value) {
            return this;
        }
        return new ImmutableChartMarking(value, this.to, this.intervals);
    }

    public final ImmutableChartMarking withTo(long value) {
        if (this.to == value) {
            return this;
        }
        return new ImmutableChartMarking(this.from, value, this.intervals);
    }

    public final ImmutableChartMarking withIntervals(Map<String, ? extends List<ChartMarking.ChartMarkingInterval>> entries) {
        if (this.intervals == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableChartMarking(this.from, this.to, (ImmutableMap<String, List<ChartMarking.ChartMarkingInterval>>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChartMarking && this.equalTo(0, (ImmutableChartMarking)another);
    }

    private boolean equalTo(int synthetic, ImmutableChartMarking another) {
        return this.from == another.from && this.to == another.to && this.intervals.equals(another.intervals);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.from);
        h += (h << 5) + Longs.hashCode((long)this.to);
        h += (h << 5) + this.intervals.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ChartMarking").omitNullValues().add("from", this.from).add("to", this.to).add("intervals", this.intervals).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableChartMarking fromJson(Json json) {
        Builder builder = ImmutableChartMarking.builder();
        if (json.fromIsSet) {
            builder.from(json.from);
        }
        if (json.toIsSet) {
            builder.to(json.to);
        }
        if (json.intervals != null) {
            builder.putAllIntervals(json.intervals);
        }
        return builder.build();
    }

    public static ImmutableChartMarking copyOf(ChartMarking instance) {
        if (instance instanceof ImmutableChartMarking) {
            return (ImmutableChartMarking)instance;
        }
        return ImmutableChartMarking.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ChartMarking", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FROM = 1L;
        private static final long INIT_BIT_TO = 2L;
        private long initBits = 3L;
        private long from;
        private long to;
        private ImmutableMap.Builder<String, List<ChartMarking.ChartMarkingInterval>> intervals = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(ChartMarking instance) {
            Objects.requireNonNull(instance, "instance");
            this.from(instance.from());
            this.to(instance.to());
            this.putAllIntervals(instance.intervals());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(long from) {
            this.from = from;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder to(long to) {
            this.to = to;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putIntervals(String key, List<ChartMarking.ChartMarkingInterval> value) {
            this.intervals.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putIntervals(Map.Entry<String, ? extends List<ChartMarking.ChartMarkingInterval>> entry) {
            this.intervals.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder intervals(Map<String, ? extends List<ChartMarking.ChartMarkingInterval>> entries) {
            this.intervals = ImmutableMap.builder();
            return this.putAllIntervals(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllIntervals(Map<String, ? extends List<ChartMarking.ChartMarkingInterval>> entries) {
            this.intervals.putAll(entries);
            return this;
        }

        public ImmutableChartMarking build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChartMarking(this.from, this.to, this.intervals.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("from");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("to");
            }
            return "Cannot build ChartMarking, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ChartMarking", generator="Immutables")
    static final class Json
    implements ChartMarking {
        long from;
        boolean fromIsSet;
        long to;
        boolean toIsSet;
        @Nullable
        Map<String, List<ChartMarking.ChartMarkingInterval>> intervals = ImmutableMap.of();

        Json() {
        }

        @JsonProperty(value="from")
        public void setFrom(long from) {
            this.from = from;
            this.fromIsSet = true;
        }

        @JsonProperty(value="to")
        public void setTo(long to) {
            this.to = to;
            this.toIsSet = true;
        }

        @JsonProperty(value="intervals")
        public void setIntervals(Map<String, List<ChartMarking.ChartMarkingInterval>> intervals) {
            this.intervals = intervals;
        }

        @Override
        public long from() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long to() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, List<ChartMarking.ChartMarkingInterval>> intervals() {
            throw new UnsupportedOperationException();
        }
    }
}

