/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.AlertConfigJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AlertConfigJsonService.AlertListItem", generator="Immutables")
@Immutable
final class ImmutableAlertListItem
implements AlertConfigJsonService.AlertListItem {
    private final String version;
    private final String display;

    private ImmutableAlertListItem(String version, String display) {
        this.version = version;
        this.display = display;
    }

    @Override
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    @Override
    @JsonProperty(value="display")
    public String display() {
        return this.display;
    }

    public final ImmutableAlertListItem withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableAlertListItem(newValue, this.display);
    }

    public final ImmutableAlertListItem withDisplay(String value) {
        String newValue = Objects.requireNonNull(value, "display");
        if (this.display.equals(newValue)) {
            return this;
        }
        return new ImmutableAlertListItem(this.version, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAlertListItem && this.equalTo(0, (ImmutableAlertListItem)another);
    }

    private boolean equalTo(int synthetic, ImmutableAlertListItem another) {
        return this.version.equals(another.version) && this.display.equals(another.display);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.display.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AlertListItem").omitNullValues().add("version", (Object)this.version).add("display", (Object)this.display).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAlertListItem fromJson(Json json) {
        Builder builder = ImmutableAlertListItem.builder();
        if (json.version != null) {
            builder.version(json.version);
        }
        if (json.display != null) {
            builder.display(json.display);
        }
        return builder.build();
    }

    public static ImmutableAlertListItem copyOf(AlertConfigJsonService.AlertListItem instance) {
        if (instance instanceof ImmutableAlertListItem) {
            return (ImmutableAlertListItem)instance;
        }
        return ImmutableAlertListItem.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AlertConfigJsonService.AlertListItem", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VERSION = 1L;
        private static final long INIT_BIT_DISPLAY = 2L;
        private long initBits = 3L;
        @Nullable
        private String version;
        @Nullable
        private String display;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(AlertConfigJsonService.AlertListItem instance) {
            Objects.requireNonNull(instance, "instance");
            this.version(instance.version());
            this.display(instance.display());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder display(String display) {
            this.display = Objects.requireNonNull(display, "display");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableAlertListItem build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAlertListItem(this.version, this.display);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("display");
            }
            return "Cannot build AlertListItem, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AlertConfigJsonService.AlertListItem", generator="Immutables")
    static final class Json
    implements AlertConfigJsonService.AlertListItem {
        @Nullable
        String version;
        @Nullable
        String display;

        Json() {
        }

        @JsonProperty(value="version")
        public void setVersion(String version) {
            this.version = version;
        }

        @JsonProperty(value="display")
        public void setDisplay(String display) {
            this.display = display;
        }

        @Override
        public String version() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String display() {
            throw new UnsupportedOperationException();
        }
    }
}

