/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;
import org.glowroot.agent.shaded.io.netty.channel.ChannelFuture;
import org.glowroot.agent.shaded.io.netty.channel.ChannelFutureListener;
import org.glowroot.agent.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

class HttpServices {
    private static final Logger logger = LoggerFactory.getLogger(HttpServices.class);
    private static final ImmutableSet<String> BROWSER_DISCONNECT_MESSAGES = ImmutableSet.of((Object)"An existing connection was forcibly closed by the remote host", (Object)"An established connection was aborted by the software in your host machine", (Object)"Connection reset by peer");

    private HttpServices() {
    }

    static void addErrorListener(ChannelFuture future) {
        future.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(ChannelFuture future) throws Exception {
                Throwable cause = future.cause();
                if (cause == null) {
                    return;
                }
                if (HttpServices.shouldLogException(cause)) {
                    logger.error(cause.getMessage(), cause);
                }
                future.channel().close();
            }
        });
    }

    static void addCloseListener(ChannelFuture future) {
        future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    static boolean shouldLogException(Throwable t) {
        if (t instanceof InterruptedException) {
            logger.debug(t.getMessage(), t);
            return false;
        }
        if (t instanceof IOException && BROWSER_DISCONNECT_MESSAGES.contains((Object)t.getMessage())) {
            logger.debug(t.getMessage(), t);
            return false;
        }
        if (t instanceof ClosedChannelException) {
            logger.debug(t.getMessage(), t);
            return false;
        }
        return true;
    }
}

