/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ChunkSource;
import org.glowroot.agent.shaded.com.google.common.base.Charsets;
import org.glowroot.agent.shaded.io.netty.buffer.ByteBuf;
import org.glowroot.agent.shaded.io.netty.buffer.ByteBufAllocator;
import org.glowroot.agent.shaded.io.netty.buffer.ByteBufOutputStream;
import org.glowroot.agent.shaded.io.netty.buffer.Unpooled;
import org.glowroot.agent.shaded.io.netty.channel.ChannelHandlerContext;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.DefaultHttpContent;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpContent;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.LastHttpContent;
import org.glowroot.agent.shaded.io.netty.handler.stream.ChunkedInput;

class ChunkedInputs {
    static ChunkedInput<HttpContent> create(ChunkSource chunkSource) throws IOException {
        return new ChunkSourceChunkedInput(chunkSource);
    }

    static ChunkedInput<HttpContent> createZipFileDownload(ChunkSource chunkSource, String fileName) throws IOException {
        return new ZipFileChunkedInput(chunkSource, fileName);
    }

    private ChunkedInputs() {
    }

    private static class ZipFileChunkedInput
    extends BaseChunkedInput {
        private final ByteBuf byteBuf = Unpooled.buffer();
        private final ByteBufOutputStream bbos = new ByteBufOutputStream(this.byteBuf);
        private final Writer zipWriter;
        private final ChunkSource.ChunkCopier chunkCopier;
        private boolean firstChunk = true;
        private boolean closed;

        private ZipFileChunkedInput(ChunkSource chunkSource, String fileName) throws IOException {
            ZipOutputStream zipOut = new ZipOutputStream((OutputStream)this.bbos);
            zipOut.putNextEntry(new ZipEntry(fileName + ".html"));
            this.zipWriter = new OutputStreamWriter((OutputStream)zipOut, Charsets.UTF_8);
            this.chunkCopier = chunkSource.getCopier(this.zipWriter);
        }

        @Override
        protected @Nullable ByteBuf readNextChunk() throws IOException {
            if (this.closed) {
                return null;
            }
            if (!this.firstChunk) {
                this.byteBuf.clear();
            }
            this.firstChunk = false;
            do {
                if (this.chunkCopier.copyNext()) continue;
                this.zipWriter.close();
                this.closed = true;
                return this.byteBuf;
            } while (this.byteBuf.writerIndex() <= 0);
            this.zipWriter.flush();
            this.byteBuf.retain();
            return this.byteBuf;
        }
    }

    private static class ChunkSourceChunkedInput
    extends BaseChunkedInput {
        private final ByteBuf byteBuf = Unpooled.buffer();
        private final Writer writer = new OutputStreamWriter((OutputStream)new ByteBufOutputStream(this.byteBuf), Charsets.UTF_8);
        private final ChunkSource.ChunkCopier chunkCopier;
        private boolean closed;

        private ChunkSourceChunkedInput(ChunkSource chunkSource) throws IOException {
            this.chunkCopier = chunkSource.getCopier(this.writer);
        }

        @Override
        public @Nullable ByteBuf readNextChunk() throws IOException {
            if (this.closed) {
                return null;
            }
            if (this.byteBuf.refCnt() > 1) {
                throw new IOException("ByteBuf is still in use by another");
            }
            this.byteBuf.clear();
            if (this.chunkCopier.copyNext()) {
                this.writer.flush();
                while (this.byteBuf.writerIndex() == 0) {
                    this.chunkCopier.copyNext();
                    this.writer.flush();
                }
                this.byteBuf.retain();
                return this.byteBuf;
            }
            this.closed = true;
            return null;
        }
    }

    private static abstract class BaseChunkedInput
    implements ChunkedInput<HttpContent> {
        private boolean hasSentTerminatingChunk;

        private BaseChunkedInput() {
        }

        public @Nullable HttpContent readChunk(ChannelHandlerContext ctx) throws Exception {
            return this.readChunk(ctx.alloc());
        }

        public @Nullable HttpContent readChunk(ByteBufAllocator allocator) throws Exception {
            if (this.hasSentTerminatingChunk) {
                return null;
            }
            ByteBuf nextChunk = this.readNextChunk();
            if (nextChunk != null) {
                return new DefaultHttpContent(nextChunk);
            }
            this.hasSentTerminatingChunk = true;
            return LastHttpContent.EMPTY_LAST_CONTENT;
        }

        public boolean isEndOfInput() {
            return this.hasSentTerminatingChunk;
        }

        public void close() throws IOException {
        }

        public long length() {
            return -1L;
        }

        public long progress() {
            return -1L;
        }

        protected abstract @Nullable ByteBuf readNextChunk() throws IOException;
    }
}

