/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util;

import java.util.List;
import java.util.concurrent.CompletionStage;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.AggregateRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.GaugeValueRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ImmutableTraceQuery;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.TraceRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.RollupLevelService;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Strings;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutableAggregateQuery;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveAggregateRepository;
import org.glowroot.agent.shaded.org.glowroot.common.model.LazyHistogram;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.CollectorServiceOuterClass;

class MetricService {
    private static final double NANOSECONDS_PER_MILLISECOND = 1000000.0;
    private final AggregateRepository aggregateRepository;
    private final GaugeValueRepository gaugeValueRepository;
    private final TraceRepository traceRepository;
    private final RollupLevelService rollupLevelService;

    public MetricService(AggregateRepository aggregateRepository, GaugeValueRepository gaugeValueRepository, TraceRepository traceRepository, RollupLevelService rollupLevelService) {
        this.aggregateRepository = aggregateRepository;
        this.gaugeValueRepository = gaugeValueRepository;
        this.traceRepository = traceRepository;
        this.rollupLevelService = rollupLevelService;
    }

    CompletionStage<? extends Number> getMetricValue(String agentRollupId, AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.MetricCondition metricCondition, long startTime, long endTime, CassandraProfile profile) {
        String metric = metricCondition.getMetric();
        if (metric.equals("transaction:x-percentile")) {
            return this.getTransactionDurationPercentile(agentRollupId, metricCondition.getTransactionType(), Strings.emptyToNull((String)metricCondition.getTransactionName()), metricCondition.getPercentile().getValue(), startTime, endTime, profile);
        }
        if (metric.equals("transaction:average")) {
            return this.getTransactionAverage(agentRollupId, metricCondition.getTransactionType(), Strings.emptyToNull((String)metricCondition.getTransactionName()), startTime, endTime, profile);
        }
        if (metric.equals("transaction:count")) {
            return this.getTransactionCount(agentRollupId, metricCondition.getTransactionType(), Strings.emptyToNull((String)metricCondition.getTransactionName()), startTime, endTime, profile);
        }
        if (metric.equals("error:rate")) {
            return this.getErrorRate(agentRollupId, metricCondition.getTransactionType(), Strings.emptyToNull((String)metricCondition.getTransactionName()), startTime, endTime, profile);
        }
        if (metric.equals("error:count")) {
            return this.getErrorCount(agentRollupId, metricCondition.getTransactionType(), Strings.emptyToNull((String)metricCondition.getTransactionName()), metricCondition.getErrorMessageFilter(), startTime, endTime, profile);
        }
        if (metric.startsWith("gauge:")) {
            return this.getGaugeValue(agentRollupId, metric.substring("gauge:".length()), startTime, endTime, profile);
        }
        throw new IllegalStateException("Unexpected metric: " + metric);
    }

    private CompletionStage<Double> getTransactionDurationPercentile(String agentRollupId, String transactionType, @Nullable String transactionName, double percentile, long startTime, long endTime, CassandraProfile profile) {
        int rollupLevel = this.rollupLevelService.getRollupLevelForView(startTime, endTime, RollupLevelService.DataKind.GENERAL);
        return this.aggregateRepository.readPercentileAggregates(agentRollupId, (LiveAggregateRepository.AggregateQuery)ImmutableAggregateQuery.builder().transactionType(transactionType).transactionName(transactionName).from(startTime + 1L).to(endTime).rollupLevel(rollupLevel).build(), profile).thenApply(aggregates -> {
            if (aggregates.isEmpty()) {
                return null;
            }
            LazyHistogram durationNanosHistogram = new LazyHistogram();
            for (LiveAggregateRepository.PercentileAggregate aggregate : aggregates) {
                durationNanosHistogram.merge(aggregate.durationNanosHistogram());
            }
            return (double)durationNanosHistogram.getValueAtPercentile(percentile) / 1000000.0;
        });
    }

    private CompletionStage<Double> getTransactionAverage(String agentRollupId, String transactionType, @Nullable String transactionName, long startTime, long endTime, CassandraProfile profile) {
        return this.getOverviewAggregates(agentRollupId, transactionType, transactionName, startTime, endTime, profile).thenApply(aggregates -> {
            if (aggregates.isEmpty()) {
                return null;
            }
            double totalDurationNanos = 0.0;
            long totalTransactionCount = 0L;
            for (LiveAggregateRepository.OverviewAggregate aggregate : aggregates) {
                totalDurationNanos += aggregate.totalDurationNanos();
                totalTransactionCount += aggregate.transactionCount();
            }
            Preconditions.checkState((totalTransactionCount != 0L ? 1 : 0) != 0);
            return totalDurationNanos / ((double)totalTransactionCount * 1000000.0);
        });
    }

    public CompletionStage<Long> getTransactionCount(String agentRollupId, String transactionType, @Nullable String transactionName, long startTime, long endTime, CassandraProfile profile) {
        return this.getThroughputAggregates(agentRollupId, transactionType, transactionName, startTime, endTime, profile).thenApply(throughputAggregates -> {
            long totalTransactionCount = 0L;
            for (LiveAggregateRepository.ThroughputAggregate throughputAggregate : throughputAggregates) {
                totalTransactionCount += throughputAggregate.transactionCount();
            }
            return totalTransactionCount;
        });
    }

    private CompletionStage<Double> getErrorRate(String agentRollupId, String transactionType, @Nullable String transactionName, long startTime, long endTime, CassandraProfile profile) {
        return this.getThroughputAggregates(agentRollupId, transactionType, transactionName, startTime, endTime, profile).thenApply(aggregates -> {
            if (aggregates.isEmpty()) {
                return null;
            }
            long totalTransactionCount = 0L;
            long totalErrorCount = 0L;
            for (LiveAggregateRepository.ThroughputAggregate aggregate : aggregates) {
                totalTransactionCount += aggregate.transactionCount();
                totalErrorCount += ((Long)MoreObjects.firstNonNull((Object)aggregate.errorCount(), (Object)0L)).longValue();
            }
            Preconditions.checkState((totalTransactionCount != 0L ? 1 : 0) != 0);
            return 100.0 * (double)totalErrorCount / (double)totalTransactionCount;
        });
    }

    private CompletionStage<Long> getErrorCount(String agentRollupId, String transactionType, @Nullable String transactionName, @Nullable String errorMessageFilter, long startTime, long endTime, CassandraProfile profile) {
        if (errorMessageFilter == null) {
            return this.getThroughputAggregates(agentRollupId, transactionType, transactionName, startTime, endTime, profile).thenApply(aggregates -> {
                long totalErrorCount = 0L;
                for (LiveAggregateRepository.ThroughputAggregate aggregate : aggregates) {
                    totalErrorCount += ((Long)MoreObjects.firstNonNull((Object)aggregate.errorCount(), (Object)0L)).longValue();
                }
                return totalErrorCount;
            });
        }
        ImmutableTraceQuery traceQuery = ImmutableTraceQuery.builder().transactionType(transactionType).transactionName(transactionName).from(startTime).to(endTime).build();
        return this.traceRepository.readErrorMessageCount(agentRollupId, traceQuery, errorMessageFilter, profile);
    }

    private CompletionStage<Double> getGaugeValue(String agentRollupId, String gaugeName, long startTime, long endTime, CassandraProfile profile) {
        int rollupLevel = this.rollupLevelService.getGaugeRollupLevelForView(startTime, endTime, agentRollupId.endsWith("::"));
        return this.gaugeValueRepository.readGaugeValues(agentRollupId, gaugeName, startTime + 1L, endTime, rollupLevel, profile).thenApply(gaugeValues -> {
            if (gaugeValues.isEmpty()) {
                return null;
            }
            double totalWeightedValue = 0.0;
            long totalWeight = 0L;
            for (CollectorServiceOuterClass.GaugeValueMessage.GaugeValue gaugeValue : gaugeValues) {
                totalWeightedValue += gaugeValue.getValue() * (double)gaugeValue.getWeight();
                totalWeight += gaugeValue.getWeight();
            }
            Preconditions.checkState((totalWeight != 0L ? 1 : 0) != 0);
            return totalWeightedValue / (double)totalWeight;
        });
    }

    private CompletionStage<List<LiveAggregateRepository.ThroughputAggregate>> getThroughputAggregates(String agentRollupId, String transactionType, @Nullable String transactionName, long startTime, long endTime, CassandraProfile profile) {
        int rollupLevel = this.rollupLevelService.getRollupLevelForView(startTime, endTime, RollupLevelService.DataKind.GENERAL);
        return this.aggregateRepository.readThroughputAggregates(agentRollupId, (LiveAggregateRepository.AggregateQuery)ImmutableAggregateQuery.builder().transactionType(transactionType).transactionName(transactionName).from(startTime + 1L).to(endTime).rollupLevel(rollupLevel).build(), profile);
    }

    private CompletionStage<List<LiveAggregateRepository.OverviewAggregate>> getOverviewAggregates(String agentRollupId, String transactionType, @Nullable String transactionName, long startTime, long endTime, CassandraProfile profile) {
        int rollupLevel = this.rollupLevelService.getRollupLevelForView(startTime, endTime, RollupLevelService.DataKind.GENERAL);
        return this.aggregateRepository.readOverviewAggregates(agentRollupId, (LiveAggregateRepository.AggregateQuery)ImmutableAggregateQuery.builder().transactionType(transactionType).transactionName(transactionName).from(startTime + 1L).to(endTime).rollupLevel(rollupLevel).build(), profile);
    }
}

