/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.GaugeValueRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ImmutableGauge;
import org.glowroot.agent.shaded.com.google.common.base.Joiner;
import org.glowroot.agent.shaded.com.google.common.base.Splitter;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

public class Gauges {
    public static final String DISPLAY_PARTS_SEPARATOR = " / ";
    private static final Logger logger = LoggerFactory.getLogger(Gauges.class);
    private static final ImmutableList<UnitPattern> unitPatterns;
    private static final String GROUPING_PREFIX = "grouping-";

    private Gauges() {
    }

    public static GaugeValueRepository.Gauge getGauge(String gaugeName) {
        int index = gaugeName.lastIndexOf(58);
        String mbeanObjectName = gaugeName.substring(0, index);
        String mbeanAttributeName = gaugeName.substring(index + 1);
        boolean counter = mbeanAttributeName.endsWith("[counter]");
        if (counter) {
            mbeanAttributeName = mbeanAttributeName.substring(0, mbeanAttributeName.length() - "[counter]".length());
        }
        mbeanAttributeName = mbeanAttributeName.replaceAll("\\.", DISPLAY_PARTS_SEPARATOR);
        List<String> displayParts = Gauges.getDisplayParts(mbeanObjectName);
        displayParts.addAll(Splitter.on((char)'.').splitToList((CharSequence)mbeanAttributeName));
        String display = Joiner.on((String)DISPLAY_PARTS_SEPARATOR).join(displayParts);
        String unit = Gauges.unit(gaugeName);
        ImmutableGauge.Builder gauge = ImmutableGauge.builder().name(gaugeName).display(display).displayParts(displayParts).counter(counter).grouping(unit);
        if (unit.startsWith(GROUPING_PREFIX)) {
            if (unit.endsWith(" per second")) {
                return gauge.unit("per second").build();
            }
            return gauge.unit("").build();
        }
        return gauge.unit(unit).build();
    }

    public static List<String> getDisplayParts(String mbeanObjectName) {
        ArrayList displayParts = Lists.newArrayList();
        int index = mbeanObjectName.indexOf(58);
        String domain = mbeanObjectName.substring(0, index);
        displayParts.add(domain);
        ++index;
        while (index < mbeanObjectName.length()) {
            if ((index = Gauges.processNextKeyValue(mbeanObjectName, index, displayParts)) != -1) continue;
            logger.warn("unexpected mbean object name: {}", (Object)mbeanObjectName);
            displayParts.clear();
            displayParts.add(mbeanObjectName);
            return displayParts;
        }
        return displayParts;
    }

    private static int processNextKeyValue(String mbeanObjectName, int fromIndex, List<String> displayParts) {
        char c;
        int index = mbeanObjectName.indexOf(61, fromIndex);
        if (index == -1) {
            return -1;
        }
        if ((c = mbeanObjectName.charAt(++index)) == '\"') {
            ++index;
            StringBuilder sb = new StringBuilder();
            boolean quoteTerminated = false;
            while (index < mbeanObjectName.length()) {
                if ((c = mbeanObjectName.charAt(index++)) == '\\') {
                    if ((c = mbeanObjectName.charAt(index++)) == 'n') {
                        sb.append('\n');
                        continue;
                    }
                    sb.append(c);
                    continue;
                }
                if (c == '\"') {
                    quoteTerminated = true;
                    break;
                }
                sb.append(c);
            }
            if (!quoteTerminated) {
                return -1;
            }
            displayParts.add(sb.toString());
            return index;
        }
        int next = mbeanObjectName.indexOf(44, index);
        if (next == -1) {
            displayParts.add(mbeanObjectName.substring(index));
            return mbeanObjectName.length();
        }
        displayParts.add(mbeanObjectName.substring(index, next));
        return next + 1;
    }

    private static String unit(String gaugeName) {
        if (gaugeName.endsWith("[counter]")) {
            String baseUnit = Gauges.getBaseUnit(gaugeName.substring(0, gaugeName.length() - "[counter]".length()));
            if (baseUnit.isEmpty()) {
                return "per second";
            }
            return baseUnit + " per second";
        }
        return Gauges.getBaseUnit(gaugeName);
    }

    private static String getBaseUnit(String gaugeName) {
        for (UnitPattern unitPattern : unitPatterns) {
            if (!unitPattern.pattern.matcher(gaugeName).matches()) continue;
            return unitPattern.unit;
        }
        return "";
    }

    static {
        ArrayList patterns = Lists.newArrayList();
        patterns.add(new UnitPattern("java.lang:type=Memory:(Non)?HeapMemoryUsage\\.(init|used|committed|max)", "bytes"));
        patterns.add(new UnitPattern("java.lang:type=OperatingSystem:(Free|Total)(Physical|Swap)MemorySize", "bytes"));
        patterns.add(new UnitPattern("java.lang:type=OperatingSystem:(ProcessCpuLoad|SystemCpuLoad)", "grouping-cpu-load"));
        patterns.add(new UnitPattern("java.lang:type=Runtime:Uptime", "milliseconds"));
        patterns.add(new UnitPattern("java.lang:type=Threading:CurrentThread(Cpu|User)Time", "nanoseconds"));
        patterns.add(new UnitPattern("java.lang:type=MemoryPool,name=.*:(Peak)?Usage\\.(init|used|committed|max)", "bytes"));
        patterns.add(new UnitPattern("java.lang:type=GarbageCollector,name=.*:LastGcInfo\\.duration", "milliseconds"));
        patterns.add(new UnitPattern("java.lang:type=GarbageCollector,name=.*:CollectionTime", "milliseconds"));
        patterns.add(new UnitPattern("java.lang:type=GarbageCollector,name=.*:CollectionCount", "grouping-collection-count"));
        patterns.add(new UnitPattern("java.lang:type=Compilation:TotalCompilationTime", "milliseconds"));
        patterns.add(new UnitPattern("java.lang:type=ClassLoading:(Loaded|TotalLoaded|Unloaded)ClassCount", "grouping-class-count"));
        patterns.add(new UnitPattern("sun.management:type=HotspotClassLoading:InitializedClassCount", "grouping-class-count"));
        patterns.add(new UnitPattern("sun.management:type=HotspotClassLoading:(LoadedClassSize|MethodDataSize|UnloadedClassSize)", "bytes"));
        patterns.add(new UnitPattern("sun.management:type=HotspotClassLoading:Class(InitializationTime|LoadingTime|VerificationTime)", "milliseconds"));
        patterns.add(new UnitPattern("sun.management:type=HotspotRuntime:(SafepointSync|TotalSafepoint)Time", "milliseconds"));
        patterns.add(new UnitPattern("org.glowroot:type=FileSystem,name=.*:(Total|Free)Space", "bytes"));
        patterns.add(new UnitPattern("org.glowroot:type=FileSystem,name=.*:PercentFull", "percent"));
        patterns.add(new UnitPattern("org.apache.cassandra.metrics:type=ColumnFamily,keyspace=[^,]+,scope=[^,]+,name=LiveDiskSpaceUsed:Count", "bytes"));
        patterns.add(new UnitPattern("org.apache.cassandra.metrics:type=ColumnFamily,keyspace=[^,]+,scope=[^,]+,name=TotalDiskSpaceUsed:Count", "bytes"));
        patterns.add(new UnitPattern("Catalina:type=ThreadPool,name=.*:(currentThreadCount|currentThreadsBusy|maxThreads)", "grouping-thread-count"));
        patterns.add(new UnitPattern("Catalina:type=Executor,name=.*:(activeCount|poolSize|maxThreads)", "grouping-thread-count"));
        patterns.add(new UnitPattern("com.mchange.v2.c3p0:type=PooledDataSource,(identityToken|name)=.*:threadPoolSize", "grouping-thread-count"));
        unitPatterns = ImmutableList.copyOf((Collection)patterns);
    }

    private static class UnitPattern {
        private final Pattern pattern;
        private final String unit;

        private UnitPattern(String pattern, String unit) {
            this.pattern = Pattern.compile(pattern);
            this.unit = unit;
        }
    }
}

