/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.TraceRepository;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TraceRepository.TraceQuery", generator="Immutables")
@Immutable
public final class ImmutableTraceQuery
implements TraceRepository.TraceQuery {
    private final String transactionType;
    private final @org.checkerframework.checker.nullness.qual.Nullable String transactionName;
    private final long from;
    private final long to;

    private ImmutableTraceQuery(String transactionType, @org.checkerframework.checker.nullness.qual.Nullable String transactionName, long from, long to) {
        this.transactionType = transactionType;
        this.transactionName = transactionName;
        this.from = from;
        this.to = to;
    }

    @Override
    @JsonProperty(value="transactionType")
    public String transactionType() {
        return this.transactionType;
    }

    @Override
    @JsonProperty(value="transactionName")
    public @org.checkerframework.checker.nullness.qual.Nullable String transactionName() {
        return this.transactionName;
    }

    @Override
    @JsonProperty(value="from")
    public long from() {
        return this.from;
    }

    @Override
    @JsonProperty(value="to")
    public long to() {
        return this.to;
    }

    public final ImmutableTraceQuery withTransactionType(String value) {
        String newValue = Objects.requireNonNull(value, "transactionType");
        if (this.transactionType.equals(newValue)) {
            return this;
        }
        return new ImmutableTraceQuery(newValue, this.transactionName, this.from, this.to);
    }

    public final ImmutableTraceQuery withTransactionName(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.transactionName, value)) {
            return this;
        }
        return new ImmutableTraceQuery(this.transactionType, value, this.from, this.to);
    }

    public final ImmutableTraceQuery withFrom(long value) {
        if (this.from == value) {
            return this;
        }
        return new ImmutableTraceQuery(this.transactionType, this.transactionName, value, this.to);
    }

    public final ImmutableTraceQuery withTo(long value) {
        if (this.to == value) {
            return this;
        }
        return new ImmutableTraceQuery(this.transactionType, this.transactionName, this.from, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTraceQuery && this.equalTo(0, (ImmutableTraceQuery)another);
    }

    private boolean equalTo(int synthetic, ImmutableTraceQuery another) {
        return this.transactionType.equals(another.transactionType) && Objects.equals(this.transactionName, another.transactionName) && this.from == another.from && this.to == another.to;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transactionType.hashCode();
        h += (h << 5) + Objects.hashCode(this.transactionName);
        h += (h << 5) + Longs.hashCode((long)this.from);
        h += (h << 5) + Longs.hashCode((long)this.to);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TraceQuery").omitNullValues().add("transactionType", (Object)this.transactionType).add("transactionName", (Object)this.transactionName).add("from", this.from).add("to", this.to).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTraceQuery fromJson(Json json) {
        Builder builder = ImmutableTraceQuery.builder();
        if (json.transactionType != null) {
            builder.transactionType(json.transactionType);
        }
        if (json.transactionName != null) {
            builder.transactionName(json.transactionName);
        }
        if (json.fromIsSet) {
            builder.from(json.from);
        }
        if (json.toIsSet) {
            builder.to(json.to);
        }
        return builder.build();
    }

    public static ImmutableTraceQuery copyOf(TraceRepository.TraceQuery instance) {
        if (instance instanceof ImmutableTraceQuery) {
            return (ImmutableTraceQuery)instance;
        }
        return ImmutableTraceQuery.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TraceRepository.TraceQuery", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRANSACTION_TYPE = 1L;
        private static final long INIT_BIT_FROM = 2L;
        private static final long INIT_BIT_TO = 4L;
        private long initBits = 7L;
        @Nullable
        private String transactionType;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String transactionName;
        private long from;
        private long to;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(TraceRepository.TraceQuery instance) {
            Objects.requireNonNull(instance, "instance");
            this.transactionType(instance.transactionType());
            @org.checkerframework.checker.nullness.qual.Nullable String transactionNameValue = instance.transactionName();
            if (transactionNameValue != null) {
                this.transactionName(transactionNameValue);
            }
            this.from(instance.from());
            this.to(instance.to());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactionType(String transactionType) {
            this.transactionType = Objects.requireNonNull(transactionType, "transactionType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactionName(@org.checkerframework.checker.nullness.qual.Nullable String transactionName) {
            this.transactionName = transactionName;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(long from) {
            this.from = from;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder to(long to) {
            this.to = to;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableTraceQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTraceQuery(this.transactionType, this.transactionName, this.from, this.to);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transactionType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("from");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("to");
            }
            return "Cannot build TraceQuery, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TraceRepository.TraceQuery", generator="Immutables")
    static final class Json
    implements TraceRepository.TraceQuery {
        @Nullable
        String transactionType;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable String transactionName;
        long from;
        boolean fromIsSet;
        long to;
        boolean toIsSet;

        Json() {
        }

        @JsonProperty(value="transactionType")
        public void setTransactionType(String transactionType) {
            this.transactionType = transactionType;
        }

        @JsonProperty(value="transactionName")
        public void setTransactionName(@org.checkerframework.checker.nullness.qual.Nullable String transactionName) {
            this.transactionName = transactionName;
        }

        @JsonProperty(value="from")
        public void setFrom(long from) {
            this.from = from;
            this.fromIsSet = true;
        }

        @JsonProperty(value="to")
        public void setTo(long to) {
            this.to = to;
            this.toIsSet = true;
        }

        @Override
        public String transactionType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable String transactionName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long from() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long to() {
            throw new UnsupportedOperationException();
        }
    }
}

