/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.TraceRepository;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TraceRepository.ErrorMessagePoint", generator="Immutables")
@Immutable
public final class ImmutableErrorMessagePoint
implements TraceRepository.ErrorMessagePoint {
    private final long captureTime;
    private final long errorCount;

    private ImmutableErrorMessagePoint(long captureTime, long errorCount) {
        this.captureTime = captureTime;
        this.errorCount = errorCount;
    }

    @Override
    @JsonProperty(value="captureTime")
    public long captureTime() {
        return this.captureTime;
    }

    @Override
    @JsonProperty(value="errorCount")
    public long errorCount() {
        return this.errorCount;
    }

    public final ImmutableErrorMessagePoint withCaptureTime(long value) {
        if (this.captureTime == value) {
            return this;
        }
        return new ImmutableErrorMessagePoint(value, this.errorCount);
    }

    public final ImmutableErrorMessagePoint withErrorCount(long value) {
        if (this.errorCount == value) {
            return this;
        }
        return new ImmutableErrorMessagePoint(this.captureTime, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableErrorMessagePoint && this.equalTo(0, (ImmutableErrorMessagePoint)another);
    }

    private boolean equalTo(int synthetic, ImmutableErrorMessagePoint another) {
        return this.captureTime == another.captureTime && this.errorCount == another.errorCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.captureTime);
        h += (h << 5) + Longs.hashCode((long)this.errorCount);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ErrorMessagePoint").omitNullValues().add("captureTime", this.captureTime).add("errorCount", this.errorCount).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableErrorMessagePoint fromJson(Json json) {
        Builder builder = ImmutableErrorMessagePoint.builder();
        if (json.captureTimeIsSet) {
            builder.captureTime(json.captureTime);
        }
        if (json.errorCountIsSet) {
            builder.errorCount(json.errorCount);
        }
        return builder.build();
    }

    public static ImmutableErrorMessagePoint of(long captureTime, long errorCount) {
        return new ImmutableErrorMessagePoint(captureTime, errorCount);
    }

    public static ImmutableErrorMessagePoint copyOf(TraceRepository.ErrorMessagePoint instance) {
        if (instance instanceof ImmutableErrorMessagePoint) {
            return (ImmutableErrorMessagePoint)instance;
        }
        return ImmutableErrorMessagePoint.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TraceRepository.ErrorMessagePoint", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CAPTURE_TIME = 1L;
        private static final long INIT_BIT_ERROR_COUNT = 2L;
        private long initBits = 3L;
        private long captureTime;
        private long errorCount;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(TraceRepository.ErrorMessagePoint instance) {
            Objects.requireNonNull(instance, "instance");
            this.captureTime(instance.captureTime());
            this.errorCount(instance.errorCount());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder captureTime(long captureTime) {
            this.captureTime = captureTime;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder errorCount(long errorCount) {
            this.errorCount = errorCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableErrorMessagePoint build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableErrorMessagePoint(this.captureTime, this.errorCount);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("captureTime");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("errorCount");
            }
            return "Cannot build ErrorMessagePoint, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TraceRepository.ErrorMessagePoint", generator="Immutables")
    static final class Json
    implements TraceRepository.ErrorMessagePoint {
        long captureTime;
        boolean captureTimeIsSet;
        long errorCount;
        boolean errorCountIsSet;

        Json() {
        }

        @JsonProperty(value="captureTime")
        public void setCaptureTime(long captureTime) {
            this.captureTime = captureTime;
            this.captureTimeIsSet = true;
        }

        @JsonProperty(value="errorCount")
        public void setErrorCount(long errorCount) {
            this.errorCount = errorCount;
            this.errorCountIsSet = true;
        }

        @Override
        public long captureTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long errorCount() {
            throw new UnsupportedOperationException();
        }
    }
}

