/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.config;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.UserConfig;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="UserConfig", generator="Immutables")
@Immutable
public final class ImmutableUserConfig
extends UserConfig {
    private final String username;
    private final String passwordHash;
    private final boolean ldap;
    private final ImmutableSet<String> roles;
    private final transient String version;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUserConfig(Builder builder) {
        this.username = builder.username;
        this.roles = builder.roles.build();
        if (builder.passwordHash != null) {
            this.initShim.passwordHash(builder.passwordHash);
        }
        if (builder.ldapIsSet()) {
            this.initShim.ldap(builder.ldap);
        }
        this.passwordHash = this.initShim.passwordHash();
        this.ldap = this.initShim.ldap();
        this.version = this.initShim.version();
        this.initShim = null;
    }

    private ImmutableUserConfig(String username, String passwordHash, boolean ldap, ImmutableSet<String> roles) {
        this.username = username;
        this.initShim.passwordHash(passwordHash);
        this.initShim.ldap(ldap);
        this.roles = roles;
        this.passwordHash = this.initShim.passwordHash();
        this.ldap = this.initShim.ldap();
        this.version = this.initShim.version();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="username")
    public String username() {
        return this.username;
    }

    @Override
    @JsonProperty(value="passwordHash")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String passwordHash() {
        InitShim shim = this.initShim;
        return shim != null ? shim.passwordHash() : this.passwordHash;
    }

    @Override
    @JsonProperty(value="ldap")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public boolean ldap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ldap() : this.ldap;
    }

    @Override
    @JsonProperty(value="roles")
    public ImmutableSet<String> roles() {
        return this.roles;
    }

    @Override
    @JsonProperty(value="version")
    @JsonIgnore
    public String version() {
        InitShim shim = this.initShim;
        return shim != null ? shim.version() : this.version;
    }

    public final ImmutableUserConfig withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutableUserConfig(newValue, this.passwordHash, this.ldap, this.roles);
    }

    public final ImmutableUserConfig withPasswordHash(String value) {
        String newValue = Objects.requireNonNull(value, "passwordHash");
        if (this.passwordHash.equals(newValue)) {
            return this;
        }
        return new ImmutableUserConfig(this.username, newValue, this.ldap, this.roles);
    }

    public final ImmutableUserConfig withLdap(boolean value) {
        if (this.ldap == value) {
            return this;
        }
        return new ImmutableUserConfig(this.username, this.passwordHash, value, this.roles);
    }

    public final ImmutableUserConfig withRoles(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableUserConfig(this.username, this.passwordHash, this.ldap, (ImmutableSet<String>)newValue);
    }

    public final ImmutableUserConfig withRoles(Iterable<String> elements) {
        if (this.roles == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableUserConfig(this.username, this.passwordHash, this.ldap, (ImmutableSet<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUserConfig && this.equalTo(0, (ImmutableUserConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableUserConfig another) {
        return this.username.equals(another.username) && this.passwordHash.equals(another.passwordHash) && this.ldap == another.ldap && this.roles.equals(another.roles) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.passwordHash.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.ldap);
        h += (h << 5) + this.roles.hashCode();
        h += (h << 5) + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"UserConfig").omitNullValues().add("username", (Object)this.username).add("passwordHash", (Object)this.passwordHash).add("ldap", this.ldap).add("roles", this.roles).add("version", (Object)this.version).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableUserConfig fromJson(Json json) {
        Builder builder = ImmutableUserConfig.builder();
        if (json.username != null) {
            builder.username(json.username);
        }
        if (json.passwordHash != null) {
            builder.passwordHash(json.passwordHash);
        }
        if (json.ldapIsSet) {
            builder.ldap(json.ldap);
        }
        if (json.roles != null) {
            builder.addAllRoles((Iterable<String>)json.roles);
        }
        return builder.build();
    }

    public static ImmutableUserConfig copyOf(UserConfig instance) {
        if (instance instanceof ImmutableUserConfig) {
            return (ImmutableUserConfig)instance;
        }
        return ImmutableUserConfig.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UserConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USERNAME = 1L;
        private static final long OPT_BIT_LDAP = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String username;
        @Nullable
        private String passwordHash;
        private boolean ldap;
        private ImmutableSet.Builder<String> roles = ImmutableSet.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(UserConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.username(instance.username());
            this.passwordHash(instance.passwordHash());
            this.ldap(instance.ldap());
            this.addAllRoles((Iterable<String>)instance.roles());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder passwordHash(String passwordHash) {
            this.passwordHash = Objects.requireNonNull(passwordHash, "passwordHash");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ldap(boolean ldap) {
            this.ldap = ldap;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRoles(String element) {
            this.roles.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRoles(String ... elements) {
            this.roles.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder roles(Iterable<String> elements) {
            this.roles = ImmutableSet.builder();
            return this.addAllRoles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRoles(Iterable<String> elements) {
            this.roles.addAll(elements);
            return this;
        }

        public ImmutableUserConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUserConfig(this);
        }

        private boolean ldapIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("username");
            }
            return "Cannot build UserConfig, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="UserConfig", generator="Immutables")
    static final class Json
    extends UserConfig {
        @Nullable
        String username;
        @Nullable
        String passwordHash;
        boolean ldap;
        boolean ldapIsSet;
        @Nullable
        ImmutableSet<String> roles = ImmutableSet.of();

        Json() {
        }

        @JsonProperty(value="username")
        public void setUsername(String username) {
            this.username = username;
        }

        @JsonProperty(value="passwordHash")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setPasswordHash(String passwordHash) {
            this.passwordHash = passwordHash;
        }

        @JsonProperty(value="ldap")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setLdap(boolean ldap) {
            this.ldap = ldap;
            this.ldapIsSet = true;
        }

        @JsonProperty(value="roles")
        public void setRoles(ImmutableSet<String> roles) {
            this.roles = roles;
        }

        @Override
        public String username() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String passwordHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean ldap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableSet<String> roles() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String version() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="UserConfig", generator="Immutables")
    private final class InitShim {
        private byte passwordHashBuildStage = 0;
        private String passwordHash;
        private byte ldapBuildStage = 0;
        private boolean ldap;
        private byte versionBuildStage = 0;
        private String version;

        private InitShim() {
        }

        String passwordHash() {
            if (this.passwordHashBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.passwordHashBuildStage == 0) {
                this.passwordHashBuildStage = (byte)-1;
                this.passwordHash = Objects.requireNonNull(ImmutableUserConfig.super.passwordHash(), "passwordHash");
                this.passwordHashBuildStage = 1;
            }
            return this.passwordHash;
        }

        void passwordHash(String passwordHash) {
            this.passwordHash = passwordHash;
            this.passwordHashBuildStage = 1;
        }

        boolean ldap() {
            if (this.ldapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ldapBuildStage == 0) {
                this.ldapBuildStage = (byte)-1;
                this.ldap = ImmutableUserConfig.super.ldap();
                this.ldapBuildStage = 1;
            }
            return this.ldap;
        }

        void ldap(boolean ldap) {
            this.ldap = ldap;
            this.ldapBuildStage = 1;
        }

        String version() {
            if (this.versionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.versionBuildStage == 0) {
                this.versionBuildStage = (byte)-1;
                this.version = Objects.requireNonNull(ImmutableUserConfig.super.version(), "version");
                this.versionBuildStage = 1;
            }
            return this.version;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.passwordHashBuildStage == -1) {
                attributes.add("passwordHash");
            }
            if (this.ldapBuildStage == -1) {
                attributes.add("ldap");
            }
            if (this.versionBuildStage == -1) {
                attributes.add("version");
            }
            return "Cannot build UserConfig, attribute initializers form cycle " + attributes;
        }
    }
}

