/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.config;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.SmtpConfig;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMap;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SmtpConfig", generator="Immutables")
@Immutable
public final class ImmutableSmtpConfig
extends SmtpConfig {
    private final String host;
    private final @org.checkerframework.checker.nullness.qual.Nullable Integer port;
    private final @org.checkerframework.checker.nullness.qual.Nullable SmtpConfig.ConnectionSecurity connectionSecurity;
    private final String username;
    private final String encryptedPassword;
    private final ImmutableMap<String, String> additionalProperties;
    private final String fromEmailAddress;
    private final String fromDisplayName;
    private final transient String version;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSmtpConfig(Builder builder) {
        this.port = builder.port;
        this.connectionSecurity = builder.connectionSecurity;
        this.additionalProperties = builder.additionalProperties.build();
        if (builder.host != null) {
            this.initShim.host(builder.host);
        }
        if (builder.username != null) {
            this.initShim.username(builder.username);
        }
        if (builder.encryptedPassword != null) {
            this.initShim.encryptedPassword(builder.encryptedPassword);
        }
        if (builder.fromEmailAddress != null) {
            this.initShim.fromEmailAddress(builder.fromEmailAddress);
        }
        if (builder.fromDisplayName != null) {
            this.initShim.fromDisplayName(builder.fromDisplayName);
        }
        this.host = this.initShim.host();
        this.username = this.initShim.username();
        this.encryptedPassword = this.initShim.encryptedPassword();
        this.fromEmailAddress = this.initShim.fromEmailAddress();
        this.fromDisplayName = this.initShim.fromDisplayName();
        this.version = this.initShim.version();
        this.initShim = null;
    }

    private ImmutableSmtpConfig(String host, @org.checkerframework.checker.nullness.qual.Nullable Integer port, @org.checkerframework.checker.nullness.qual.Nullable SmtpConfig.ConnectionSecurity connectionSecurity, String username, String encryptedPassword, ImmutableMap<String, String> additionalProperties, String fromEmailAddress, String fromDisplayName) {
        this.initShim.host(host);
        this.port = port;
        this.connectionSecurity = connectionSecurity;
        this.initShim.username(username);
        this.initShim.encryptedPassword(encryptedPassword);
        this.additionalProperties = additionalProperties;
        this.initShim.fromEmailAddress(fromEmailAddress);
        this.initShim.fromDisplayName(fromDisplayName);
        this.host = this.initShim.host();
        this.username = this.initShim.username();
        this.encryptedPassword = this.initShim.encryptedPassword();
        this.fromEmailAddress = this.initShim.fromEmailAddress();
        this.fromDisplayName = this.initShim.fromDisplayName();
        this.version = this.initShim.version();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="host")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String host() {
        InitShim shim = this.initShim;
        return shim != null ? shim.host() : this.host;
    }

    @Override
    @JsonProperty(value="port")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public @org.checkerframework.checker.nullness.qual.Nullable Integer port() {
        return this.port;
    }

    @Override
    @JsonProperty(value="connectionSecurity")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public @org.checkerframework.checker.nullness.qual.Nullable SmtpConfig.ConnectionSecurity connectionSecurity() {
        return this.connectionSecurity;
    }

    @Override
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String username() {
        InitShim shim = this.initShim;
        return shim != null ? shim.username() : this.username;
    }

    @Override
    @JsonProperty(value="encryptedPassword")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String encryptedPassword() {
        InitShim shim = this.initShim;
        return shim != null ? shim.encryptedPassword() : this.encryptedPassword;
    }

    @JsonProperty(value="additionalProperties")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ImmutableMap<String, String> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    @JsonProperty(value="fromEmailAddress")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String fromEmailAddress() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fromEmailAddress() : this.fromEmailAddress;
    }

    @Override
    @JsonProperty(value="fromDisplayName")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String fromDisplayName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fromDisplayName() : this.fromDisplayName;
    }

    @Override
    @JsonProperty(value="version")
    @JsonIgnore
    public String version() {
        InitShim shim = this.initShim;
        return shim != null ? shim.version() : this.version;
    }

    public final ImmutableSmtpConfig withHost(String value) {
        String newValue = Objects.requireNonNull(value, "host");
        if (this.host.equals(newValue)) {
            return this;
        }
        return new ImmutableSmtpConfig(newValue, this.port, this.connectionSecurity, this.username, this.encryptedPassword, this.additionalProperties, this.fromEmailAddress, this.fromDisplayName);
    }

    public final ImmutableSmtpConfig withPort(@org.checkerframework.checker.nullness.qual.Nullable Integer value) {
        if (Objects.equals(this.port, value)) {
            return this;
        }
        return new ImmutableSmtpConfig(this.host, value, this.connectionSecurity, this.username, this.encryptedPassword, this.additionalProperties, this.fromEmailAddress, this.fromDisplayName);
    }

    public final ImmutableSmtpConfig withConnectionSecurity(@org.checkerframework.checker.nullness.qual.Nullable SmtpConfig.ConnectionSecurity value) {
        if (this.connectionSecurity == value) {
            return this;
        }
        return new ImmutableSmtpConfig(this.host, this.port, value, this.username, this.encryptedPassword, this.additionalProperties, this.fromEmailAddress, this.fromDisplayName);
    }

    public final ImmutableSmtpConfig withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutableSmtpConfig(this.host, this.port, this.connectionSecurity, newValue, this.encryptedPassword, this.additionalProperties, this.fromEmailAddress, this.fromDisplayName);
    }

    public final ImmutableSmtpConfig withEncryptedPassword(String value) {
        String newValue = Objects.requireNonNull(value, "encryptedPassword");
        if (this.encryptedPassword.equals(newValue)) {
            return this;
        }
        return new ImmutableSmtpConfig(this.host, this.port, this.connectionSecurity, this.username, newValue, this.additionalProperties, this.fromEmailAddress, this.fromDisplayName);
    }

    public final ImmutableSmtpConfig withAdditionalProperties(Map<String, ? extends String> entries) {
        if (this.additionalProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableSmtpConfig(this.host, this.port, this.connectionSecurity, this.username, this.encryptedPassword, (ImmutableMap<String, String>)newValue, this.fromEmailAddress, this.fromDisplayName);
    }

    public final ImmutableSmtpConfig withFromEmailAddress(String value) {
        String newValue = Objects.requireNonNull(value, "fromEmailAddress");
        if (this.fromEmailAddress.equals(newValue)) {
            return this;
        }
        return new ImmutableSmtpConfig(this.host, this.port, this.connectionSecurity, this.username, this.encryptedPassword, this.additionalProperties, newValue, this.fromDisplayName);
    }

    public final ImmutableSmtpConfig withFromDisplayName(String value) {
        String newValue = Objects.requireNonNull(value, "fromDisplayName");
        if (this.fromDisplayName.equals(newValue)) {
            return this;
        }
        return new ImmutableSmtpConfig(this.host, this.port, this.connectionSecurity, this.username, this.encryptedPassword, this.additionalProperties, this.fromEmailAddress, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSmtpConfig && this.equalTo(0, (ImmutableSmtpConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableSmtpConfig another) {
        return this.host.equals(another.host) && Objects.equals(this.port, another.port) && Objects.equals((Object)this.connectionSecurity, (Object)another.connectionSecurity) && this.username.equals(another.username) && this.encryptedPassword.equals(another.encryptedPassword) && this.additionalProperties.equals(another.additionalProperties) && this.fromEmailAddress.equals(another.fromEmailAddress) && this.fromDisplayName.equals(another.fromDisplayName) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.host.hashCode();
        h += (h << 5) + Objects.hashCode(this.port);
        h += (h << 5) + Objects.hashCode((Object)this.connectionSecurity);
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.encryptedPassword.hashCode();
        h += (h << 5) + this.additionalProperties.hashCode();
        h += (h << 5) + this.fromEmailAddress.hashCode();
        h += (h << 5) + this.fromDisplayName.hashCode();
        h += (h << 5) + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SmtpConfig").omitNullValues().add("host", (Object)this.host).add("port", (Object)this.port).add("connectionSecurity", (Object)this.connectionSecurity).add("username", (Object)this.username).add("encryptedPassword", (Object)this.encryptedPassword).add("additionalProperties", this.additionalProperties).add("fromEmailAddress", (Object)this.fromEmailAddress).add("fromDisplayName", (Object)this.fromDisplayName).add("version", (Object)this.version).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSmtpConfig fromJson(Json json) {
        Builder builder = ImmutableSmtpConfig.builder();
        if (json.host != null) {
            builder.host(json.host);
        }
        if (json.port != null) {
            builder.port(json.port);
        }
        if (json.connectionSecurity != null) {
            builder.connectionSecurity(json.connectionSecurity);
        }
        if (json.username != null) {
            builder.username(json.username);
        }
        if (json.encryptedPassword != null) {
            builder.encryptedPassword(json.encryptedPassword);
        }
        if (json.additionalProperties != null) {
            builder.putAllAdditionalProperties(json.additionalProperties);
        }
        if (json.fromEmailAddress != null) {
            builder.fromEmailAddress(json.fromEmailAddress);
        }
        if (json.fromDisplayName != null) {
            builder.fromDisplayName(json.fromDisplayName);
        }
        return builder.build();
    }

    public static ImmutableSmtpConfig copyOf(SmtpConfig instance) {
        if (instance instanceof ImmutableSmtpConfig) {
            return (ImmutableSmtpConfig)instance;
        }
        return ImmutableSmtpConfig.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SmtpConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String host;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable Integer port;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable SmtpConfig.ConnectionSecurity connectionSecurity;
        @Nullable
        private String username;
        @Nullable
        private String encryptedPassword;
        private ImmutableMap.Builder<String, String> additionalProperties = ImmutableMap.builder();
        @Nullable
        private String fromEmailAddress;
        @Nullable
        private String fromDisplayName;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(SmtpConfig instance) {
            SmtpConfig.ConnectionSecurity connectionSecurityValue;
            Objects.requireNonNull(instance, "instance");
            this.host(instance.host());
            @org.checkerframework.checker.nullness.qual.Nullable Integer portValue = instance.port();
            if (portValue != null) {
                this.port(portValue);
            }
            if ((connectionSecurityValue = instance.connectionSecurity()) != null) {
                this.connectionSecurity(connectionSecurityValue);
            }
            this.username(instance.username());
            this.encryptedPassword(instance.encryptedPassword());
            this.putAllAdditionalProperties(instance.additionalProperties());
            this.fromEmailAddress(instance.fromEmailAddress());
            this.fromDisplayName(instance.fromDisplayName());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder port(@org.checkerframework.checker.nullness.qual.Nullable Integer port) {
            this.port = port;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder connectionSecurity(@org.checkerframework.checker.nullness.qual.Nullable SmtpConfig.ConnectionSecurity connectionSecurity) {
            this.connectionSecurity = connectionSecurity;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder encryptedPassword(String encryptedPassword) {
            this.encryptedPassword = Objects.requireNonNull(encryptedPassword, "encryptedPassword");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAdditionalProperties(String key, String value) {
            this.additionalProperties.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAdditionalProperties(Map.Entry<String, ? extends String> entry) {
            this.additionalProperties.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder additionalProperties(Map<String, ? extends String> entries) {
            this.additionalProperties = ImmutableMap.builder();
            return this.putAllAdditionalProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllAdditionalProperties(Map<String, ? extends String> entries) {
            this.additionalProperties.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = Objects.requireNonNull(fromEmailAddress, "fromEmailAddress");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fromDisplayName(String fromDisplayName) {
            this.fromDisplayName = Objects.requireNonNull(fromDisplayName, "fromDisplayName");
            return this;
        }

        public ImmutableSmtpConfig build() {
            return new ImmutableSmtpConfig(this);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SmtpConfig", generator="Immutables")
    static final class Json
    extends SmtpConfig {
        @Nullable
        String host;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable Integer port;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable SmtpConfig.ConnectionSecurity connectionSecurity;
        @Nullable
        String username;
        @Nullable
        String encryptedPassword;
        @Nullable
        Map<String, String> additionalProperties = ImmutableMap.of();
        @Nullable
        String fromEmailAddress;
        @Nullable
        String fromDisplayName;

        Json() {
        }

        @JsonProperty(value="host")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setHost(String host) {
            this.host = host;
        }

        @JsonProperty(value="port")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setPort(@org.checkerframework.checker.nullness.qual.Nullable Integer port) {
            this.port = port;
        }

        @JsonProperty(value="connectionSecurity")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setConnectionSecurity(@org.checkerframework.checker.nullness.qual.Nullable SmtpConfig.ConnectionSecurity connectionSecurity) {
            this.connectionSecurity = connectionSecurity;
        }

        @JsonProperty(value="username")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setUsername(String username) {
            this.username = username;
        }

        @JsonProperty(value="encryptedPassword")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setEncryptedPassword(String encryptedPassword) {
            this.encryptedPassword = encryptedPassword;
        }

        @JsonProperty(value="additionalProperties")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setAdditionalProperties(Map<String, String> additionalProperties) {
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="fromEmailAddress")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setFromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
        }

        @JsonProperty(value="fromDisplayName")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setFromDisplayName(String fromDisplayName) {
            this.fromDisplayName = fromDisplayName;
        }

        @Override
        public String host() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable Integer port() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable SmtpConfig.ConnectionSecurity connectionSecurity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String username() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String encryptedPassword() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> additionalProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String fromEmailAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String fromDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String version() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="SmtpConfig", generator="Immutables")
    private final class InitShim {
        private byte hostBuildStage = 0;
        private String host;
        private byte usernameBuildStage = 0;
        private String username;
        private byte encryptedPasswordBuildStage = 0;
        private String encryptedPassword;
        private byte fromEmailAddressBuildStage = 0;
        private String fromEmailAddress;
        private byte fromDisplayNameBuildStage = 0;
        private String fromDisplayName;
        private byte versionBuildStage = 0;
        private String version;

        private InitShim() {
        }

        String host() {
            if (this.hostBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hostBuildStage == 0) {
                this.hostBuildStage = (byte)-1;
                this.host = Objects.requireNonNull(ImmutableSmtpConfig.super.host(), "host");
                this.hostBuildStage = 1;
            }
            return this.host;
        }

        void host(String host) {
            this.host = host;
            this.hostBuildStage = 1;
        }

        String username() {
            if (this.usernameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameBuildStage == 0) {
                this.usernameBuildStage = (byte)-1;
                this.username = Objects.requireNonNull(ImmutableSmtpConfig.super.username(), "username");
                this.usernameBuildStage = 1;
            }
            return this.username;
        }

        void username(String username) {
            this.username = username;
            this.usernameBuildStage = 1;
        }

        String encryptedPassword() {
            if (this.encryptedPasswordBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.encryptedPasswordBuildStage == 0) {
                this.encryptedPasswordBuildStage = (byte)-1;
                this.encryptedPassword = Objects.requireNonNull(ImmutableSmtpConfig.super.encryptedPassword(), "encryptedPassword");
                this.encryptedPasswordBuildStage = 1;
            }
            return this.encryptedPassword;
        }

        void encryptedPassword(String encryptedPassword) {
            this.encryptedPassword = encryptedPassword;
            this.encryptedPasswordBuildStage = 1;
        }

        String fromEmailAddress() {
            if (this.fromEmailAddressBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fromEmailAddressBuildStage == 0) {
                this.fromEmailAddressBuildStage = (byte)-1;
                this.fromEmailAddress = Objects.requireNonNull(ImmutableSmtpConfig.super.fromEmailAddress(), "fromEmailAddress");
                this.fromEmailAddressBuildStage = 1;
            }
            return this.fromEmailAddress;
        }

        void fromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
            this.fromEmailAddressBuildStage = 1;
        }

        String fromDisplayName() {
            if (this.fromDisplayNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fromDisplayNameBuildStage == 0) {
                this.fromDisplayNameBuildStage = (byte)-1;
                this.fromDisplayName = Objects.requireNonNull(ImmutableSmtpConfig.super.fromDisplayName(), "fromDisplayName");
                this.fromDisplayNameBuildStage = 1;
            }
            return this.fromDisplayName;
        }

        void fromDisplayName(String fromDisplayName) {
            this.fromDisplayName = fromDisplayName;
            this.fromDisplayNameBuildStage = 1;
        }

        String version() {
            if (this.versionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.versionBuildStage == 0) {
                this.versionBuildStage = (byte)-1;
                this.version = Objects.requireNonNull(ImmutableSmtpConfig.super.version(), "version");
                this.versionBuildStage = 1;
            }
            return this.version;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.hostBuildStage == -1) {
                attributes.add("host");
            }
            if (this.usernameBuildStage == -1) {
                attributes.add("username");
            }
            if (this.encryptedPasswordBuildStage == -1) {
                attributes.add("encryptedPassword");
            }
            if (this.fromEmailAddressBuildStage == -1) {
                attributes.add("fromEmailAddress");
            }
            if (this.fromDisplayNameBuildStage == -1) {
                attributes.add("fromDisplayName");
            }
            if (this.versionBuildStage == -1) {
                attributes.add("version");
            }
            return "Cannot build SmtpConfig, attribute initializers form cycle " + attributes;
        }
    }
}

