/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.repo;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.tainting.qual.Untainted;
import org.glowroot.agent.collector.Collector;
import org.glowroot.agent.embedded.repo.FullQueryTextDao;
import org.glowroot.agent.embedded.repo.TraceAttributeNameDao;
import org.glowroot.agent.embedded.repo.TracePointQueryBuilder;
import org.glowroot.agent.embedded.repo.TransactionTypeDao;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ImmutableErrorMessageCount;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ImmutableErrorMessagePoint;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ImmutableErrorMessageResult;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ImmutableHeaderPlus;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.TraceRepository;
import org.glowroot.agent.embedded.sql.SQLException;
import org.glowroot.agent.embedded.util.CappedDatabase;
import org.glowroot.agent.embedded.util.DataSource;
import org.glowroot.agent.embedded.util.ImmutableColumn;
import org.glowroot.agent.embedded.util.ImmutableIndex;
import org.glowroot.agent.embedded.util.RowMappers;
import org.glowroot.agent.embedded.util.Schemas;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Strings;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.protobuf.AbstractMessage;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutableEntries;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutableEntriesAndQueries;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutableQueries;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutableTracePoint;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveTraceRepository;
import org.glowroot.agent.shaded.org.glowroot.common.model.Result;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.ProfileOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.TraceOuterClass;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.Checkers;

public class TraceDao
implements TraceRepository {
    private static final String AGENT_ID = "";
    private static final Logger startupLogger = LoggerFactory.getLogger((String)"org.glowroot");
    private static final ImmutableList<Schemas.Column> traceColumns = ImmutableList.of((Object)ImmutableColumn.of("id", Schemas.ColumnType.VARCHAR), (Object)ImmutableColumn.of("partial", Schemas.ColumnType.BOOLEAN), (Object)ImmutableColumn.of("slow", Schemas.ColumnType.BOOLEAN), (Object)ImmutableColumn.of("error", Schemas.ColumnType.BOOLEAN), (Object)ImmutableColumn.of("start_time", Schemas.ColumnType.BIGINT), (Object)ImmutableColumn.of("capture_time", Schemas.ColumnType.BIGINT), (Object)ImmutableColumn.of("duration_nanos", Schemas.ColumnType.BIGINT), (Object)ImmutableColumn.of("transaction_type", Schemas.ColumnType.VARCHAR), (Object)ImmutableColumn.of("transaction_name", Schemas.ColumnType.VARCHAR), (Object)ImmutableColumn.of("headline", Schemas.ColumnType.VARCHAR), (Object)ImmutableColumn.of("user", Schemas.ColumnType.VARCHAR), (Object)ImmutableColumn.of("error_message", Schemas.ColumnType.VARCHAR), (Object[])new Schemas.Column[]{ImmutableColumn.of("header", Schemas.ColumnType.VARBINARY), ImmutableColumn.of("entries_capped_id", Schemas.ColumnType.BIGINT), ImmutableColumn.of("queries_capped_id", Schemas.ColumnType.BIGINT), ImmutableColumn.of("shared_query_texts_capped_id", Schemas.ColumnType.BIGINT), ImmutableColumn.of("main_thread_profile_capped_id", Schemas.ColumnType.BIGINT), ImmutableColumn.of("aux_thread_profile_capped_id", Schemas.ColumnType.BIGINT)});
    private static final ImmutableList<Schemas.Column> traceAttributeColumns = ImmutableList.of((Object)ImmutableColumn.of("trace_id", Schemas.ColumnType.VARCHAR), (Object)ImmutableColumn.of("name", Schemas.ColumnType.VARCHAR), (Object)ImmutableColumn.of("value", Schemas.ColumnType.VARCHAR), (Object)ImmutableColumn.of("capture_time", Schemas.ColumnType.BIGINT));
    private static final ImmutableList<Schemas.Index> traceIndexes = ImmutableList.of((Object)ImmutableIndex.of("trace_overall_slow_idx", (ImmutableList<String>)ImmutableList.of((Object)"transaction_type", (Object)"slow", (Object)"capture_time", (Object)"duration_nanos", (Object)"error", (Object)"id")), (Object)ImmutableIndex.of("trace_transaction_slow_idx", (ImmutableList<String>)ImmutableList.of((Object)"transaction_type", (Object)"transaction_name", (Object)"slow", (Object)"capture_time", (Object)"duration_nanos", (Object)"error", (Object)"id")), (Object)ImmutableIndex.of("trace_error_idx", (ImmutableList<String>)ImmutableList.of((Object)"transaction_type", (Object)"error", (Object)"capture_time", (Object)"duration_nanos", (Object)"error", (Object)"id")), (Object)ImmutableIndex.of("trace_transaction_error_idx", (ImmutableList<String>)ImmutableList.of((Object)"transaction_type", (Object)"transaction_name", (Object)"error", (Object)"capture_time", (Object)"duration_nanos", (Object)"id")), (Object)ImmutableIndex.of("trace_capture_time_idx", (ImmutableList<String>)ImmutableList.of((Object)"capture_time")), (Object)ImmutableIndex.of("trace_idx", (ImmutableList<String>)ImmutableList.of((Object)"id")));
    private static final ImmutableList<Schemas.Index> traceAttributeIndexes = ImmutableList.of((Object)ImmutableIndex.of("trace_attribute_idx", (ImmutableList<String>)ImmutableList.of((Object)"trace_id")));
    private final DataSource dataSource;
    private final CappedDatabase traceCappedDatabase;
    private final TransactionTypeDao transactionTypeDao;
    private final FullQueryTextDao fullQueryTextDao;
    private final TraceAttributeNameDao traceAttributeNameDao;

    TraceDao(DataSource dataSource, CappedDatabase traceCappedDatabase, TransactionTypeDao transactionTypeDao, FullQueryTextDao fullQueryTextDao, TraceAttributeNameDao traceAttributeNameDao) throws Exception {
        this.dataSource = dataSource;
        this.traceCappedDatabase = traceCappedDatabase;
        this.traceAttributeNameDao = traceAttributeNameDao;
        this.transactionTypeDao = transactionTypeDao;
        this.fullQueryTextDao = fullQueryTextDao;
        if (dataSource.tableExists("trace") && !dataSource.columnExists("trace", "shared_query_texts_capped_id")) {
            startupLogger.info("upgrading glowroot schema, this may delay glowroot startup for a few minutes (depending on data size)...");
            dataSource.execute("alter table trace add column shared_query_texts_capped_id bigint");
            startupLogger.info("glowroot schema upgrade complete");
        }
        if (dataSource.tableExists("trace") && !dataSource.columnExists("trace", "queries_capped_id")) {
            startupLogger.info("upgrading glowroot schema, this may delay glowroot startup for a few minutes (depending on data size)...");
            dataSource.execute("alter table trace add column queries_capped_id bigint");
            startupLogger.info("glowroot schema upgrade complete");
        }
        dataSource.syncTable("trace", (List<Schemas.Column>)traceColumns);
        dataSource.syncIndexes("trace", traceIndexes);
        dataSource.syncTable("trace_attribute", (List<Schemas.Column>)traceAttributeColumns);
        dataSource.syncIndexes("trace_attribute", traceAttributeIndexes);
    }

    public void store(Collector.TraceReader traceReader) throws Exception {
        long captureTime = traceReader.captureTime();
        TraceOuterClass.Trace.Builder builder = TraceOuterClass.Trace.newBuilder().setId(traceReader.traceId()).setUpdate(traceReader.update());
        TraceVisitorImpl traceVisitor = new TraceVisitorImpl(captureTime, builder);
        traceReader.accept((Collector.TraceVisitor)traceVisitor);
        TraceOuterClass.Trace trace = builder.build();
        TraceOuterClass.Trace.Header header = trace.getHeader();
        this.dataSource.update(new TraceMerge(trace));
        if (header.getAttributeCount() > 0) {
            if (trace.getUpdate()) {
                this.dataSource.update("delete from trace_attribute where trace_id = ?", trace.getId());
            }
            this.dataSource.batchUpdate(new TraceAttributeInsert(trace));
            for (TraceOuterClass.Trace.Attribute attribute : header.getAttributeList()) {
                this.traceAttributeNameDao.updateLastCaptureTime(header.getTransactionType(), attribute.getName(), header.getCaptureTime());
            }
        }
        this.transactionTypeDao.updateLastCaptureTime(header.getTransactionType(), header.getCaptureTime());
    }

    @Override
    public CompletionStage<Long> readSlowCount(String agentRollupId, TraceRepository.TraceQuery query) throws Exception {
        String transactionName = query.transactionName();
        if (transactionName == null) {
            return CompletableFuture.completedFuture(this.dataSource.queryForLong("select count(*) from trace where transaction_type = ? and capture_time > ? and capture_time <= ? and slow = ?", query.transactionType(), query.from(), query.to(), true));
        }
        return CompletableFuture.completedFuture(this.dataSource.queryForLong("select count(*) from trace where transaction_type = ? and transaction_name = ? and capture_time > ? and capture_time <= ? and slow = ?", query.transactionType(), transactionName, query.from(), query.to(), true));
    }

    public CompletableFuture<Result<LiveTraceRepository.TracePoint>> readSlowPoints(String agentRollupId, TraceRepository.TraceQuery query, LiveTraceRepository.TracePointFilter filter, int limit) throws Exception {
        return CompletableFuture.completedFuture(this.readPoints(LiveTraceRepository.TraceKind.SLOW, query, filter, limit));
    }

    @Override
    public CompletionStage<Long> readErrorCount(String agentRollupId, TraceRepository.TraceQuery query) throws Exception {
        String transactionName = query.transactionName();
        if (transactionName == null) {
            return CompletableFuture.completedFuture(this.dataSource.queryForLong("select count(*) from trace where transaction_type = ? and capture_time > ? and capture_time <= ? and error = ?", query.transactionType(), query.from(), query.to(), true));
        }
        return CompletableFuture.completedFuture(this.dataSource.queryForLong("select count(*) from trace where transaction_type = ? and transaction_name = ? and capture_time > ? and capture_time <= ? and error = ?", query.transactionType(), transactionName, query.from(), query.to(), true));
    }

    public CompletableFuture<Result<LiveTraceRepository.TracePoint>> readErrorPoints(String agentRollupId, TraceRepository.TraceQuery query, LiveTraceRepository.TracePointFilter filter, int limit) throws Exception {
        return CompletableFuture.completedFuture(this.readPoints(LiveTraceRepository.TraceKind.ERROR, query, filter, limit));
    }

    @Override
    public CompletionStage<TraceRepository.ErrorMessageResult> readErrorMessages(String agentRollupId, TraceRepository.TraceQuery query, TraceRepository.ErrorMessageFilter filter, long resolutionMillis, int limit) {
        try {
            List<TraceRepository.ErrorMessagePoint> points = this.dataSource.query(new ErrorPointQuery(query, filter, resolutionMillis));
            List<TraceRepository.ErrorMessageCount> counts = this.dataSource.query(new ErrorMessageCountQuery(query, filter, limit + 1));
            return CompletableFuture.completedFuture(ImmutableErrorMessageResult.builder().addAllPoints(points).counts((Result<TraceRepository.ErrorMessageCount>)Result.create(counts, (int)limit)).build());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletionStage<Long> readErrorMessageCount(String agentRollupId, TraceRepository.TraceQuery query, String errorMessageFilter, CassandraProfile profile) {
        try {
            if (errorMessageFilter.startsWith("/") && errorMessageFilter.endsWith("/")) {
                Pattern errorMessagePattern = Pattern.compile(errorMessageFilter.substring(1, errorMessageFilter.length() - 1));
                return CompletableFuture.completedFuture(this.dataSource.query(new ErrorCountQueryForPattern(query, errorMessagePattern)));
            }
            return CompletableFuture.completedFuture(this.dataSource.query(new ErrorCountQuery(query, errorMessageFilter)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletionStage<TraceRepository.HeaderPlus> readHeaderPlus(String agentId, String traceId) {
        try {
            return CompletableFuture.completedFuture(this.dataSource.queryAtMostOne(new TraceHeaderQuery(traceId)));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletionStage<LiveTraceRepository.Entries> readEntries(String agentId, String traceId, CassandraProfile profile) throws Exception {
        return CompletableFuture.completedFuture(this.dataSource.query(new EntriesQuery(traceId)));
    }

    @Override
    public CompletionStage<LiveTraceRepository.Queries> readQueries(String agentId, String traceId, CassandraProfile profile) throws Exception {
        return CompletableFuture.completedFuture(this.dataSource.query(new QueriesQuery(traceId)));
    }

    public CompletableFuture<LiveTraceRepository.EntriesAndQueries> readEntriesAndQueriesForExport(String agentId, String traceId, CassandraProfile profile) throws Exception {
        LiveTraceRepository.EntriesAndQueries entriesAndQueries = this.dataSource.query(new EntriesAndQueriesQuery(traceId));
        if (entriesAndQueries == null) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.completedFuture(ImmutableEntriesAndQueries.builder().copyFrom(entriesAndQueries).sharedQueryTexts(this.getSharedQueryTextsForExport(entriesAndQueries.sharedQueryTexts())).build());
    }

    @Override
    public CompletionStage<ProfileOuterClass.Profile> readMainThreadProfile(String agentId, String traceId) throws Exception {
        Long cappedId = this.dataSource.queryForOptionalLong("select main_thread_profile_capped_id from trace where id = ?", traceId);
        if (cappedId == null) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.completedFuture((ProfileOuterClass.Profile)this.traceCappedDatabase.readMessage(cappedId, ProfileOuterClass.Profile.parser()));
    }

    @Override
    public CompletionStage<ProfileOuterClass.Profile> readAuxThreadProfile(String agentId, String traceId) throws Exception {
        Long cappedId = this.dataSource.queryForOptionalLong("select aux_thread_profile_capped_id from trace where id = ?", traceId);
        if (cappedId == null) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.completedFuture((ProfileOuterClass.Profile)this.traceCappedDatabase.readMessage(cappedId, ProfileOuterClass.Profile.parser()));
    }

    void deleteBefore(long captureTime) throws SQLException {
        this.traceAttributeNameDao.deleteBefore(captureTime);
        this.dataSource.deleteBefore("trace", captureTime);
        this.dataSource.deleteBefore("trace_attribute", captureTime);
    }

    private Result<LiveTraceRepository.TracePoint> readPoints(LiveTraceRepository.TraceKind traceKind, TraceRepository.TraceQuery query, LiveTraceRepository.TracePointFilter filter, int limit) throws Exception {
        TracePointQueryBuilder.ParameterizedSql parameterizedSql = new TracePointQueryBuilder(traceKind, query, filter, limit).getParameterizedSql();
        List<LiveTraceRepository.TracePoint> points = this.dataSource.query(new TracePointQuery(parameterizedSql));
        return Result.create(points, (int)limit);
    }

    private List<TraceOuterClass.Trace.SharedQueryText> getSharedQueryTextsForExport(List<TraceOuterClass.Trace.SharedQueryText> sharedQueryTexts) throws SQLException {
        ArrayList sharedQueryTextsForExport = Lists.newArrayList();
        for (TraceOuterClass.Trace.SharedQueryText sharedQueryText : sharedQueryTexts) {
            String fullTextSha1 = sharedQueryText.getFullTextSha1();
            if (fullTextSha1.isEmpty()) {
                sharedQueryTextsForExport.add(sharedQueryText);
                continue;
            }
            String fullText = this.fullQueryTextDao.getFullText(fullTextSha1);
            if (fullText == null) {
                sharedQueryTextsForExport.add(TraceOuterClass.Trace.SharedQueryText.newBuilder().setFullText(sharedQueryText.getTruncatedText() + " ... [full query text has expired] ... " + sharedQueryText.getTruncatedEndText()).build());
                continue;
            }
            sharedQueryTextsForExport.add(TraceOuterClass.Trace.SharedQueryText.newBuilder().setFullText(fullText).build());
        }
        return sharedQueryTextsForExport;
    }

    private static void appendQuery(StringBuilder sql, TraceRepository.TraceQuery query) {
        sql.append(" and transaction_type = ?");
        String transactionName = query.transactionName();
        if (transactionName != null) {
            sql.append(" and transaction_name = ?");
        }
        sql.append(" and capture_time > ? and capture_time <= ?");
    }

    private static void appendFilter(StringBuilder sql, TraceRepository.ErrorMessageFilter filter) {
        int i;
        for (i = 0; i < filter.includes().size(); ++i) {
            sql.append(" and upper(error_message) like ?");
        }
        for (i = 0; i < filter.excludes().size(); ++i) {
            sql.append(" and upper(error_message) not like ?");
        }
    }

    private static int bindQuery(PreparedStatement preparedStatement, int startIndex, TraceRepository.TraceQuery query) throws SQLException {
        int i = startIndex;
        preparedStatement.setString(i++, query.transactionType());
        String transactionName = query.transactionName();
        if (transactionName != null) {
            preparedStatement.setString(i++, transactionName);
        }
        preparedStatement.setLong(i++, query.from());
        preparedStatement.setLong(i++, query.to());
        return i;
    }

    private static int bindFilter(PreparedStatement preparedStatement, int startIndex, TraceRepository.ErrorMessageFilter filter) throws SQLException {
        int i = startIndex;
        for (String include : filter.includes()) {
            preparedStatement.setString(i++, '%' + include.toUpperCase(Locale.ENGLISH) + '%');
        }
        for (String exclude : filter.excludes()) {
            preparedStatement.setString(i++, '%' + exclude.toUpperCase(Locale.ENGLISH) + '%');
        }
        return i;
    }

    private static class ErrorCountQueryForPattern
    implements DataSource.JdbcQuery<Long> {
        private final TraceRepository.TraceQuery query;
        private final Pattern errorMessagePattern;

        private ErrorCountQueryForPattern(TraceRepository.TraceQuery query, Pattern errorMessagePattern) {
            this.query = query;
            this.errorMessagePattern = errorMessagePattern;
        }

        @Override
        public @Untainted String getSql() {
            StringBuilder sql = new StringBuilder();
            sql.append("select error_message from trace where error = ?");
            TraceDao.appendQuery(sql, this.query);
            return (String)Checkers.castUntainted((Object)sql.toString());
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws SQLException {
            int i = 1;
            preparedStatement.setBoolean(i++, true);
            TraceDao.bindQuery(preparedStatement, i, this.query);
        }

        @Override
        public Long processResultSet(ResultSet resultSet) throws Exception {
            long count = 0L;
            while (resultSet.next()) {
                String errorMessage = (String)Preconditions.checkNotNull((Object)resultSet.getString(1));
                if (!this.errorMessagePattern.matcher(errorMessage).find()) continue;
                ++count;
            }
            return count;
        }

        @Override
        public Long valueIfDataSourceClosed() {
            return 0L;
        }
    }

    private static class ErrorCountQuery
    implements DataSource.JdbcQuery<Long> {
        private final TraceRepository.TraceQuery query;
        private final String errorMessageFilter;

        private ErrorCountQuery(TraceRepository.TraceQuery query, String errorMessageFilter) {
            this.query = query;
            this.errorMessageFilter = errorMessageFilter;
        }

        @Override
        public @Untainted String getSql() {
            StringBuilder sql = new StringBuilder();
            sql.append("select count(*) from trace where error = ?");
            TraceDao.appendQuery(sql, this.query);
            sql.append(" and error_message like ?");
            return (String)Checkers.castUntainted((Object)sql.toString());
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws SQLException {
            int i = 1;
            preparedStatement.setBoolean(i++, true);
            i = TraceDao.bindQuery(preparedStatement, i, this.query);
            preparedStatement.setString(i++, '%' + this.errorMessageFilter + '%');
        }

        @Override
        public Long processResultSet(ResultSet resultSet) throws Exception {
            resultSet.next();
            return resultSet.getLong(1);
        }

        @Override
        public Long valueIfDataSourceClosed() {
            return 0L;
        }
    }

    private static class ErrorMessageCountQuery
    implements DataSource.JdbcRowQuery<TraceRepository.ErrorMessageCount> {
        private final TraceRepository.TraceQuery query;
        private final TraceRepository.ErrorMessageFilter filter;
        private final int limit;

        private ErrorMessageCountQuery(TraceRepository.TraceQuery query, TraceRepository.ErrorMessageFilter filter, int limit) {
            this.query = query;
            this.filter = filter;
            this.limit = limit;
        }

        @Override
        public @Untainted String getSql() {
            StringBuilder sql = new StringBuilder();
            sql.append("select error_message, count(*) from trace where error = ?");
            TraceDao.appendQuery(sql, this.query);
            TraceDao.appendFilter(sql, this.filter);
            sql.append(" group by error_message order by count(*) desc limit ?");
            return (String)Checkers.castUntainted((Object)sql.toString());
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws SQLException {
            int i = 1;
            preparedStatement.setBoolean(i++, true);
            i = TraceDao.bindQuery(preparedStatement, i, this.query);
            i = TraceDao.bindFilter(preparedStatement, i, this.filter);
            preparedStatement.setInt(i++, this.limit);
        }

        @Override
        public TraceRepository.ErrorMessageCount mapRow(ResultSet resultSet) throws SQLException {
            return ImmutableErrorMessageCount.builder().message(Strings.nullToEmpty((String)resultSet.getString(1))).count(resultSet.getLong(2)).build();
        }
    }

    private static class ErrorPointQuery
    implements DataSource.JdbcRowQuery<TraceRepository.ErrorMessagePoint> {
        private final TraceRepository.TraceQuery query;
        private final TraceRepository.ErrorMessageFilter filter;
        private final long resolutionMillis;

        private ErrorPointQuery(TraceRepository.TraceQuery query, TraceRepository.ErrorMessageFilter filter, long resolutionMillis) {
            this.query = query;
            this.filter = filter;
            this.resolutionMillis = resolutionMillis;
        }

        @Override
        public @Untainted String getSql() {
            String captureTimeSql = (String)Checkers.castUntainted((Object)("ceil(capture_time / " + this.resolutionMillis + ".0) * " + this.resolutionMillis));
            StringBuilder sql = new StringBuilder();
            sql.append("select " + captureTimeSql + ", count(*) from trace where error = ?");
            TraceDao.appendQuery(sql, this.query);
            TraceDao.appendFilter(sql, this.filter);
            sql.append(" group by " + captureTimeSql + " order by " + captureTimeSql);
            return (String)Checkers.castUntainted((Object)sql.toString());
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws SQLException {
            int i = 1;
            preparedStatement.setBoolean(i++, true);
            i = TraceDao.bindQuery(preparedStatement, i, this.query);
            TraceDao.bindFilter(preparedStatement, i, this.filter);
        }

        @Override
        public TraceRepository.ErrorMessagePoint mapRow(ResultSet resultSet) throws SQLException {
            long captureTime = resultSet.getLong(1);
            long errorCount = resultSet.getLong(2);
            return ImmutableErrorMessagePoint.of(captureTime, errorCount);
        }
    }

    private class EntriesAndQueriesQuery
    implements DataSource.JdbcQuery<LiveTraceRepository.EntriesAndQueries> {
        private final String traceId;

        private EntriesAndQueriesQuery(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public @Untainted String getSql() {
            return "select entries_capped_id, queries_capped_id, shared_query_texts_capped_id from trace where id = ?";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws SQLException {
            preparedStatement.setString(1, this.traceId);
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable LiveTraceRepository.EntriesAndQueries processResultSet(ResultSet resultSet) throws Exception {
            if (!resultSet.next()) {
                return null;
            }
            int i = 1;
            Long entriesCappedId = RowMappers.getLong(resultSet, i++);
            Long queriesCappedId = RowMappers.getLong(resultSet, i++);
            Long sharedQueryTextsCappedId = RowMappers.getLong(resultSet, i++);
            Object entries = ImmutableList.of();
            if (entriesCappedId != null) {
                entries = TraceDao.this.traceCappedDatabase.readMessages(entriesCappedId, TraceOuterClass.Trace.Entry.parser());
            }
            Object queries = ImmutableList.of();
            if (queriesCappedId != null) {
                queries = TraceDao.this.traceCappedDatabase.readMessages(queriesCappedId, AggregateOuterClass.Aggregate.Query.parser());
            }
            if (entries.isEmpty() && queries.isEmpty()) {
                return null;
            }
            ImmutableEntriesAndQueries.Builder result = ImmutableEntriesAndQueries.builder().addAllEntries((Iterable)entries).addAllQueries((Iterable)queries);
            if (sharedQueryTextsCappedId != null) {
                result.addAllSharedQueryTexts(TraceDao.this.traceCappedDatabase.readMessages(sharedQueryTextsCappedId, TraceOuterClass.Trace.SharedQueryText.parser()));
            }
            return result.build();
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable LiveTraceRepository.EntriesAndQueries valueIfDataSourceClosed() {
            return null;
        }
    }

    private class QueriesQuery
    implements DataSource.JdbcQuery<LiveTraceRepository.Queries> {
        private final String traceId;

        private QueriesQuery(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public @Untainted String getSql() {
            return "select queries_capped_id, shared_query_texts_capped_id from trace where id = ?";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws SQLException {
            preparedStatement.setString(1, this.traceId);
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable LiveTraceRepository.Queries processResultSet(ResultSet resultSet) throws Exception {
            if (!resultSet.next()) {
                return null;
            }
            int i = 1;
            Long queriesCappedId = RowMappers.getLong(resultSet, i++);
            Long sharedQueryTextsCappedId = RowMappers.getLong(resultSet, i++);
            if (queriesCappedId == null) {
                return null;
            }
            List queries = TraceDao.this.traceCappedDatabase.readMessages(queriesCappedId, AggregateOuterClass.Aggregate.Query.parser());
            if (queries.isEmpty()) {
                return null;
            }
            ImmutableQueries.Builder result = ImmutableQueries.builder().addAllQueries(queries);
            if (sharedQueryTextsCappedId != null) {
                result.addAllSharedQueryTexts(TraceDao.this.traceCappedDatabase.readMessages(sharedQueryTextsCappedId, TraceOuterClass.Trace.SharedQueryText.parser()));
            }
            return result.build();
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable LiveTraceRepository.Queries valueIfDataSourceClosed() {
            return null;
        }
    }

    private class EntriesQuery
    implements DataSource.JdbcQuery<LiveTraceRepository.Entries> {
        private final String traceId;

        private EntriesQuery(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public @Untainted String getSql() {
            return "select entries_capped_id, shared_query_texts_capped_id from trace where id = ?";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws SQLException {
            preparedStatement.setString(1, this.traceId);
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable LiveTraceRepository.Entries processResultSet(ResultSet resultSet) throws Exception {
            if (!resultSet.next()) {
                return null;
            }
            int i = 1;
            Long entriesCappedId = RowMappers.getLong(resultSet, i++);
            Long sharedQueryTextsCappedId = RowMappers.getLong(resultSet, i++);
            if (entriesCappedId == null) {
                return null;
            }
            List entries = TraceDao.this.traceCappedDatabase.readMessages(entriesCappedId, TraceOuterClass.Trace.Entry.parser());
            if (entries.isEmpty()) {
                return null;
            }
            ImmutableEntries.Builder result = ImmutableEntries.builder().addAllEntries(entries);
            if (sharedQueryTextsCappedId != null) {
                result.addAllSharedQueryTexts(TraceDao.this.traceCappedDatabase.readMessages(sharedQueryTextsCappedId, TraceOuterClass.Trace.SharedQueryText.parser()));
            }
            return result.build();
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable LiveTraceRepository.Entries valueIfDataSourceClosed() {
            return null;
        }
    }

    private class TraceHeaderQuery
    implements DataSource.JdbcRowQuery<TraceRepository.HeaderPlus> {
        private final String traceId;

        private TraceHeaderQuery(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public @Untainted String getSql() {
            return "select headline, user, header, entries_capped_id, queries_capped_id, main_thread_profile_capped_id, aux_thread_profile_capped_id from trace where id = ?";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws SQLException {
            preparedStatement.setString(1, this.traceId);
        }

        @Override
        public TraceRepository.HeaderPlus mapRow(ResultSet resultSet) throws Exception {
            int i = 1;
            String headline = (String)Preconditions.checkNotNull((Object)resultSet.getString(i++));
            String user = resultSet.getString(i++);
            byte[] headerBytes = (byte[])Preconditions.checkNotNull((Object)resultSet.getBytes(i++));
            LiveTraceRepository.Existence entriesExistence = RowMappers.getExistence(resultSet, i++, TraceDao.this.traceCappedDatabase);
            LiveTraceRepository.Existence queriesExistence = RowMappers.getExistence(resultSet, i++, TraceDao.this.traceCappedDatabase);
            LiveTraceRepository.Existence mainThreadProfileExistence = RowMappers.getExistence(resultSet, i++, TraceDao.this.traceCappedDatabase);
            LiveTraceRepository.Existence auxThreadProfileExistence = RowMappers.getExistence(resultSet, i++, TraceDao.this.traceCappedDatabase);
            LiveTraceRepository.Existence profileExistence = mainThreadProfileExistence == LiveTraceRepository.Existence.EXPIRED || auxThreadProfileExistence == LiveTraceRepository.Existence.EXPIRED ? LiveTraceRepository.Existence.EXPIRED : (mainThreadProfileExistence == LiveTraceRepository.Existence.YES || auxThreadProfileExistence == LiveTraceRepository.Existence.YES ? LiveTraceRepository.Existence.YES : LiveTraceRepository.Existence.NO);
            return ImmutableHeaderPlus.builder().header(TraceOuterClass.Trace.Header.parseFrom((byte[])headerBytes).toBuilder().setHeadline(headline).setUser(Strings.nullToEmpty((String)user)).build()).entriesExistence(entriesExistence).queriesExistence(queriesExistence).profileExistence(profileExistence).build();
        }
    }

    private static class TracePointQuery
    implements DataSource.JdbcRowQuery<LiveTraceRepository.TracePoint> {
        private final TracePointQueryBuilder.ParameterizedSql parameterizedSql;

        private TracePointQuery(TracePointQueryBuilder.ParameterizedSql parameterizedSql) {
            this.parameterizedSql = parameterizedSql;
        }

        @Override
        public @Untainted String getSql() {
            return (String)Checkers.castUntainted((Object)this.parameterizedSql.sql());
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws SQLException {
            int i = 1;
            for (Object obj : this.parameterizedSql.args()) {
                preparedStatement.setObject(i++, obj);
            }
        }

        @Override
        public LiveTraceRepository.TracePoint mapRow(ResultSet resultSet) throws SQLException {
            int i = 1;
            String traceId = (String)Preconditions.checkNotNull((Object)resultSet.getString(i++));
            return ImmutableTracePoint.builder().agentId(TraceDao.AGENT_ID).traceId(traceId).captureTime(resultSet.getLong(i++)).durationNanos(resultSet.getLong(i++)).partial(resultSet.getBoolean(i++)).error(resultSet.getBoolean(i++)).checkLiveTraces(false).build();
        }
    }

    private static class TraceAttributeInsert
    implements DataSource.JdbcUpdate {
        private final TraceOuterClass.Trace trace;

        private TraceAttributeInsert(TraceOuterClass.Trace trace) {
            this.trace = trace;
        }

        @Override
        public @Untainted String getSql() {
            return "insert into trace_attribute (trace_id, name, value, capture_time) values (?, ?, ?, ?)";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws SQLException {
            TraceOuterClass.Trace.Header header = this.trace.getHeader();
            for (TraceOuterClass.Trace.Attribute attribute : header.getAttributeList()) {
                for (String value : attribute.getValueList()) {
                    int i = 1;
                    preparedStatement.setString(i++, this.trace.getId());
                    preparedStatement.setString(i++, attribute.getName());
                    preparedStatement.setString(i++, value);
                    preparedStatement.setLong(i++, header.getCaptureTime());
                    preparedStatement.addBatch();
                }
            }
        }
    }

    private class TraceMerge
    implements DataSource.JdbcUpdate {
        private final String traceId;
        private final TraceOuterClass.Trace.Header header;
        private final @Nullable Long entriesCappedId;
        private final @Nullable Long queriesCappedId;
        private final @Nullable Long sharedQueryTextsCappedId;
        private final @Nullable Long mainThreadProfileId;
        private final @Nullable Long auxThreadProfileId;

        private TraceMerge(TraceOuterClass.Trace trace) throws IOException {
            this.traceId = trace.getId();
            this.header = trace.getHeader();
            List entries = trace.getEntryList();
            this.entriesCappedId = entries.isEmpty() ? null : Long.valueOf(TraceDao.this.traceCappedDatabase.writeMessages(entries, "trace entries"));
            List queries = trace.getQueryList();
            this.queriesCappedId = queries.isEmpty() ? null : Long.valueOf(TraceDao.this.traceCappedDatabase.writeMessages(queries, "trace queries"));
            List sharedQueryTexts = trace.getSharedQueryTextList();
            this.sharedQueryTextsCappedId = sharedQueryTexts.isEmpty() ? null : Long.valueOf(TraceDao.this.traceCappedDatabase.writeMessages(sharedQueryTexts, "trace shared query texts"));
            this.mainThreadProfileId = trace.hasMainThreadProfile() ? Long.valueOf(TraceDao.this.traceCappedDatabase.writeMessage((AbstractMessage)trace.getMainThreadProfile(), "trace profiles")) : null;
            this.auxThreadProfileId = trace.hasAuxThreadProfile() ? Long.valueOf(TraceDao.this.traceCappedDatabase.writeMessage((AbstractMessage)trace.getAuxThreadProfile(), "trace profiles")) : null;
        }

        @Override
        public @Untainted String getSql() {
            return "merge into trace (id, partial, slow, error, start_time, capture_time, duration_nanos, transaction_type, transaction_name, headline, user, error_message, header, entries_capped_id, queries_capped_id, shared_query_texts_capped_id, main_thread_profile_capped_id, aux_thread_profile_capped_id) key (id) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws SQLException {
            int i = 1;
            preparedStatement.setString(i++, this.traceId);
            preparedStatement.setBoolean(i++, this.header.getPartial());
            preparedStatement.setBoolean(i++, this.header.getSlow());
            preparedStatement.setBoolean(i++, this.header.hasError());
            preparedStatement.setLong(i++, this.header.getStartTime());
            preparedStatement.setLong(i++, this.header.getCaptureTime());
            preparedStatement.setLong(i++, this.header.getDurationNanos());
            preparedStatement.setString(i++, this.header.getTransactionType());
            preparedStatement.setString(i++, this.header.getTransactionName());
            preparedStatement.setString(i++, this.header.getHeadline());
            preparedStatement.setString(i++, Strings.emptyToNull((String)this.header.getUser()));
            if (this.header.hasError()) {
                preparedStatement.setString(i++, this.header.getError().getMessage());
            } else {
                preparedStatement.setNull(i++, 12);
            }
            preparedStatement.setBytes(i++, this.header.toBuilder().setHeadline(TraceDao.AGENT_ID).setUser(TraceDao.AGENT_ID).build().toByteArray());
            RowMappers.setLong(preparedStatement, i++, this.entriesCappedId);
            RowMappers.setLong(preparedStatement, i++, this.queriesCappedId);
            RowMappers.setLong(preparedStatement, i++, this.sharedQueryTextsCappedId);
            RowMappers.setLong(preparedStatement, i++, this.mainThreadProfileId);
            RowMappers.setLong(preparedStatement, i++, this.auxThreadProfileId);
        }
    }

    private class TraceVisitorImpl
    implements Collector.TraceVisitor {
        private final long captureTime;
        private final TraceOuterClass.Trace.Builder builder;

        private TraceVisitorImpl(long captureTime, TraceOuterClass.Trace.Builder builder) {
            this.captureTime = captureTime;
            this.builder = builder;
        }

        public void visitEntry(TraceOuterClass.Trace.Entry entry) {
            this.builder.addEntry(entry);
        }

        public void visitQueries(List<AggregateOuterClass.Aggregate.Query> queries) {
            this.builder.addAllQuery(queries);
        }

        public void visitSharedQueryTexts(List<String> sharedQueryTexts) throws SQLException {
            for (String sharedQueryText : sharedQueryTexts) {
                if (sharedQueryText.length() > 240) {
                    String truncatedText = sharedQueryText.substring(0, 120);
                    String truncatedEndText = sharedQueryText.substring(sharedQueryText.length() - 120, sharedQueryText.length());
                    String fullTextSha1 = TraceDao.this.fullQueryTextDao.updateLastCaptureTime(sharedQueryText, this.captureTime);
                    this.builder.addSharedQueryText(TraceOuterClass.Trace.SharedQueryText.newBuilder().setTruncatedText(truncatedText).setTruncatedEndText(truncatedEndText).setFullTextSha1(fullTextSha1));
                    continue;
                }
                this.builder.addSharedQueryText(TraceOuterClass.Trace.SharedQueryText.newBuilder().setFullText(sharedQueryText));
            }
        }

        public void visitMainThreadProfile(ProfileOuterClass.Profile profile) {
            this.builder.setMainThreadProfile(profile);
        }

        public void visitAuxThreadProfile(ProfileOuterClass.Profile profile) {
            this.builder.setAuxThreadProfile(profile);
        }

        public void visitHeader(TraceOuterClass.Trace.Header header) {
            this.builder.setHeader(header);
        }
    }
}

