/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.repo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.config.AllConfig;
import org.glowroot.agent.config.ConfigService;
import org.glowroot.agent.config.PluginCache;
import org.glowroot.agent.config.PluginConfig;
import org.glowroot.agent.config.PluginDescriptor;
import org.glowroot.agent.embedded.config.AdminConfigService;
import org.glowroot.agent.embedded.repo.LazySecretKeyImpl;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.AllCentralAdminConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.AllEmbeddedAdminConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.CentralAdminGeneralConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.CentralStorageConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.CentralWebConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.EmbeddedAdminGeneralConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.EmbeddedStorageConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.EmbeddedWebConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.HealthchecksIoConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.HttpProxyConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableAllEmbeddedAdminConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableRoleConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableUserConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.LdapConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.PagerDutyConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.RoleConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.SlackConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.SmtpConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.StorageConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.UserConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.WebConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigValidation;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.LazySecretKey;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.com.google.protobuf.AbstractMessage;
import org.glowroot.agent.shaded.org.glowroot.common.config.AdvancedConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.AlertConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.GaugeConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableAdvancedConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableAlertConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableGaugeConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableInstrumentationConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableJvmConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableTransactionConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableUiDefaultsConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.InstrumentationConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.JvmConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.TransactionConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.UiDefaultsConfig;
import org.glowroot.agent.shaded.org.glowroot.common.util.OnlyUsedByTests;
import org.glowroot.agent.shaded.org.glowroot.common.util.Versions;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;

public class ConfigRepositoryImpl
implements ConfigRepository {
    private final ConfigService configService;
    private final AdminConfigService adminConfigService;
    private final PluginCache pluginCache;
    private final boolean configReadOnly;
    private final ImmutableList<ConfigRepository.RollupConfig> rollupConfigs;
    private final LazySecretKey lazySecretKey;
    private final Object writeLock = new Object();

    public ConfigRepositoryImpl(List<File> confDirs, boolean configReadOnly, @Nullable Integer webPortOverride, ConfigService configService, PluginCache pluginCache) {
        this.configService = configService;
        this.adminConfigService = AdminConfigService.create(confDirs, configReadOnly, webPortOverride);
        this.pluginCache = pluginCache;
        this.configReadOnly = configReadOnly;
        this.rollupConfigs = ImmutableList.copyOf(ConfigRepository.RollupConfig.buildRollupConfigs());
        this.lazySecretKey = new LazySecretKeyImpl(confDirs);
    }

    @Override
    public AgentConfigOuterClass.AgentConfig.GeneralConfig getGeneralConfig(String agentRollupId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AgentConfigOuterClass.AgentConfig.TransactionConfig getTransactionConfig(String agentId) {
        return this.configService.getTransactionConfig().toProto();
    }

    @Override
    public AgentConfigOuterClass.AgentConfig.JvmConfig getJvmConfig(String agentRollupId) {
        return this.configService.getJvmConfig().toProto();
    }

    @Override
    public AgentConfigOuterClass.AgentConfig.UiDefaultsConfig getUiDefaultsConfig(String agentRollupId) {
        return this.configService.getUiDefaultsConfig().toProto();
    }

    @Override
    public CompletionStage<AgentConfigOuterClass.AgentConfig.AdvancedConfig> getAdvancedConfig(String agentRollupId) {
        return CompletableFuture.completedFuture(this.configService.getAdvancedConfig().toProto());
    }

    @Override
    public List<AgentConfigOuterClass.AgentConfig.GaugeConfig> getGaugeConfigs(String agentId) {
        ArrayList gaugeConfigs = Lists.newArrayList();
        for (GaugeConfig gaugeConfig : this.configService.getGaugeConfigs()) {
            gaugeConfigs.add(gaugeConfig.toProto());
        }
        return gaugeConfigs;
    }

    @Override
    public AgentConfigOuterClass.AgentConfig.GaugeConfig getGaugeConfig(String agentId, String version) {
        for (GaugeConfig gaugeConfig : this.configService.getGaugeConfigs()) {
            AgentConfigOuterClass.AgentConfig.GaugeConfig config = gaugeConfig.toProto();
            if (!Versions.getVersion((AbstractMessage)config).equals(version)) continue;
            return config;
        }
        return null;
    }

    @Override
    public CompletionStage<List<AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig>> getSyntheticMonitorConfigs(String agentRollupId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletionStage<AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig> getSyntheticMonitorConfig(String agentRollupId, String syntheticMonitorId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletionStage<List<AgentConfigOuterClass.AgentConfig.AlertConfig>> getAlertConfigs(String agentRollupId) {
        ArrayList configs = Lists.newArrayList();
        for (AlertConfig config : this.configService.getAlertConfigs()) {
            configs.add(config.toProto());
        }
        return CompletableFuture.completedFuture(configs);
    }

    @Override
    public CompletionStage<List<AgentConfigOuterClass.AgentConfig.AlertConfig>> getAlertConfigsNonBlocking(String agentRollupId) {
        return this.getAlertConfigs(agentRollupId);
    }

    @Override
    public CompletionStage<AgentConfigOuterClass.AgentConfig.AlertConfig> getAlertConfig(String agentRollupId, String alertVersion) {
        for (AlertConfig alertConfig : this.configService.getAlertConfigs()) {
            AgentConfigOuterClass.AgentConfig.AlertConfig config = alertConfig.toProto();
            if (!Versions.getVersion((AbstractMessage)config).equals(alertVersion)) continue;
            return CompletableFuture.completedFuture(config);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public List<AgentConfigOuterClass.AgentConfig.PluginConfig> getPluginConfigs(String agentId) {
        ArrayList configs = Lists.newArrayList();
        for (PluginConfig config : this.configService.getPluginConfigs()) {
            configs.add(config.toProto());
        }
        return configs;
    }

    @Override
    public AgentConfigOuterClass.AgentConfig.PluginConfig getPluginConfig(String agentId, String pluginId) {
        PluginConfig pluginConfig = this.configService.getPluginConfig(pluginId);
        if (pluginConfig == null) {
            return null;
        }
        return pluginConfig.toProto();
    }

    @Override
    public List<AgentConfigOuterClass.AgentConfig.InstrumentationConfig> getInstrumentationConfigs(String agentId) {
        ArrayList configs = Lists.newArrayList();
        for (InstrumentationConfig config : this.configService.getInstrumentationConfigs()) {
            configs.add(config.toProto());
        }
        return configs;
    }

    @Override
    public AgentConfigOuterClass.AgentConfig.InstrumentationConfig getInstrumentationConfig(String agentId, String version) {
        for (InstrumentationConfig config : this.configService.getInstrumentationConfigs()) {
            AgentConfigOuterClass.AgentConfig.InstrumentationConfig protoConfig = config.toProto();
            if (!Versions.getVersion((AbstractMessage)protoConfig).equals(version)) continue;
            return protoConfig;
        }
        return null;
    }

    @Override
    public AgentConfigOuterClass.AgentConfig getAllConfig(String agentId) {
        return this.configService.getAgentConfig();
    }

    @Override
    public EmbeddedAdminGeneralConfig getEmbeddedAdminGeneralConfig() {
        return this.adminConfigService.getEmbeddedAdminGeneralConfig();
    }

    @Override
    public CompletionStage<CentralAdminGeneralConfig> getCentralAdminGeneralConfig() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletionStage<List<UserConfig>> getUserConfigs() {
        return CompletableFuture.completedFuture(this.adminConfigService.getUserConfigs());
    }

    @Override
    public CompletionStage<UserConfig> getUserConfig(String username) {
        for (UserConfig config : this.getUserConfigs().toCompletableFuture().join()) {
            if (!config.username().equals(username)) continue;
            return CompletableFuture.completedFuture(config);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletionStage<UserConfig> getUserConfigCaseInsensitive(String username) {
        for (UserConfig config : this.getUserConfigs().toCompletableFuture().join()) {
            if (!config.username().equalsIgnoreCase(username)) continue;
            return CompletableFuture.completedFuture(config);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletionStage<Boolean> namedUsersExist() {
        for (UserConfig config : this.getUserConfigs().toCompletableFuture().join()) {
            if (config.username().equalsIgnoreCase("anonymous")) continue;
            return CompletableFuture.completedFuture(true);
        }
        return CompletableFuture.completedFuture(false);
    }

    @Override
    public CompletionStage<List<RoleConfig>> getRoleConfigs() {
        return CompletableFuture.completedFuture(this.adminConfigService.getRoleConfigs());
    }

    @Override
    public CompletionStage<RoleConfig> getRoleConfig(String name) {
        for (RoleConfig config : this.getRoleConfigs().toCompletableFuture().join()) {
            if (!config.name().equals(name)) continue;
            return CompletableFuture.completedFuture(config);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletionStage<WebConfig> getWebConfig() {
        return CompletableFuture.completedFuture(this.getEmbeddedWebConfig());
    }

    @Override
    public EmbeddedWebConfig getEmbeddedWebConfig() {
        return this.adminConfigService.getEmbeddedWebConfig();
    }

    @Override
    public CompletionStage<CentralWebConfig> getCentralWebConfig() {
        throw new UnsupportedOperationException();
    }

    @Override
    public StorageConfig getStorageConfig() {
        return this.getEmbeddedStorageConfig();
    }

    @Override
    public EmbeddedStorageConfig getEmbeddedStorageConfig() {
        return this.adminConfigService.getEmbeddedStorageConfig();
    }

    @Override
    public CompletionStage<CentralStorageConfig> getCentralStorageConfig() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletionStage<SmtpConfig> getSmtpConfig() {
        return CompletableFuture.completedFuture(this.adminConfigService.getSmtpConfig());
    }

    @Override
    public CompletionStage<HttpProxyConfig> getHttpProxyConfig() {
        return CompletableFuture.completedFuture(this.adminConfigService.getHttpProxyConfig());
    }

    @Override
    public CompletionStage<LdapConfig> getLdapConfig() {
        return CompletableFuture.completedFuture(this.adminConfigService.getLdapConfig());
    }

    @Override
    public CompletionStage<PagerDutyConfig> getPagerDutyConfig() {
        return CompletableFuture.completedFuture(this.adminConfigService.getPagerDutyConfig());
    }

    @Override
    public CompletionStage<SlackConfig> getSlackConfig() {
        return CompletableFuture.completedFuture(this.adminConfigService.getSlackConfig());
    }

    @Override
    public HealthchecksIoConfig getHealthchecksIoConfig() {
        return this.adminConfigService.getHealthchecksIoConfig();
    }

    @Override
    public AllEmbeddedAdminConfig getAllEmbeddedAdminConfig() {
        return this.adminConfigService.getAllAdminConfig();
    }

    @Override
    public CompletionStage<AllCentralAdminConfig> getAllCentralAdminConfig() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletionStage<Boolean> isConfigReadOnly(String agentId) {
        return CompletableFuture.completedFuture(this.configReadOnly);
    }

    @Override
    public CompletionStage<?> updateGeneralConfig(String agentId, AgentConfigOuterClass.AgentConfig.GeneralConfig protoConfig, String priorVersion, CassandraProfile profile) throws Exception {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> updateTransactionConfig(String agentId, AgentConfigOuterClass.AgentConfig.TransactionConfig protoConfig, String priorVersion, CassandraProfile profile) throws Exception {
        ImmutableTransactionConfig config = TransactionConfig.create((AgentConfigOuterClass.AgentConfig.TransactionConfig)protoConfig);
        Object object = this.writeLock;
        synchronized (object) {
            String currVersion = Versions.getVersion((AbstractMessage)this.configService.getTransactionConfig().toProto());
            ConfigRepositoryImpl.checkVersionsEqual(currVersion, priorVersion);
            this.configService.updateTransactionConfig((TransactionConfig)config);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> insertGaugeConfig(String agentId, AgentConfigOuterClass.AgentConfig.GaugeConfig protoConfig, CassandraProfile profile) throws Exception {
        ImmutableGaugeConfig config = GaugeConfig.create((AgentConfigOuterClass.AgentConfig.GaugeConfig)protoConfig);
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList configs = Lists.newArrayList((Iterable)this.configService.getGaugeConfigs());
            for (GaugeConfig loopConfig : configs) {
                if (!loopConfig.mbeanObjectName().equals(protoConfig.getMbeanObjectName())) continue;
                throw new ConfigRepository.DuplicateMBeanObjectNameException();
            }
            configs.add(config);
            this.configService.updateGaugeConfigs((List)configs);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> updateGaugeConfig(String agentId, AgentConfigOuterClass.AgentConfig.GaugeConfig protoConfig, String priorVersion, CassandraProfile profile) throws Exception {
        ImmutableGaugeConfig config = GaugeConfig.create((AgentConfigOuterClass.AgentConfig.GaugeConfig)protoConfig);
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList configs = Lists.newArrayList((Iterable)this.configService.getGaugeConfigs());
            boolean found = false;
            ListIterator<ImmutableGaugeConfig> i = configs.listIterator();
            while (i.hasNext()) {
                GaugeConfig loopConfig = (GaugeConfig)i.next();
                String loopVersion = Versions.getVersion((AbstractMessage)loopConfig.toProto());
                if (loopVersion.equals(priorVersion)) {
                    i.set(config);
                    found = true;
                    continue;
                }
                if (!loopConfig.mbeanObjectName().equals(protoConfig.getMbeanObjectName())) continue;
                throw new ConfigRepository.DuplicateMBeanObjectNameException();
            }
            if (!found) {
                throw new ConfigRepository.OptimisticLockException();
            }
            this.configService.updateGaugeConfigs((List)configs);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> deleteGaugeConfig(String agentId, String version, CassandraProfile profile) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList configs = Lists.newArrayList((Iterable)this.configService.getGaugeConfigs());
            boolean found = false;
            ListIterator i = configs.listIterator();
            while (i.hasNext()) {
                GaugeConfig loopConfig = (GaugeConfig)i.next();
                String loopVersion = Versions.getVersion((AbstractMessage)loopConfig.toProto());
                if (!loopVersion.equals(version)) continue;
                i.remove();
                found = true;
                break;
            }
            if (!found) {
                throw new ConfigRepository.OptimisticLockException();
            }
            this.configService.updateGaugeConfigs((List)configs);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> updateJvmConfig(String agentId, AgentConfigOuterClass.AgentConfig.JvmConfig protoConfig, String priorVersion, CassandraProfile profile) throws Exception {
        ImmutableJvmConfig config = JvmConfig.create((AgentConfigOuterClass.AgentConfig.JvmConfig)protoConfig);
        Object object = this.writeLock;
        synchronized (object) {
            String currVersion = Versions.getVersion((AbstractMessage)this.configService.getJvmConfig().toProto());
            ConfigRepositoryImpl.checkVersionsEqual(currVersion, priorVersion);
            this.configService.updateJvmConfig((JvmConfig)config);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletionStage<?> insertSyntheticMonitorConfig(String agentRollupId, AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig config, CassandraProfile profile) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletionStage<?> updateSyntheticMonitorConfig(String agentRollupId, AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig config, String priorVersion, CassandraProfile profile) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletionStage<?> deleteSyntheticMonitorConfig(String agentRollupId, String syntheticMonitorId, CassandraProfile profile) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> insertAlertConfig(String agentRollupId, AgentConfigOuterClass.AgentConfig.AlertConfig protoConfig, CassandraProfile profile) throws Exception {
        String version = Versions.getVersion((AbstractMessage)protoConfig);
        ImmutableAlertConfig config = AlertConfig.create((AgentConfigOuterClass.AgentConfig.AlertConfig)protoConfig);
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList configs = Lists.newArrayList((Iterable)this.configService.getAlertConfigs());
            for (AlertConfig loopConfig : configs) {
                if (!Versions.getVersion((AbstractMessage)loopConfig.toProto()).equals(version)) continue;
                throw new IllegalStateException("This exact alert already exists");
            }
            configs.add(config);
            this.configService.updateAlertConfigs((List)configs);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> updateAlertConfig(String agentRollupId, AgentConfigOuterClass.AgentConfig.AlertConfig config, String priorVersion, CassandraProfile profile) {
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList configs = Lists.newArrayList((Iterable)this.configService.getAlertConfigs());
            boolean found = false;
            ListIterator<ImmutableAlertConfig> i = configs.listIterator();
            while (i.hasNext()) {
                AlertConfig loopConfig = (AlertConfig)i.next();
                String loopVersion = Versions.getVersion((AbstractMessage)loopConfig.toProto());
                if (!loopVersion.equals(priorVersion)) continue;
                i.set(AlertConfig.create((AgentConfigOuterClass.AgentConfig.AlertConfig)config));
                found = true;
                break;
            }
            if (!found) {
                throw new ConfigRepository.OptimisticLockException();
            }
            try {
                this.configService.updateAlertConfigs((List)configs);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> deleteAlertConfig(String agentRollupId, String version, CassandraProfile profile) {
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList configs = Lists.newArrayList((Iterable)this.configService.getAlertConfigs());
            boolean found = false;
            ListIterator i = configs.listIterator();
            while (i.hasNext()) {
                AlertConfig loopConfig = (AlertConfig)i.next();
                String loopVersion = Versions.getVersion((AbstractMessage)loopConfig.toProto());
                if (!version.equals(loopVersion)) continue;
                i.remove();
                found = true;
                break;
            }
            if (!found) {
                throw new ConfigRepository.OptimisticLockException();
            }
            try {
                this.configService.updateAlertConfigs((List)configs);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> updateUiDefaultsConfig(String agentId, AgentConfigOuterClass.AgentConfig.UiDefaultsConfig protoConfig, String priorVersion, CassandraProfile profile) throws Exception {
        ImmutableUiDefaultsConfig config = UiDefaultsConfig.create((AgentConfigOuterClass.AgentConfig.UiDefaultsConfig)protoConfig);
        Object object = this.writeLock;
        synchronized (object) {
            String currVersion = Versions.getVersion((AbstractMessage)this.configService.getUiDefaultsConfig().toProto());
            ConfigRepositoryImpl.checkVersionsEqual(currVersion, priorVersion);
            this.configService.updateUiDefaultsConfig((UiDefaultsConfig)config);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> updatePluginConfig(String agentId, AgentConfigOuterClass.AgentConfig.PluginConfig protoConfig, String priorVersion, CassandraProfile profile) throws Exception {
        PluginDescriptor pluginDescriptor = this.getPluginDescriptor(protoConfig.getId());
        PluginConfig config = PluginConfig.create((PluginDescriptor)pluginDescriptor, (List)protoConfig.getPropertyList());
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList configs = Lists.newArrayList((Iterable)this.configService.getPluginConfigs());
            boolean found = false;
            ListIterator<PluginConfig> i = configs.listIterator();
            while (i.hasNext()) {
                PluginConfig loopPluginConfig = (PluginConfig)i.next();
                if (!protoConfig.getId().equals(loopPluginConfig.id())) continue;
                String loopVersion = Versions.getVersion((AbstractMessage)loopPluginConfig.toProto());
                ConfigRepositoryImpl.checkVersionsEqual(loopVersion, priorVersion);
                i.set(config);
                found = true;
                break;
            }
            Preconditions.checkState((boolean)found, (String)"Plugin config not found: %s", (Object)protoConfig.getId());
            this.configService.updatePluginConfigs((List)configs);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> insertInstrumentationConfig(String agentId, AgentConfigOuterClass.AgentConfig.InstrumentationConfig protoConfig, CassandraProfile profile) throws Exception {
        ImmutableInstrumentationConfig config = InstrumentationConfig.create((AgentConfigOuterClass.AgentConfig.InstrumentationConfig)protoConfig);
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList configs = Lists.newArrayList((Iterable)this.configService.getInstrumentationConfigs());
            if (configs.contains(config)) {
                throw new IllegalStateException("This exact instrumentation already exists");
            }
            configs.add(config);
            this.configService.updateInstrumentationConfigs((List)configs);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> updateInstrumentationConfig(String agentId, AgentConfigOuterClass.AgentConfig.InstrumentationConfig protoConfig, String priorVersion, CassandraProfile profile) throws Exception {
        ImmutableInstrumentationConfig config = InstrumentationConfig.create((AgentConfigOuterClass.AgentConfig.InstrumentationConfig)protoConfig);
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList configs = Lists.newArrayList((Iterable)this.configService.getInstrumentationConfigs());
            boolean found = false;
            ListIterator<ImmutableInstrumentationConfig> i = configs.listIterator();
            while (i.hasNext()) {
                InstrumentationConfig loopConfig = (InstrumentationConfig)i.next();
                String loopVersion = Versions.getVersion((AbstractMessage)loopConfig.toProto());
                if (loopVersion.equals(priorVersion)) {
                    i.set(config);
                    found = true;
                    continue;
                }
                if (!loopConfig.equals(config)) continue;
                throw new IllegalStateException("This exact instrumentation already exists");
            }
            if (!found) {
                throw new ConfigRepository.OptimisticLockException();
            }
            this.configService.updateInstrumentationConfigs((List)configs);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> deleteInstrumentationConfigs(String agentId, List<String> versions, CassandraProfile profile) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList configs = Lists.newArrayList((Iterable)this.configService.getInstrumentationConfigs());
            ArrayList remainingVersions = Lists.newArrayList(versions);
            ListIterator i = configs.listIterator();
            while (i.hasNext()) {
                InstrumentationConfig loopConfig = (InstrumentationConfig)i.next();
                String loopVersion = Versions.getVersion((AbstractMessage)loopConfig.toProto());
                if (!remainingVersions.contains(loopVersion)) continue;
                i.remove();
                remainingVersions.remove(loopVersion);
            }
            if (!remainingVersions.isEmpty()) {
                throw new ConfigRepository.OptimisticLockException();
            }
            this.configService.updateInstrumentationConfigs((List)configs);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> insertInstrumentationConfigs(String agentId, List<AgentConfigOuterClass.AgentConfig.InstrumentationConfig> protoConfigs, CassandraProfile profile) throws Exception {
        ArrayList configs = Lists.newArrayList();
        for (AgentConfigOuterClass.AgentConfig.InstrumentationConfig instrumentationConfig : protoConfigs) {
            ImmutableInstrumentationConfig config = InstrumentationConfig.create((AgentConfigOuterClass.AgentConfig.InstrumentationConfig)instrumentationConfig);
            configs.add(config);
        }
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList existingConfigs = Lists.newArrayList((Iterable)this.configService.getInstrumentationConfigs());
            for (InstrumentationConfig config : configs) {
                if (existingConfigs.contains(config)) continue;
                existingConfigs.add(config);
            }
            this.configService.updateInstrumentationConfigs((List)existingConfigs);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> updateAdvancedConfig(String agentId, AgentConfigOuterClass.AgentConfig.AdvancedConfig protoConfig, String priorVersion, CassandraProfile profile) throws Exception {
        ImmutableAdvancedConfig config = AdvancedConfig.create((AgentConfigOuterClass.AgentConfig.AdvancedConfig)protoConfig);
        Object object = this.writeLock;
        synchronized (object) {
            String currVersion = Versions.getVersion((AbstractMessage)this.configService.getAdvancedConfig().toProto());
            ConfigRepositoryImpl.checkVersionsEqual(currVersion, priorVersion);
            this.configService.updateAdvancedConfig((AdvancedConfig)config);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> updateAllConfig(String agentId, AgentConfigOuterClass.AgentConfig config, @Nullable String priorVersion, CassandraProfile profile) throws Exception {
        ConfigValidation.validatePartOne(config);
        HashSet validPluginIds = Sets.newHashSet();
        for (PluginDescriptor pluginDescriptor : this.pluginCache.pluginDescriptors()) {
            validPluginIds.add(pluginDescriptor.id());
        }
        ConfigValidation.validatePartTwo(config, validPluginIds);
        Object object = this.writeLock;
        synchronized (object) {
            AgentConfigOuterClass.AgentConfig existingAgentConfig = this.configService.getAgentConfig();
            if (priorVersion != null && !priorVersion.equals(Versions.getVersion((AbstractMessage)existingAgentConfig))) {
                throw new ConfigRepository.OptimisticLockException();
            }
            this.configService.updateAllConfig(AllConfig.create((AgentConfigOuterClass.AgentConfig)config, (List)this.pluginCache.pluginDescriptors()));
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> updateEmbeddedAdminGeneralConfig(EmbeddedAdminGeneralConfig config, String priorVersion, CassandraProfile profile) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            String currVersion = this.adminConfigService.getEmbeddedAdminGeneralConfig().version();
            ConfigRepositoryImpl.checkVersionsEqual(currVersion, priorVersion);
            this.adminConfigService.updateEmbeddedAdminGeneralConfig(config);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletionStage<?> updateCentralAdminGeneralConfig(CentralAdminGeneralConfig config, String priorVersion, CassandraProfile profile) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> insertUserConfig(UserConfig config, CassandraProfile profile) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList configs = Lists.newArrayList(this.adminConfigService.getUserConfigs());
            String username = config.username();
            for (UserConfig loopConfig : configs) {
                if (!loopConfig.username().equalsIgnoreCase(username)) continue;
                throw new ConfigRepository.DuplicateUsernameException();
            }
            configs.add(ImmutableUserConfig.copyOf(config));
            this.adminConfigService.updateUserConfigs(configs);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> updateUserConfig(UserConfig config, String priorVersion, CassandraProfile profile) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList configs = Lists.newArrayList(this.adminConfigService.getUserConfigs());
            String username = config.username();
            boolean found = false;
            ListIterator<ImmutableUserConfig> i = configs.listIterator();
            while (i.hasNext()) {
                UserConfig loopConfig = (UserConfig)i.next();
                if (!loopConfig.username().equals(username)) continue;
                if (loopConfig.version().equals(priorVersion)) {
                    i.set(ImmutableUserConfig.copyOf(config));
                    found = true;
                    break;
                }
                throw new ConfigRepository.OptimisticLockException();
            }
            if (!found) {
                throw new ConfigRepository.UserNotFoundException();
            }
            this.adminConfigService.updateUserConfigs(configs);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> deleteUserConfig(String username, CassandraProfile profile) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList configs = Lists.newArrayList(this.adminConfigService.getUserConfigs());
            boolean found = false;
            ListIterator i = configs.listIterator();
            while (i.hasNext()) {
                UserConfig loopConfig = (UserConfig)i.next();
                if (!loopConfig.username().equals(username)) continue;
                i.remove();
                found = true;
                break;
            }
            if (!found) {
                throw new ConfigRepository.UserNotFoundException();
            }
            if (this.getLdapConfig().toCompletableFuture().join().host().isEmpty() && configs.isEmpty()) {
                throw new ConfigRepository.CannotDeleteLastUserException();
            }
            this.adminConfigService.updateUserConfigs(configs);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> insertRoleConfig(RoleConfig config, CassandraProfile profile) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList configs = Lists.newArrayList(this.adminConfigService.getRoleConfigs());
            String name = config.name();
            for (RoleConfig loopConfig : configs) {
                if (!loopConfig.name().equalsIgnoreCase(name)) continue;
                throw new ConfigRepository.DuplicateRoleNameException();
            }
            configs.add(ImmutableRoleConfig.copyOf(config));
            this.adminConfigService.updateRoleConfigs(configs);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> updateRoleConfig(RoleConfig config, String priorVersion, CassandraProfile profile) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList configs = Lists.newArrayList(this.adminConfigService.getRoleConfigs());
            String name = config.name();
            boolean found = false;
            ListIterator<ImmutableRoleConfig> i = configs.listIterator();
            while (i.hasNext()) {
                RoleConfig loopConfig = (RoleConfig)i.next();
                if (!loopConfig.name().equals(name)) continue;
                if (loopConfig.version().equals(priorVersion)) {
                    i.set(ImmutableRoleConfig.copyOf(config));
                    found = true;
                    break;
                }
                throw new ConfigRepository.OptimisticLockException();
            }
            if (!found) {
                throw new ConfigRepository.RoleNotFoundException();
            }
            this.adminConfigService.updateRoleConfigs(configs);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> deleteRoleConfig(String name, CassandraProfile profile) {
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList configs = Lists.newArrayList(this.adminConfigService.getRoleConfigs());
            boolean found = false;
            ListIterator i = configs.listIterator();
            while (i.hasNext()) {
                RoleConfig loopConfig = (RoleConfig)i.next();
                if (!loopConfig.name().equals(name)) continue;
                i.remove();
                found = true;
                break;
            }
            if (!found) {
                throw new ConfigRepository.RoleNotFoundException();
            }
            if (configs.isEmpty()) {
                throw new ConfigRepository.CannotDeleteLastRoleException();
            }
            this.adminConfigService.updateRoleConfigs(configs);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateEmbeddedWebConfig(EmbeddedWebConfig config, String priorVersion) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            String currVersion = this.adminConfigService.getEmbeddedWebConfig().version();
            ConfigRepositoryImpl.checkVersionsEqual(currVersion, priorVersion);
            this.adminConfigService.updateEmbeddedWebConfig(config);
        }
    }

    @Override
    public CompletionStage<?> updateCentralWebConfig(CentralWebConfig config, String priorVersion) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateEmbeddedStorageConfig(EmbeddedStorageConfig config, String priorVersion) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            String currVersion = this.adminConfigService.getEmbeddedStorageConfig().version();
            ConfigRepositoryImpl.checkVersionsEqual(currVersion, priorVersion);
            this.adminConfigService.updateEmbeddedStorageConfig(config);
        }
    }

    @Override
    public CompletionStage<?> updateCentralStorageConfig(CentralStorageConfig config, String priorVersion) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> updateSmtpConfig(SmtpConfig config, String priorVersion) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            String currVersion = this.adminConfigService.getSmtpConfig().version();
            ConfigRepositoryImpl.checkVersionsEqual(currVersion, priorVersion);
            this.adminConfigService.updateSmtpConfig(config);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> updateHttpProxyConfig(HttpProxyConfig config, String priorVersion) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            String currVersion = this.adminConfigService.getHttpProxyConfig().version();
            ConfigRepositoryImpl.checkVersionsEqual(currVersion, priorVersion);
            this.adminConfigService.updateHttpProxyConfig(config);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> updateLdapConfig(LdapConfig config, String priorVersion) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            String currVersion = this.adminConfigService.getLdapConfig().version();
            ConfigRepositoryImpl.checkVersionsEqual(currVersion, priorVersion);
            this.adminConfigService.updateLdapConfig(config);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> updatePagerDutyConfig(PagerDutyConfig config, String priorVersion) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            String currVersion = this.adminConfigService.getPagerDutyConfig().version();
            ConfigRepositoryImpl.checkVersionsEqual(currVersion, priorVersion);
            ConfigRepositoryImpl.validatePagerDutyConfig(config);
            this.adminConfigService.updatePagerDutyConfig(config);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> updateSlackConfig(SlackConfig config, String priorVersion) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            String currVersion = this.adminConfigService.getSlackConfig().version();
            ConfigRepositoryImpl.checkVersionsEqual(currVersion, priorVersion);
            ConfigRepositoryImpl.validateSlackConfig(config);
            this.adminConfigService.updateSlackConfig(config);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateHealthchecksIoConfig(HealthchecksIoConfig config, String priorVersion) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            String currVersion = this.adminConfigService.getHealthchecksIoConfig().version();
            ConfigRepositoryImpl.checkVersionsEqual(currVersion, priorVersion);
            this.adminConfigService.updateHealthchecksIoConfig(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAllEmbeddedAdminConfig(AllEmbeddedAdminConfig config, @Nullable String priorVersion) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            AllEmbeddedAdminConfig existingConfig = this.adminConfigService.getAllAdminConfig();
            String currVersion = existingConfig.version();
            if (priorVersion != null) {
                ConfigRepositoryImpl.checkVersionsEqual(currVersion, priorVersion);
            }
            HashSet usernames = Sets.newHashSet();
            for (UserConfig userConfig : config.users()) {
                if (usernames.add(userConfig.username())) continue;
                throw new ConfigRepository.DuplicateUsernameException();
            }
            HashSet roleNames = Sets.newHashSet();
            for (RoleConfig roleConfig : config.roles()) {
                if (roleNames.add(roleConfig.name())) continue;
                throw new ConfigRepository.DuplicateRoleNameException();
            }
            if (config.ldap().host().isEmpty() && config.users().isEmpty()) {
                throw new ConfigRepository.CannotDeleteLastUserException();
            }
            if (config.roles().isEmpty()) {
                throw new ConfigRepository.CannotDeleteLastRoleException();
            }
            ConfigRepositoryImpl.validatePagerDutyConfig(config.pagerDuty());
            ConfigRepositoryImpl.validateSlackConfig(config.slack());
            HashMap hashMap = Maps.newHashMap();
            for (UserConfig userConfig : existingConfig.users()) {
                String passwordHash = userConfig.passwordHash();
                if (passwordHash.isEmpty()) continue;
                hashMap.put(userConfig.username(), passwordHash);
            }
            ArrayList arrayList = Lists.newArrayList();
            for (UserConfig userConfig : config.users()) {
                String passwordHash = userConfig.passwordHash();
                if (passwordHash.isEmpty() && !userConfig.ldap() && !userConfig.username().equalsIgnoreCase("anonymous")) {
                    String existingUserPasswordHash = (String)hashMap.get(userConfig.username());
                    if (existingUserPasswordHash == null) {
                        throw new IllegalStateException("No existing password for user: " + userConfig.username());
                    }
                    userConfig = ImmutableUserConfig.copyOf(userConfig).withPasswordHash(existingUserPasswordHash);
                }
                arrayList.add(userConfig);
            }
            config = ImmutableAllEmbeddedAdminConfig.copyOf(config).withUsers(arrayList);
            this.adminConfigService.updateAllAdminConfig(config);
        }
    }

    @Override
    public void updateAllCentralAdminConfig(AllCentralAdminConfig config, @Nullable String priorVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getGaugeCollectionIntervalMillis() {
        return this.configService.getGaugeCollectionIntervalMillis();
    }

    public ImmutableList<ConfigRepository.RollupConfig> getRollupConfigs() {
        return this.rollupConfigs;
    }

    @Override
    public LazySecretKey getLazySecretKey() {
        return this.lazySecretKey;
    }

    private PluginDescriptor getPluginDescriptor(String pluginId) {
        for (PluginDescriptor pluginDescriptor : this.pluginCache.pluginDescriptors()) {
            if (!pluginDescriptor.id().equals(pluginId)) continue;
            return pluginDescriptor;
        }
        throw new IllegalStateException("Could not find plugin descriptor: " + pluginId);
    }

    @OnlyUsedByTests
    public void resetAdminConfigForTests() throws IOException {
        this.adminConfigService.resetAdminConfigForTests();
    }

    private static void checkVersionsEqual(String version, String priorVersion) throws ConfigRepository.OptimisticLockException {
        if (!version.equals(priorVersion)) {
            throw new ConfigRepository.OptimisticLockException();
        }
    }

    private static void validatePagerDutyConfig(PagerDutyConfig config) throws Exception {
        HashSet integrationKeys = Sets.newHashSet();
        HashSet integrationDisplays = Sets.newHashSet();
        for (PagerDutyConfig.PagerDutyIntegrationKey pagerDutyIntegrationKey : config.integrationKeys()) {
            if (!integrationKeys.add(pagerDutyIntegrationKey.key())) {
                throw new ConfigRepository.DuplicatePagerDutyIntegrationKeyException();
            }
            if (integrationDisplays.add(pagerDutyIntegrationKey.display())) continue;
            throw new ConfigRepository.DuplicatePagerDutyIntegrationKeyDisplayException();
        }
    }

    private static void validateSlackConfig(SlackConfig config) throws Exception {
        HashSet webhookUrls = Sets.newHashSet();
        HashSet webhookDisplays = Sets.newHashSet();
        for (SlackConfig.SlackWebhook slackWebhook : config.webhooks()) {
            if (!webhookUrls.add(slackWebhook.url())) {
                throw new ConfigRepository.DuplicateSlackWebhookUrlException();
            }
            if (webhookDisplays.add(slackWebhook.display())) continue;
            throw new ConfigRepository.DuplicateSlackWebhookDisplayException();
        }
    }
}

