/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.config.AdminConfigFile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.AllEmbeddedAdminConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.EmbeddedAdminGeneralConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.EmbeddedStorageConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.EmbeddedWebConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.HealthchecksIoConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.HttpProxyConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableAllEmbeddedAdminConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableEmbeddedAdminGeneralConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableEmbeddedStorageConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableEmbeddedWebConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableHealthchecksIoConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableHttpProxyConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableLdapConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutablePagerDutyConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableRoleConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableSlackConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableSmtpConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableUserConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.LdapConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.PagerDutyConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.RoleConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.SlackConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.SmtpConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.UserConfig;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.org.glowroot.common.util.OnlyUsedByTests;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

public class AdminConfigService {
    private static final Logger logger = LoggerFactory.getLogger(AdminConfigService.class);
    private final AdminConfigFile adminConfigFile;
    private volatile EmbeddedAdminGeneralConfig generalConfig;
    private volatile List<UserConfig> userConfigs;
    private volatile List<RoleConfig> roleConfigs;
    private volatile EmbeddedWebConfig webConfig;
    private volatile EmbeddedStorageConfig storageConfig;
    private volatile SmtpConfig smtpConfig;
    private volatile HttpProxyConfig httpProxyConfig;
    private volatile LdapConfig ldapConfig;
    private volatile PagerDutyConfig pagerDutyConfig;
    private volatile SlackConfig slackConfig;
    private volatile HealthchecksIoConfig healthchecksIoConfig;

    public static AdminConfigService create(List<File> confDirs, boolean configReadOnly, @Nullable Integer webPortOverride) {
        AdminConfigService configService = new AdminConfigService(confDirs, configReadOnly, webPortOverride);
        try {
            configService.writeAll();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return configService;
    }

    private AdminConfigService(List<File> confDirs, boolean configReadOnly, @Nullable Integer webPortOverride) {
        ImmutableEmbeddedStorageConfig storageConfig;
        ImmutableEmbeddedWebConfig webConfig;
        this.adminConfigFile = new AdminConfigFile(confDirs, configReadOnly);
        ImmutableEmbeddedAdminGeneralConfig generalConfig = this.adminConfigFile.getConfig("general", ImmutableEmbeddedAdminGeneralConfig.class);
        this.generalConfig = generalConfig == null ? ImmutableEmbeddedAdminGeneralConfig.builder().build() : generalConfig;
        List<ImmutableUserConfig> userConfigs = this.adminConfigFile.getConfig("users", new TypeReference<List<ImmutableUserConfig>>(){});
        this.userConfigs = userConfigs == null ? ImmutableList.of() : ImmutableList.copyOf(userConfigs);
        List<ImmutableRoleConfig> roleConfigs = this.adminConfigFile.getConfig("roles", new TypeReference<List<ImmutableRoleConfig>>(){});
        this.roleConfigs = roleConfigs == null ? ImmutableList.of() : ImmutableList.copyOf(roleConfigs);
        if (this.roleConfigs.isEmpty()) {
            this.roleConfigs = ImmutableList.of((Object)ImmutableRoleConfig.builder().name("Administrator").addPermissions("agent:transaction", "agent:error", "agent:jvm", "agent:incident", "agent:config", "admin").build());
        }
        this.webConfig = (webConfig = this.adminConfigFile.getConfig("web", ImmutableEmbeddedWebConfig.class)) == null ? ImmutableEmbeddedWebConfig.builder().build() : webConfig;
        if (webPortOverride != null) {
            this.webConfig = ImmutableEmbeddedWebConfig.builder().copyFrom(this.webConfig).port(webPortOverride).build();
        }
        this.storageConfig = (storageConfig = this.adminConfigFile.getConfig("storage", ImmutableEmbeddedStorageConfig.class)) == null ? ImmutableEmbeddedStorageConfig.builder().build() : (storageConfig.hasListIssues() ? AdminConfigService.withCorrectedLists(storageConfig) : storageConfig);
        ImmutableSmtpConfig smtpConfig = this.adminConfigFile.getConfig("smtp", ImmutableSmtpConfig.class);
        this.smtpConfig = smtpConfig == null ? ImmutableSmtpConfig.builder().build() : smtpConfig;
        ImmutableHttpProxyConfig httpProxyConfig = this.adminConfigFile.getConfig("httpProxy", ImmutableHttpProxyConfig.class);
        this.httpProxyConfig = httpProxyConfig == null ? ImmutableHttpProxyConfig.builder().build() : httpProxyConfig;
        ImmutableLdapConfig ldapConfig = this.adminConfigFile.getConfig("ldap", ImmutableLdapConfig.class);
        this.ldapConfig = ldapConfig == null ? ImmutableLdapConfig.builder().build() : ldapConfig;
        ImmutablePagerDutyConfig pagerDutyConfig = this.adminConfigFile.getConfig("pagerDuty", ImmutablePagerDutyConfig.class);
        this.pagerDutyConfig = pagerDutyConfig == null ? ImmutablePagerDutyConfig.builder().build() : pagerDutyConfig;
        ImmutableSlackConfig slackConfig = this.adminConfigFile.getConfig("slack", ImmutableSlackConfig.class);
        this.slackConfig = slackConfig == null ? ImmutableSlackConfig.builder().build() : slackConfig;
        ImmutableHealthchecksIoConfig healthchecksIoConfig = this.adminConfigFile.getConfig("healthchecksIo", ImmutableHealthchecksIoConfig.class);
        this.healthchecksIoConfig = healthchecksIoConfig == null ? ImmutableHealthchecksIoConfig.builder().build() : healthchecksIoConfig;
        if (this.userConfigs.isEmpty() && this.ldapConfig.host().isEmpty()) {
            this.userConfigs = ImmutableList.of((Object)ImmutableUserConfig.builder().username("anonymous").addRoles("Administrator").build());
        }
    }

    public EmbeddedAdminGeneralConfig getEmbeddedAdminGeneralConfig() {
        return this.generalConfig;
    }

    public List<UserConfig> getUserConfigs() {
        return this.userConfigs;
    }

    public List<RoleConfig> getRoleConfigs() {
        return this.roleConfigs;
    }

    public EmbeddedWebConfig getEmbeddedWebConfig() {
        return this.webConfig;
    }

    public EmbeddedStorageConfig getEmbeddedStorageConfig() {
        return this.storageConfig;
    }

    public SmtpConfig getSmtpConfig() {
        return this.smtpConfig;
    }

    public HttpProxyConfig getHttpProxyConfig() {
        return this.httpProxyConfig;
    }

    public LdapConfig getLdapConfig() {
        return this.ldapConfig;
    }

    public PagerDutyConfig getPagerDutyConfig() {
        return this.pagerDutyConfig;
    }

    public SlackConfig getSlackConfig() {
        return this.slackConfig;
    }

    public HealthchecksIoConfig getHealthchecksIoConfig() {
        return this.healthchecksIoConfig;
    }

    public AllEmbeddedAdminConfig getAllAdminConfig() {
        return ImmutableAllEmbeddedAdminConfig.builder().general(this.generalConfig).users(this.userConfigs).roles(this.roleConfigs).web(this.webConfig).storage(this.storageConfig).smtp(this.smtpConfig).httpProxy(this.httpProxyConfig).ldap(this.ldapConfig).pagerDuty(this.pagerDutyConfig).slack(this.slackConfig).healthchecksIo(this.healthchecksIoConfig).build();
    }

    public void updateEmbeddedAdminGeneralConfig(EmbeddedAdminGeneralConfig config) throws Exception {
        this.adminConfigFile.writeConfig("general", config);
        this.generalConfig = ImmutableEmbeddedAdminGeneralConfig.copyOf(config);
    }

    public void updateUserConfigs(List<UserConfig> configs) throws Exception {
        this.adminConfigFile.writeConfig("users", configs);
        this.userConfigs = ImmutableList.copyOf(configs);
    }

    public void updateRoleConfigs(List<RoleConfig> configs) {
        this.adminConfigFile.writeConfig("roles", configs);
        this.roleConfigs = ImmutableList.copyOf(configs);
    }

    public void updateEmbeddedWebConfig(EmbeddedWebConfig config) throws Exception {
        this.adminConfigFile.writeConfig("web", config);
        this.webConfig = ImmutableEmbeddedWebConfig.copyOf(config);
    }

    public void updateEmbeddedStorageConfig(EmbeddedStorageConfig config) throws Exception {
        this.adminConfigFile.writeConfig("storage", config);
        this.storageConfig = ImmutableEmbeddedStorageConfig.copyOf(config);
    }

    public void updateSmtpConfig(SmtpConfig config) throws Exception {
        this.adminConfigFile.writeConfig("smtp", config);
        this.smtpConfig = ImmutableSmtpConfig.copyOf(config);
    }

    public void updateHttpProxyConfig(HttpProxyConfig config) throws Exception {
        this.adminConfigFile.writeConfig("httpProxy", config);
        this.httpProxyConfig = ImmutableHttpProxyConfig.copyOf(config);
    }

    public void updateLdapConfig(LdapConfig config) throws Exception {
        this.adminConfigFile.writeConfig("ldap", config);
        this.ldapConfig = ImmutableLdapConfig.copyOf(config);
    }

    public void updatePagerDutyConfig(PagerDutyConfig config) throws Exception {
        this.adminConfigFile.writeConfig("pagerDuty", config);
        this.pagerDutyConfig = ImmutablePagerDutyConfig.copyOf(config);
    }

    public void updateSlackConfig(SlackConfig config) throws Exception {
        this.adminConfigFile.writeConfig("slack", config);
        this.slackConfig = ImmutableSlackConfig.copyOf(config);
    }

    public void updateHealthchecksIoConfig(HealthchecksIoConfig config) throws Exception {
        this.adminConfigFile.writeConfig("healthchecksIo", config);
        this.healthchecksIoConfig = ImmutableHealthchecksIoConfig.copyOf(config);
    }

    public void updateAllAdminConfig(AllEmbeddedAdminConfig config) throws IOException {
        HashMap configs = Maps.newHashMap();
        configs.put("general", config.general());
        configs.put("users", config.users());
        configs.put("roles", config.roles());
        configs.put("web", config.web());
        configs.put("storage", config.storage());
        configs.put("smtp", config.smtp());
        configs.put("httpProxy", config.httpProxy());
        configs.put("ldap", config.ldap());
        configs.put("pagerDuty", config.pagerDuty());
        configs.put("slack", config.slack());
        configs.put("healthchecksIo", config.healthchecksIo());
        this.adminConfigFile.writeConfigsOnStartup(configs);
        this.generalConfig = config.general();
        this.userConfigs = ImmutableList.copyOf(config.users());
        this.roleConfigs = ImmutableList.copyOf(config.roles());
        this.webConfig = config.web();
        this.storageConfig = config.storage();
        this.smtpConfig = config.smtp();
        this.httpProxyConfig = config.httpProxy();
        this.ldapConfig = config.ldap();
        this.pagerDutyConfig = config.pagerDuty();
        this.slackConfig = config.slack();
        this.healthchecksIoConfig = config.healthchecksIo();
    }

    private void writeAll() throws IOException {
        HashMap configs = Maps.newHashMap();
        configs.put("general", this.generalConfig);
        configs.put("users", this.userConfigs);
        configs.put("roles", this.roleConfigs);
        configs.put("web", this.webConfig);
        configs.put("storage", this.storageConfig);
        configs.put("smtp", this.smtpConfig);
        configs.put("httpProxy", this.httpProxyConfig);
        configs.put("ldap", this.ldapConfig);
        configs.put("pagerDuty", this.pagerDutyConfig);
        configs.put("slack", this.slackConfig);
        configs.put("healthchecksIo", this.healthchecksIoConfig);
        this.adminConfigFile.writeConfigsOnStartup(configs);
    }

    @OnlyUsedByTests
    public void resetAdminConfigForTests() throws IOException {
        this.generalConfig = ImmutableEmbeddedAdminGeneralConfig.builder().build();
        this.userConfigs = ImmutableList.of((Object)ImmutableUserConfig.builder().username("anonymous").addRoles("Administrator").build());
        this.roleConfigs = ImmutableList.of((Object)ImmutableRoleConfig.builder().name("Administrator").addPermissions("agent:transaction", "agent:error", "agent:jvm", "agent:config:view", "agent:config:edit", "admin").build());
        this.webConfig = ImmutableEmbeddedWebConfig.builder().port(this.webConfig.port()).build();
        this.storageConfig = ImmutableEmbeddedStorageConfig.builder().build();
        this.smtpConfig = ImmutableSmtpConfig.builder().build();
        this.httpProxyConfig = ImmutableHttpProxyConfig.builder().build();
        this.ldapConfig = ImmutableLdapConfig.builder().build();
        this.pagerDutyConfig = ImmutablePagerDutyConfig.builder().build();
        this.slackConfig = ImmutableSlackConfig.builder().build();
        this.healthchecksIoConfig = ImmutableHealthchecksIoConfig.builder().build();
        this.writeAll();
    }

    private static ImmutableEmbeddedStorageConfig withCorrectedLists(EmbeddedStorageConfig config) {
        ImmutableEmbeddedStorageConfig defaultConfig = ImmutableEmbeddedStorageConfig.builder().build();
        ImmutableList<Integer> rollupExpirationHours = AdminConfigService.fix(config.rollupExpirationHours(), ((EmbeddedStorageConfig)defaultConfig).rollupExpirationHours());
        ImmutableList<Integer> rollupCappedDatabaseSizesMb = AdminConfigService.fix(config.rollupCappedDatabaseSizesMb(), ((EmbeddedStorageConfig)defaultConfig).rollupCappedDatabaseSizesMb());
        return ImmutableEmbeddedStorageConfig.builder().copyFrom(config).rollupExpirationHours((Iterable<Integer>)rollupExpirationHours).rollupCappedDatabaseSizesMb((Iterable<Integer>)rollupCappedDatabaseSizesMb).build();
    }

    private static ImmutableList<Integer> fix(ImmutableList<Integer> thisList, List<Integer> defaultList) {
        if (thisList.size() >= defaultList.size()) {
            return thisList.subList(0, defaultList.size());
        }
        ArrayList correctedList = Lists.newArrayList(thisList);
        for (int i = thisList.size(); i < defaultList.size(); ++i) {
            correctedList.add(defaultList.get(i));
        }
        return ImmutableList.copyOf((Collection)correctedList);
    }
}

