/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.net.logstash.logback.argument;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.net.logstash.logback.argument.StructuredArgument;
import org.glowroot.agent.shaded.net.logstash.logback.marker.EmptyLogstashMarker;

public class DeferredStructuredArgument
implements StructuredArgument {
    private final Supplier<? extends StructuredArgument> structureArgumentSupplier;
    private volatile StructuredArgument suppliedValue;

    public DeferredStructuredArgument(Supplier<? extends StructuredArgument> structureArgumentSupplier) {
        this.structureArgumentSupplier = Objects.requireNonNull(structureArgumentSupplier, "structureArgumentSupplier must not be null");
    }

    @Override
    public void writeTo(JsonGenerator generator) throws IOException {
        this.getSuppliedValue().writeTo(generator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StructuredArgument getSuppliedValue() {
        if (this.suppliedValue == null) {
            DeferredStructuredArgument deferredStructuredArgument = this;
            synchronized (deferredStructuredArgument) {
                if (this.suppliedValue == null) {
                    StructuredArgument structuredArgument = this.structureArgumentSupplier.get();
                    if (structuredArgument == null) {
                        structuredArgument = new EmptyLogstashMarker();
                    }
                    this.suppliedValue = structuredArgument;
                }
            }
        }
        return this.suppliedValue;
    }
}

