/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.net.logstash.logback.appender.destination;

import org.glowroot.agent.shaded.ch.qos.logback.core.util.Duration;
import org.glowroot.agent.shaded.net.logstash.logback.appender.destination.DestinationConnectionStrategy;

public class PreferPrimaryDestinationConnectionStrategy
implements DestinationConnectionStrategy {
    private static final int PRIMARY_DESTINATION_INDEX = 0;
    private Duration secondaryConnectionTTL;
    private Duration minConnectionTimeBeforePrimary = Duration.buildBySeconds((double)10.0);
    private volatile int nextDestinationIndex = 0;
    private volatile long secondaryConnectionExpirationTime = Long.MAX_VALUE;
    private volatile long lastSuccessfulConnectTime;

    @Override
    public int selectNextDestinationIndex(int previousDestinationIndex, int numDestinations) {
        int candidateIndex = this.nextDestinationIndex;
        if (candidateIndex == 0 && this.minConnectionTimeBeforePrimary != null && System.currentTimeMillis() - this.lastSuccessfulConnectTime < this.minConnectionTimeBeforePrimary.getMilliseconds()) {
            return (previousDestinationIndex + 1) % numDestinations;
        }
        return this.nextDestinationIndex;
    }

    @Override
    public void connectSuccess(long connectionStartTimeInMillis, int connectedDestinationIndex, int numDestinations) {
        this.secondaryConnectionExpirationTime = this.secondaryConnectionTTL != null && connectedDestinationIndex != 0 ? connectionStartTimeInMillis + this.secondaryConnectionTTL.getMilliseconds() : Long.MAX_VALUE;
        this.lastSuccessfulConnectTime = connectionStartTimeInMillis;
        this.nextDestinationIndex = 0;
    }

    @Override
    public void connectFailed(long connectionStartTimeInMillis, int failedDestinationIndex, int numDestinations) {
        this.nextDestinationIndex = (failedDestinationIndex + 1) % numDestinations;
    }

    @Override
    public boolean shouldReconnect(long currentTimeInMillis, int currentDestinationIndex, int numDestinations) {
        return this.secondaryConnectionExpirationTime <= currentTimeInMillis;
    }

    public Duration getSecondaryConnectionTTL() {
        return this.secondaryConnectionTTL;
    }

    public void setSecondaryConnectionTTL(Duration secondaryConnectionTTL) {
        if (secondaryConnectionTTL != null && secondaryConnectionTTL.getMilliseconds() <= 0L) {
            throw new IllegalArgumentException("secondaryConnectionTTL must be > 0");
        }
        this.secondaryConnectionTTL = secondaryConnectionTTL;
    }

    public Duration getMinConnectionTimeBeforePrimary() {
        return this.minConnectionTimeBeforePrimary;
    }

    public void setMinConnectionTimeBeforePrimary(Duration minConnectionTimeBeforePrimary) {
        this.minConnectionTimeBeforePrimary = minConnectionTimeBeforePrimary;
    }
}

