/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.net.logstash.logback;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.glowroot.agent.shaded.ch.qos.logback.core.encoder.Encoder;

public class Logback11Support {
    public static final Logback11Support INSTANCE = new Logback11Support();
    private static final Method ENCODER_INIT_METHOD = Logback11Support.getMethod(Encoder.class, "init", OutputStream.class);
    private static final Method ENCODER_DO_ENCODE_METHOD = Logback11Support.getMethod(Encoder.class, "doEncode", Object.class);
    private static final Method ENCODER_CLOSE_METHOD = Logback11Support.getMethod(Encoder.class, "close", new Class[0]);
    private static final boolean IS_LOGBACK_1_1 = ENCODER_INIT_METHOD != null;

    public boolean isLogback11OrBefore() {
        return IS_LOGBACK_1_1;
    }

    public void verifyLogback11OrBefore() {
        if (!this.isLogback11OrBefore()) {
            throw new IllegalStateException("Logback 1.1 only method called, but Logback version is >= 1.2");
        }
    }

    public void verifyLogback12OrAfter() {
        if (this.isLogback11OrBefore()) {
            throw new IllegalStateException("Logback 1.2+ method called, but Logback version is < 1.2");
        }
    }

    public void init(Encoder<?> encoder, OutputStream outputStream) throws IOException {
        this.verifyLogback11OrBefore();
        try {
            ENCODER_INIT_METHOD.invoke(encoder, outputStream);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Unable to initialize logback 1.1 encoder " + encoder, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to initialize logback 1.1 encoder " + encoder, e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new IllegalStateException("Unable to initialize logback 1.1 encoder " + encoder, e.getCause());
        }
    }

    public void doEncode(Encoder<?> encoder, Object event) throws IOException {
        this.verifyLogback11OrBefore();
        try {
            ENCODER_DO_ENCODE_METHOD.invoke(encoder, event);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Unable to encode event with logback 1.1 encoder " + encoder, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to encode event with logback 1.1 encoder " + encoder, e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new IllegalStateException("Unable to encode event with logback 1.1 encoder " + encoder, e.getCause());
        }
    }

    public void close(Encoder<?> encoder) throws IOException {
        this.verifyLogback11OrBefore();
        try {
            ENCODER_CLOSE_METHOD.invoke(encoder, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Unable to close logback 1.1 encoder " + encoder, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to close logback 1.1 encoder " + encoder, e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new IllegalStateException("Unable to close logback 1.1 encoder " + encoder, e.getCause());
        }
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

