/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.model;

import java.util.List;
import java.util.Map;
import org.joget.ai.agent.model.AgentLLM;
import org.joget.ai.agent.model.Enhancer;
import org.joget.ai.agent.model.EnhancerProperties;
import org.joget.ai.agent.model.IRequestHandler;
import org.joget.ai.agent.model.JsonSchemaBuilder;
import org.joget.ai.agent.model.LLMConfig;
import org.json.JSONArray;
import org.json.JSONObject;

public class StoreToFormRequestHandler
implements IRequestHandler<Enhancer> {
    private final Map<AgentLLM.Type, QuadConsumer<Enhancer, LLMConfig, EnhancerProperties, JsonSchemaBuilder>> configEnhancers = Map.of(AgentLLM.Type.OPENAI, (enhancer, config, props, rootBuilder) -> {
        JSONObject responseFormat = rootBuilder.build();
        config.put("response_format", responseFormat);
    }, AgentLLM.Type.ANTHROPIC, (enhancer, config, props, rootBuilder) -> {
        JSONObject responseFormat = rootBuilder.setDescription("Generate an output for the form with ID: " + props.getFormDefId() + ". Use the provided schema to fill in all fields, even if the user does not provide complete information. Assume reasonable defaults for any missing fields. " + rootBuilder.buildPropertySchema() + "Only respond with a valid JSON. No other text.").build();
        config.put("messages", responseFormat.getJSONArray("messages"));
    }, AgentLLM.Type.GEMINI, (enhancer, config, props, rootBuilder) -> {
        JSONObject geminiSchema = rootBuilder.buildPropertySchema();
        JSONArray propertyOrdering = new JSONArray();
        for (String key : geminiSchema.getJSONObject("properties").keySet()) {
            propertyOrdering.put((Object)key);
        }
        geminiSchema.put("propertyOrdering", (Object)propertyOrdering);
        geminiSchema.remove("additionalProperties");
        JSONObject genConfig = new JSONObject().put("responseMimeType", (Object)"application/json").put("responseSchema", (Object)geminiSchema);
        config.put("generationConfig", genConfig);
    });

    @Override
    public boolean supports(String className) {
        return "org.joget.ai.agent.lib.StoreToFormAgentEnhancer".equals(className);
    }

    @Override
    public void handle(Enhancer enhancer, LLMConfig config, AgentLLM.Type llmType) {
        EnhancerProperties props = enhancer.getProperties();
        if (props == null || !"json".equalsIgnoreCase(props.getType())) {
            return;
        }
        if (props.getFormDefId() == null || props.getFormDefId().isEmpty()) {
            throw new IllegalArgumentException("Enhancer properties must contain formDefId");
        }
        JsonSchemaBuilder itemBuilder = new JsonSchemaBuilder().setRootType("object").setAdditionalProperties(false);
        List<EnhancerProperties.FieldMapping> mappings = props.getFieldMapping();
        if (mappings != null) {
            for (EnhancerProperties.FieldMapping fm : mappings) {
                itemBuilder.addProperty(fm.getField(), JsonSchemaBuilder.stringProperty(), true);
            }
        }
        JsonSchemaBuilder rootBuilder = new JsonSchemaBuilder().setName(props.getFormDefId()).setRootType("object").setStrict(true).setTargetProvider(llmType).setAdditionalProperties(false);
        String multirowBaseObject = props.getMultirowBaseObject();
        if (multirowBaseObject != null && !multirowBaseObject.isEmpty()) {
            rootBuilder.addArrayProperty(multirowBaseObject, itemBuilder, true);
        } else {
            itemBuilder.getProperties().keySet().forEach(key -> rootBuilder.addProperty((String)key, itemBuilder.getProperties().getJSONObject(key), true));
        }
        QuadConsumer<Enhancer, LLMConfig, EnhancerProperties, JsonSchemaBuilder> enhancerCallback = this.configEnhancers.getOrDefault((Object)llmType, this.configEnhancers.get((Object)AgentLLM.Type.ANTHROPIC));
        enhancerCallback.accept(enhancer, config, props, rootBuilder);
    }

    @FunctionalInterface
    public static interface QuadConsumer<A, B, C, D> {
        public void accept(A var1, B var2, C var3, D var4);
    }
}

