/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.model;

import org.json.JSONArray;
import org.json.JSONObject;

public class Function
extends JSONObject {
    public Function(String json) {
        super("{\"type\": \"function\"}");
        this.put("function", new JSONObject(json));
    }

    public Function(String name, String description, boolean strict) {
        super("{\"type\": \"function\"}");
        JSONObject function = new JSONObject();
        function.put("name", (Object)name);
        function.put("description", (Object)description);
        function.put("strict", strict);
        function.put("parameters", (Object)new JSONObject("{\"type\" : \"object\", \"properties\": {}, \"required\": [], \"additionalProperties\" : false}"));
        this.put("function", function);
    }

    public Function(String name, String description) {
        this(name, description, true);
    }

    public String getName() {
        JSONObject function = this.getJSONObject("function");
        return function.getString("name");
    }

    public String getDescription() {
        JSONObject function = this.getJSONObject("function");
        return function.getString("description");
    }

    public void addParameter(String name, String description) {
        this.addParameter(name, ParameterType.STRING, description);
    }

    public void addParameter(String name, ParameterType type, String description) {
        this.addParameter(name, type, description, true);
    }

    public void addParameter(String name, ParameterType type, String description, boolean required) {
        this.addParameter(name, type, description, null, required);
    }

    public void addParameter(String name, ParameterType type, String description, String[] options, boolean required) {
        this.addParameter(name, type, description, options, false, required);
    }

    public void addParameter(String name, ParameterType type, String description, boolean isArray, boolean required) {
        this.addParameter(name, type, description, null, isArray, required);
    }

    public void addParameter(String name, ParameterType type, String description, String[] options, boolean isArray, boolean required) {
        JSONObject function = this.getJSONObject("function");
        JSONObject parameters = function.getJSONObject("parameters");
        JSONObject properties = parameters.getJSONObject("properties");
        JSONObject parameter = new JSONObject();
        parameter.put("type", (Object)type.toString());
        if (description != null) {
            parameter.put("description", (Object)description);
        }
        if (options != null) {
            JSONArray optionsArray = new JSONArray();
            for (String o : options) {
                optionsArray.put((Object)o);
            }
            parameter.put("enum", (Object)optionsArray);
        }
        if (isArray) {
            JSONObject items = new JSONObject();
            items.put("type", (Object)"array");
            items.put("items", (Object)parameter);
            properties.put(name, (Object)items);
        } else {
            properties.put(name, (Object)parameter);
        }
        if (required) {
            JSONArray requiredArray = parameters.optJSONArray("required");
            requiredArray.put((Object)name);
        }
    }

    public static enum ParameterType {
        STRING("string"),
        BOOLEAN("boolean"),
        NUMBER("number"),
        INTEGER("integer");

        private String value;

        private ParameterType(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

