/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.model;

import java.util.Date;
import org.joget.ai.agent.model.AgentTraceStatus;
import org.joget.commons.util.UuidGenerator;

public class AgentTraceEvent {
    private String id = UuidGenerator.getInstance().getUuid();
    private String runId;
    private String nodeId;
    private String defId;
    private String parentId;
    private String type;
    private String label;
    private AgentTraceStatus status;
    private String request;
    private String response;
    private Date createdAt = new Date();

    public AgentTraceEvent() {
        this.id = UuidGenerator.getInstance().getUuid();
    }

    public AgentTraceEvent(String runId, String nodeId, String defId, String parentId, String type, String label, AgentTraceStatus status, String request, String response) {
        this.runId = runId;
        this.nodeId = nodeId;
        this.parentId = parentId;
        this.defId = defId;
        this.type = type;
        this.label = label;
        this.status = status;
        this.request = request;
        this.response = response;
    }

    public AgentTraceEvent(AgentTraceEvent other) {
        if (other != null) {
            this.id = UuidGenerator.getInstance().getUuid();
            this.runId = other.runId;
            this.nodeId = other.nodeId;
            this.defId = other.defId;
            this.parentId = other.parentId;
            this.type = other.type;
            this.label = other.label;
            this.status = other.status;
            this.request = other.request;
            this.response = other.response;
            this.createdAt = new Date();
        }
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRunId() {
        return this.runId;
    }

    public void setRunId(String runId) {
        this.runId = runId;
    }

    public String getDefId() {
        return this.defId;
    }

    public void setDefId(String defId) {
        this.defId = defId;
    }

    public String toString() {
        return "{\"id\":\"" + this.id + "\",\"runId\":\"" + this.runId + "\",\"nodeId\":\"" + this.nodeId + "\",\"defId\":\"" + this.defId + "\",\"parentId\":\"" + this.parentId + "\",\"type\":\"" + this.type + "\",\"label\":\"" + this.label + "\",\"status\":\"" + (this.status != null ? this.status.name() : null) + "\",\"request\":" + (this.request != null ? this.request : "null") + ",\"response\":" + (this.response != null ? this.response : "null") + ",\"createdAt\":\"" + this.createdAt + "\"}";
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public AgentTraceStatus getStatus() {
        return this.status;
    }

    public void setStatus(AgentTraceStatus status) {
        this.status = status;
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }
}

