/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.net.URL;
import java.util.Base64;
import java.util.Iterator;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.util.EntityUtils;
import org.joget.ai.agent.model.AgentException;
import org.joget.ai.agent.model.AgentLLM;
import org.joget.ai.agent.model.Functions;
import org.joget.ai.agent.model.LLMConfig;
import org.joget.ai.agent.model.Message;
import org.joget.ai.agent.model.Messages;
import org.joget.ai.agent.model.Response;
import org.joget.ai.agent.model.ToolExecution;
import org.joget.commons.util.LogUtil;
import org.joget.plugin.base.ExtDefaultPlugin;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class AgentLLMAbstract
extends ExtDefaultPlugin
implements AgentLLM {
    @Override
    public String getBuilderJavaScriptTemplate() {
        return "";
    }

    protected void processingFileMessages(Messages messages) {
        Iterator it = messages.iterator();
        while (it.hasNext()) {
            Message message = (Message)((Object)it.next());
            if (message.getFileInputSteam() == null) continue;
            try {
                InputStream is = message.getFileInputSteam();
                try {
                    String type = message.getString("type");
                    if (Message.FileType.IMAGE.toString().equals(type)) {
                        this.processingImageFileMessage(message, is);
                    } else {
                        this.processingTextFileMessage(message, is);
                    }
                    message.remove("type");
                    message.remove("fileContentType");
                    message.setFileInputStream(null);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception e) {
                LogUtil.error((String)AgentLLMAbstract.class.getName(), (Throwable)e, (String)"");
                it.remove();
            }
        }
    }

    protected void processingImageFileMessage(Message message, InputStream is) throws IOException {
        JSONArray content = new JSONArray();
        JSONObject text = new JSONObject();
        text.put("type", (Object)"text");
        text.put("text", (Object)message.getString("content"));
        content.put((Object)text);
        JSONObject url = new JSONObject();
        url.put("type", (Object)"image_url");
        JSONObject image = new JSONObject();
        image.put("url", (Object)this.convertImageToBase64(is, message.getString("fileContentType")));
        url.put("image_url", (Object)image);
        content.put((Object)url);
        message.put("content", content);
        message.put("role", "user");
    }

    protected String convertImageToBase64(InputStream is, String fileContentType) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = is.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            byte[] imageBytes = baos.toByteArray();
            String string = "data:" + fileContentType + ";base64," + Base64.getEncoder().encodeToString(imageBytes);
            return string;
        }
    }

    protected void processingTextFileMessage(Message message, InputStream is) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            String fileContent = baos.toString("UTF-8");
            StringBuilder content = new StringBuilder();
            content.append(message.getString("content")).append("\n\n```\n").append(fileContent).append("\n```");
            message.put("content", content.toString());
        }
    }

    protected JSONArray convertMessages(Messages messages) {
        return messages;
    }

    protected JSONArray convertFunctions(Functions functions) {
        return functions;
    }

    protected String preparePayload(LLMConfig config, Messages messages, Functions functions) {
        this.processingFileMessages(messages);
        JSONObject payload = new JSONObject(config.toString());
        payload.put("messages", (Object)this.convertMessages(messages));
        if (!functions.isEmpty()) {
            if (payload.has("tools")) {
                payload.getJSONArray("tools").putAll(this.convertFunctions(functions));
            } else {
                payload.put("tools", (Object)this.convertFunctions(functions));
            }
            if (!payload.has("tool_choice")) {
                payload.put("tool_choice", (Object)"auto");
            }
        }
        return payload.toString();
    }

    protected void prepareRequestHeader(HttpRequestBase request) {
        request.setHeader("Content-Type", "application/json");
        request.setHeader("Authorization", "Bearer " + this.getPropertyString("apiKey"));
    }

    protected void parseResponse(Response result, CloseableHttpResponse response) throws IOException {
        String jsonResponse = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        result.setFullJsonResponse(jsonResponse);
        if (jsonResponse != null && !jsonResponse.isEmpty()) {
            JSONObject jsonResponseObj = new JSONObject(jsonResponse);
            if (jsonResponseObj.has("choices")) {
                JSONObject message = jsonResponseObj.getJSONArray("choices").getJSONObject(0).getJSONObject("message");
                result.setMessage(message);
                if (message.has("tool_calls") && !message.isNull("tool_calls") && message.get("tool_calls") instanceof JSONArray && !message.getJSONArray("tool_calls").isEmpty()) {
                    JSONArray toolCalls = message.getJSONArray("tool_calls");
                    for (int i = 0; i < toolCalls.length(); ++i) {
                        JSONObject call = toolCalls.getJSONObject(i);
                        if (!call.has("function")) continue;
                        JSONObject function = call.getJSONObject("function");
                        String name = function.getString("name");
                        String argJson = function.getString("arguments");
                        JSONObject arguments = new JSONObject(argJson);
                        ToolExecution te = new ToolExecution(name, arguments);
                        if (call.has("id")) {
                            te.setId(call.getString("id"));
                        }
                        result.addToolExecution(te);
                    }
                } else {
                    result.setContent(message.getString("content"));
                }
            } else if (jsonResponseObj.has("error")) {
                String errorMessage = jsonResponseObj.getJSONObject("error").getString("message");
                result.setContent(errorMessage);
                LogUtil.error((String)this.getClass().getName(), null, (String)("Failed to parse response: " + errorMessage));
            }
        }
    }

    protected Response callService(String url, LLMConfig config, Messages messages, Functions functions) throws AgentException {
        CloseableHttpClient client = null;
        HttpPost request = null;
        Response result = new Response();
        try {
            client = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault())).build();
            URL urlObj = new URL(url);
            request = new HttpPost(urlObj.toURI());
            this.prepareRequestHeader((HttpRequestBase)request);
            String payload = this.preparePayload(config, messages, functions);
            result.setRequestPayload(payload);
            StringEntity requestEntity = new StringEntity(payload, "UTF-8");
            ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)requestEntity);
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)request);){
                this.parseResponse(result, response);
            }
        }
        catch (Exception e) {
            LogUtil.error((String)AgentLLMAbstract.class.getName(), (Throwable)e, (String)"");
            throw new AgentException(e.getLocalizedMessage());
        }
        finally {
            try {
                if (request != null) {
                    request.releaseConnection();
                }
                if (client != null) {
                    client.close();
                }
            }
            catch (IOException ex) {
                LogUtil.error((String)AgentLLMAbstract.class.getName(), (Throwable)ex, (String)"");
            }
        }
        return result;
    }

    protected <T> T getOrDefault(String key, Class<T> clazz, T defaultValue) {
        Object value = this.getProperty(key);
        if (clazz.isInstance(value)) {
            return (T)value;
        }
        if (value instanceof String) {
            try {
                Object converted = ConvertUtils.convert((Object)value, clazz);
                if (clazz.isInstance(converted)) {
                    return (T)converted;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

