/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.mcp;

import java.time.Duration;
import org.joget.ai.agent.mcp.CustomMcpClient;
import org.joget.ai.agent.mcp.McpClient;

public class McpClientBuilder {
    public static final int DEFAULT_TIMEOUT_SECONDS = 60;
    private String sseUrl;
    private Duration timeout = Duration.ofSeconds(60L);

    public McpClientBuilder sseUrl(String sseUrl) {
        this.sseUrl = sseUrl;
        return this;
    }

    public McpClientBuilder timeout(Integer seconds) {
        if (seconds == null) {
            return this;
        }
        return this.timeout(Duration.ofSeconds(seconds.intValue()));
    }

    public McpClientBuilder timeout(Duration timeout) {
        this.timeout = timeout == null || timeout.isZero() || timeout.isNegative() ? Duration.ofSeconds(60L) : timeout;
        return this;
    }

    public McpClient build() {
        if (this.sseUrl == null) {
            throw new IllegalArgumentException("SSE URL is required");
        }
        if (this.timeout == null || this.timeout.isNegative() || this.timeout.isZero()) {
            throw new IllegalArgumentException("Timeout must be a positive, non-null value");
        }
        return new CustomMcpClient(this.sseUrl, this.timeout);
    }
}

