/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.mcp;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.joget.ai.agent.mcp.JsonRpcMethod;

public class JRPCRequestDto {
    private final String jsonrpc = "2.0";
    private final String id;
    private final String method;
    private final ObjectNode params;

    public JRPCRequestDto(String id, JsonRpcMethod method, ObjectNode params) {
        this.id = id;
        this.method = method.getMethod();
        this.params = params;
    }

    public ObjectNode toJson(ObjectMapper objectMapper) {
        ObjectNode request = objectMapper.createObjectNode();
        request.put("jsonrpc", "2.0");
        request.put("id", this.id);
        request.put("method", this.method);
        if (this.params != null) {
            request.set("params", (JsonNode)this.params);
        } else {
            request.set("params", (JsonNode)objectMapper.createObjectNode());
        }
        return request;
    }
}

