/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.model;

import java.io.InputStream;
import org.joget.ai.agent.model.AgentLLM;
import org.json.JSONArray;
import org.json.JSONObject;

public class Message
extends JSONObject {
    private InputStream fileInputStream;

    public Message(String json) {
        super(json);
    }

    public Message(Role role, String content) {
        this.put("role", role.toString());
        this.put("content", content);
    }

    public Message(Role role, JSONObject content) {
        this(role, content.toString());
    }

    public Message(String toolCallId, String content) {
        this.put("role", Role.TOOL.toString());
        this.put("tool_call_id", toolCallId);
        this.put("content", content);
    }

    public Message(Role role, String purpose, FileType type, InputStream fileInputStream) {
        this(role, purpose, type, fileInputStream, "");
    }

    public Message(Role role, String purpose, FileType type, InputStream fileInputStream, String fileContentType) {
        this.put("role", role.toString());
        this.put("type", type.toString());
        this.put("content", purpose);
        this.put("fileContentType", fileContentType);
        this.fileInputStream = fileInputStream;
    }

    public InputStream getFileInputSteam() {
        return this.fileInputStream;
    }

    public void setFileInputStream(InputStream fileInputStream) {
        this.fileInputStream = fileInputStream;
    }

    public static Message createFunctionResponseMessage(AgentLLM agent, String functionName, String toolCallId, String result) {
        if (agent.getLLMType() == AgentLLM.Type.GEMINI) {
            JSONObject functionResponse = new JSONObject();
            functionResponse.put("name", (Object)functionName);
            functionResponse.put("response", (Object)new JSONObject().put("result", (Object)result));
            JSONArray parts = new JSONArray();
            JSONObject part = new JSONObject();
            part.put("functionResponse", (Object)functionResponse);
            parts.put((Object)part);
            JSONObject messageJson = new JSONObject();
            messageJson.put("role", (Object)"user");
            messageJson.put("parts", (Object)parts);
            return new Message(messageJson.toString());
        }
        return new Message(toolCallId, result);
    }

    public static enum FileType {
        TEXT("TEXT"),
        IMAGE("IMAGE");

        private String value;

        private FileType(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum Role {
        USER("user"),
        SYSTEM("system"),
        TOOL("tool"),
        ASSISTANT("assistant");

        private String value;

        private Role(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

