
var replaceFormDesignQuery = "";
var replaceFormDesignChatOutputId = "";

var lastReplaceFormDesignIsFile = false;

var removeFormDesignNamesList = [];
var removeFormDesignChatOutputId = "";

// Click event for the send button after the user describes the app's process
$(document).on('click', '.gen-ai-section:not(.template) .action-button.input.replace-form-design.send', function () {
    // If not an empty value
    if($(".gen-ai-section:not(.template) .input-box").val().trim() != "" || isFileUploaded){
        lastReplaceFormDesignIsFile = false;
        hidePreviewSection();
        $(".chat-output").find(".box").removeClass("selected");
        scrollChatScrollViewDown()
        setInputBoxHalfHeight();
        currentStage = "replace_form_design";
        replaceFormDesignQuery = $(".gen-ai-section:not(.template) .input-box").val();
        $(".gen-ai-section:not(.template) .input-box").val("");
        discontinueApiCalls = false;
        createChat(false);
        $(".chat-output.file-box .indicator").addClass("hide").removeClass("replace-form-design remove-form-design");
    }
});


// Calls /replace_form_design API
async function replaceFormDesign() {
    if(lastReplaceFormDesignIsFile){
        isFileUploaded = true;
    }

    formName = getFormDesignName(replaceFormDesignChatOutputId);
    var imageBase64ListRaw = imageBase64List.map(imageBase64 => imageBase64.split("base64,")[1]);

    const formData = new FormData();
    formData.append('_a', 'replace_form_design');
    formData.append('stage_name', 'replace_form_design');
    formData.append('user_id', userId);
    formData.append('session_id', sessionId);
    formData.append('query', isFileUploaded ? "" : replaceFormDesignQuery);
    formData.append('image_base_64_list', isFileUploaded ? JSON.stringify(imageBase64ListRaw) : JSON.stringify([]));
    formData.append('_awsModels', JSON.stringify(awsModels));
    formData.append('form_to_replace', formName);

    try {
        if(!formData.get("query") && formData.get("image_base_64_list") !== "[]"){
            lastReplaceFormDesignIsFile = true;
        }else{
            lastReplaceFormDesignIsFile = false;
        }
        const request = $.ajax({ 
            type: "POST",
            data: formData,
            processData: false, // Prevent jQuery from converting FormData to string
            contentType: false, // Let browser set appropriate headers for FormData
            url: `${UI.base}/web/json/plugin/org.joget.ai.designer.AiDesigner/service`,
            dataType: "json"
        });
        ajaxRequestObjectList.push(request);
        const response = await request;
        if(discontinueApiCalls){
            return;
        }
        // If API call involved file upload, reset the flag
        if(isFileUploaded){
            isFileUploaded = false;
        }
        if (response.status) {
            const joget_designed_forms = response.joget_designed_forms;
            // Helper to check empty responses
            const isEmptyResponse = (condition) => {
                if (condition) {
                    return true;
                }
            };
            let formattedResult = isEmptyResponse(Object.keys(joget_designed_forms).length == 0) ? "" : joget_designed_forms;
            removeOperationsContainer([formName]);
            return new Map([
                ['result', formattedResult],
                ['status', true]
            ]);
        } else {
            return new Map([
                ['result', response.message],
                ['status', false]
            ]);
        }
    } catch (error) {
        console.error("AJAX request failed:", error);
        return new Map([
            ['result', error.responseJSON?.message || "@@aiag.error@@"],
            ['status', false]
        ]);
    }
}

$(document).on('click', '.chat-output.file-box .operations-container .operations .operation.replace-form-design', function () {
    $(".chat-output.file-box .indicator").addClass("hide").removeClass("replace-form-design remove-form-design");
    var chatOutput = $(this).closest(".chat-output");
    $(chatOutput).find(".indicator").removeClass("hide remove-form-design").addClass("replace-form-design");
    replaceFormDesignChatOutputId = $(chatOutput).attr("chat-output-id");
    $(".gen-ai-section:not(.template) .action-button.input.file-upload").removeClass("hide"); // Hides the file upload action button while correction
    $(".gen-ai-section:not(.template) .action-button.input").each(function() {
        if (!$(this).hasClass("cancel")) {
            $(this)
                .removeClass("query correction add-form-design")
                .addClass("replace-form-design");
        }
    });
    $(".gen-ai-section:not(.template) .input-box").attr("placeholder", "@@aiag.replaceFormDesignPlaceholder@@").removeClass("correction add-form-design").addClass("replace-form-design");
  
    $(".gen-ai-section:not(.template) .conversation-section .help-section").css("opacity", "0");
    scrollChatScrollViewDown()
    setInputBoxFullHeight();
});

$(document).on('click', '.chat-output.file-box .operations-container .operations .operation.remove-form-design', function () {
    var chatOutput = $(this).closest(".chat-section").attr("chat-output-id");
    $(".chat-output.file-box .indicator").addClass("hide").removeClass("remove-form-design replace-form-design");
    var chatOutput = $(this).closest(".chat-output");
    $(chatOutput).find(".indicator").removeClass("hide replace-form-design").addClass("remove-form-design");
    removeFormDesignChatOutputId = $(chatOutput).attr("chat-output-id");

    var chatOutputList = $(this).closest(".chat-output-list");
    chatOutputList_removeFormDesign = chatOutputList
    chatOutputList.find('.chat-output.file-box').each(function() {
        var chatOutput = $(this);
        if(chatOutputMap.get(chatOutput.attr("chat-output-id")).type == "json" && removeFormDesignChatOutputId != chatOutput.attr("chat-output-id")){
            $(chatOutput).find(".indicator").removeClass("hide replace-form-design remove-form-design");
        }

    });

    setInputBoxHalfHeight(true);
    $(".gen-ai-section:not(.template) .suggestion-section").addClass("hide");
    $(".gen-ai-section:not(.template) .suggestion-section-for-remove-form-design").removeClass("hide");

    $(".gen-ai-section:not(.template) .conversation-section .help-section").css("opacity", "0");
});

$(document).on('click', '.gen-ai-section:not(.template) .suggestion-section-for-remove-form-design .suggestion-button.remove', function () {
    removeFormDesignNamesList = [];
    $(".chat-output.file-box .indicator.remove-form-design").each(function() {
        var chatOutput = $(this).closest(".chat-output");
        var formDesignName = getFormDesignName($(chatOutput).attr("chat-output-id"));
        removeFormDesignNamesList.push(formDesignName);
    });
    hidePreviewSection();
    $(".chat-output").find(".box").removeClass("selected");
    setInputBoxHalfHeight();
    currentStage = "remove_form_design";
    discontinueApiCalls = false;
    createChat(false);
    $(".chat-output.file-box .indicator").addClass("hide").removeClass("replace-form-design remove-form-design");
    $(".chat-output .indicator").removeClass("replace-form-design remove-form-design").addClass("hide");
    $(".gen-ai-section:not(.template) .suggestion-section").removeClass("hide");
    $(".gen-ai-section:not(.template) .suggestion-section-for-remove-form-design").addClass("hide");
    scrollChatScrollViewDown();
});

$(document).on('click', '.gen-ai-section:not(.template) .suggestion-section-for-remove-form-design .suggestion-button.cancel', function () {
    $(".chat-output .indicator").removeClass("replace-form-design remove-form-design").addClass("hide");
    $(".gen-ai-section:not(.template) .suggestion-section").removeClass("hide");
    $(".gen-ai-section:not(.template) .conversation-section .help-section").removeClass("hide");
    $(".gen-ai-section:not(.template) .conversation-section .help-section").css("opacity", "1");

    $(".gen-ai-section:not(.template) .suggestion-section-for-remove-form-design").addClass("hide");
});

// Calls /remove_form_design API
async function removeFormDesign() {
    const params = {
        '_a': 'remove_form_design',
        'stage_name': 'remove_form_design',
        'user_id': userId,
        'session_id': sessionId,
        'forms_to_remove': JSON.stringify(removeFormDesignNamesList)
    };
    try {
        const request = $.ajax({ 
            type: "POST",
            url: `${UI.base}/web/json/plugin/org.joget.ai.designer.AiDesigner/service`,
            data: params,
            dataType: "json"
        });
        ajaxRequestObjectList.push(request);
        const response = await request;
        if(discontinueApiCalls){
            return;
        }
        if (response.status) {
            const joget_designed_forms = response.joget_designed_forms;
            // Helper to check empty responses
            const isEmptyResponse = (condition) => {
                if (condition) {
                    return true;
                }
            };
            let formattedResult = isEmptyResponse(Object.keys(joget_designed_forms).length == 0) ? "" : joget_designed_forms;
            removeOperationsContainer(removeFormDesignNamesList);
            return new Map([
                ['result', formattedResult],
                ['status', true]
            ]);
        } else {
            return new Map([
                ['result', response.message],
                ['status', false]
            ]);
        }
    } catch (error) {
        console.error("AJAX request failed:", error);
        return new Map([
            ['result', error.responseJSON?.message || "@@aiag.error@@"],
            ['status', false]
        ]);
    }
}

$(document).on('click', '.chat-output.file-box .indicator', function () {
    var chatOutput = $(this).closest(".chat-output");
    if(removeFormDesignChatOutputId != chatOutput.attr("chat-output-id")){
        if($(this).hasClass("remove-form-design")){
            $(this).removeClass("remove-form-design");
        }else{
            $(this).addClass("remove-form-design");
        }
    }
});

$(document).on('click', '.chat-output.file-box .operations-container .icon-container i', function () {
    var operations = $(this).closest('.operations-container').find('.operations');
    $(".chat-output.file-box .operations-container .operations").toArray().forEach(function(element) {
        if(!$(element).closest(".chat-output").hasClass("template")){
            if($(element).closest(".chat-output").attr("chat-output-id") != $(operations).closest(".chat-output").attr("chat-output-id")){
                $(element).addClass("hide");
            }
        }
    });
    if($(operations).hasClass('hide')){
        $(operations).removeClass('hide');
    }else{
        $(operations).addClass('hide');
    }
});

function removeOperationsContainer(formNames){
    $('.chat-output.file-box').each(function() {
        var chatOutput = $(this);
        formNames.forEach(function(name) {
            if($(chatOutput).attr("form-design-name") == name){
                $(chatOutput).find(".indicator, .operations-container").remove();
            }
        });
    });
}

// Close dropdown if clicked outside
$(document).on('click', function(event) {
    if (!$(event.target).closest('.chat-output.file-box .operations-container .icon-container i').length) {
        $(".chat-output.file-box .operations-container .operations").addClass("hide");
    }
});

var indicator = $(".template.indicator").clone();
$(indicator).removeClass("template");
var operationsContainer = $(".template.operations-container").clone();
$(operationsContainer).removeClass("template hide");

$(".template.chat-output.file-box .box").before(indicator);
$(".template.chat-output.file-box .box").after(operationsContainer);


