var processProposalQueryEnhanced = "";
var processProposalQueryMasked = "";

async function suggestQuery() {
    const params = {
        '_a': 'query_enhancer',
        'user_id': encodeURIComponent(userId),
        'session_id': encodeURIComponent(sessionId),
        'query': "",
        '_awsModels': JSON.stringify(awsModels)
    };
    try{
        let ajaxRequest;
        const request = new Promise((resolve, reject) => {
            ajaxRequest = $.ajax({
                type: "POST",
                url: UI.base + `/web/json/plugin/org.joget.ai.designer.AiDesigner/service`,
                data: params,
                dataType: "json",
                success: resolve,
                error: reject
            });
        });
        ajaxRequestObjectList.push(ajaxRequest)
        const response = await request;
        if(discontinueApiCalls){
            return;
        }
        return response.response;
    }catch(error){
        console.error("Error during AJAX request:", error);
        return "";
    }
}

async function enhanceFunction(chatInputText) {
    const params = {
        '_a': 'query_enhancer',
        'stage_name': 'query_enhancer',
        'user_id': encodeURIComponent(userId),
        'session_id': encodeURIComponent(sessionId),
        'query': chatInputText,
        '_awsModels': JSON.stringify(awsModels)
    };
    try{
        let ajaxRequest;
        const request = new Promise((resolve, reject) => {
            ajaxRequest = $.ajax({
                type: "POST",
                url: UI.base + `/web/json/plugin/org.joget.ai.designer.AiDesigner/service`,
                data: params,
                dataType: "json",
                success: resolve,
                error: reject
            });
        });
        ajaxRequestObjectList.push(ajaxRequest)
        const response = await request;
        if(discontinueApiCalls){
            return;
        }
        var object = {
            processProposalQueryEnhanced: response.response, 
            status: true
        };
        return object; 
    }catch(error){
        var object = {
            status: false
        };
        return object; 
    }
}

async function piiFunction(chatInputText) {
    const params = {
        '_a': 'pii_analyser',
        'stage_name': 'query_pii_masking',
        'user_id': encodeURIComponent(userId),
        'session_id': encodeURIComponent(sessionId),
        'query': chatInputText,
        'deny_list': JSON.stringify(myPiiMaskingRulesConfigString.properties.myPiiMaskingRules),
        '_awsModels': JSON.stringify(awsModels)
    };
    try {
        let ajaxRequest;
        const request = new Promise((resolve, reject) => {
            ajaxRequest = $.ajax({
                type: "POST",
                url: UI.base + `/web/json/plugin/org.joget.ai.designer.AiDesigner/service`,
                data: params,
                dataType: "json",
                success: resolve,
                error: reject
            });
        });
        ajaxRequestObjectList.push(ajaxRequest)
        const response = await request;
        if(discontinueApiCalls){
            return;
        }
        var object = {
            processProposalQueryMasked: response.response, 
            status: true
        };
        return object; 
    } catch (error) {
        var object = {
            status: false
        };
        return object; 
    }
}