
// Add event listener for service selector interaction during spotlight
$(document).on('change', '.genaiview-ai-service', function() {
    var selectedService = $(this).val();
    // Update the config view selector to match
    $(".config-section:not(.template) #current-ai-service").val(selectedService);
    // Save the new selection
    saveCurrentAiService(false);
    
    // If we're in a spotlight tour and this is the service selector step, move to next step
    if (spotlightActive && currentSpotlightIndex === 0 && spotlightQueue.length > 1) {
        setTimeout(() => {
            nextSpotlightStep();
        }, 500); // Small delay to let the user see the selection
    }
});

var aiServiceQuickSwitch = $(".template.service-selector-container").clone();
$(aiServiceQuickSwitch).removeClass("template hide");

$(".template.close-section").prepend(aiServiceQuickSwitch);