/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.designer.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joget.ai.designer.AiDesigner;
import org.joget.ai.designer.utils.GenerationUtils.FormGenerationUtils;
import org.joget.ai.designer.utils.WorkflowUtils;
import org.joget.apps.app.service.AppUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XpdlHelper {
    public static final AiDesigner aiDesigner = new AiDesigner();

    public static Map<String, Map<String, String>> prepareMappings(String processId, String runProcessFormName, Map<String, Map<String, String>> generated, NodeList transitionList, NodeList activityList, Map<String, Collection<String>> formActivityNamesMap) {
        generated = XpdlHelper.prepareProcessFormMapping(processId, "runProcess", runProcessFormName, generated);
        generated = WorkflowUtils.addGenerated("RunProcess", runProcessFormName, runProcessFormName, generated);
        try {
            for (int j = 0; j < activityList.getLength(); ++j) {
                boolean hasRoute;
                Node activityNode = activityList.item(j);
                if (activityNode.getNodeType() != 1) continue;
                Element activityElement = (Element)activityNode;
                String activityId = activityElement.getAttribute("Id");
                String connectedForm = FormGenerationUtils.getFormNameByActivity(activityId, formActivityNamesMap);
                boolean bl = hasRoute = activityElement.getElementsByTagName("Route").getLength() > 0;
                if (hasRoute) {
                    NodeList transitionRestrictionsList = activityElement.getElementsByTagName("TransitionRestrictions");
                    String transitionRestrictionsType = XpdlHelper.getTransitionRestrictionsType(transitionRestrictionsList);
                    if (!"Split".equals(transitionRestrictionsType)) continue;
                    Element transitionRestrictionElement = (Element)transitionRestrictionsList.item(0);
                    NodeList transitionRefList = transitionRestrictionElement.getElementsByTagName("TransitionRef");
                    ArrayList<Element> transitionElementList = new ArrayList<Element>();
                    if (transitionRefList.getLength() > 1) {
                        for (int k = 0; k < transitionRefList.getLength(); ++k) {
                            Node transitionRefNode = transitionRefList.item(k);
                            if (transitionRefNode.getNodeType() != 1) continue;
                            Element transitionRefElement = (Element)transitionRefNode;
                            String transitionRefElementId = transitionRefElement.getAttribute("Id");
                            transitionElementList.add(XpdlHelper.findTransitionElement(transitionRefElementId, transitionList));
                        }
                    }
                    XpdlHelper.prepareRouteMapping(activityId, transitionElementList, processId, generated);
                    continue;
                }
                NodeList implementationList = activityElement.getElementsByTagName("Implementation");
                Element implementationElement = (Element)implementationList.item(0);
                NodeList toolList = implementationElement.getElementsByTagName("Tool");
                NodeList noList = implementationElement.getElementsByTagName("No");
                if (toolList.getLength() > 0 || noList.getLength() <= 0) continue;
                boolean isActivityApprovalValue = XpdlHelper.isActivityApproval(activityId, transitionList, activityList);
                generated = XpdlHelper.prepareProcessEnhancementMapping(activityElement, isActivityApprovalValue, connectedForm, generated, processId, transitionList, activityList);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return generated;
    }

    public static boolean isActivityApproval(String activityId, NodeList transitionList, NodeList activityList) {
        boolean isActivityApproval = false;
        try {
            int i;
            String leadingActivityId = null;
            Element leadingActivityElement = null;
            Element transitionElement = null;
            for (int i2 = 0; i2 < transitionList.getLength(); ++i2) {
                Node transitionNode = transitionList.item(i2);
                if (transitionNode.getNodeType() != 1 || !activityId.equals((transitionElement = (Element)transitionNode).getAttribute("From"))) continue;
                leadingActivityId = transitionElement.getAttribute("To");
            }
            for (int j = 0; j < activityList.getLength(); ++j) {
                Element activityElement;
                Node activityNode = activityList.item(j);
                if (activityNode.getNodeType() != 1 || !leadingActivityId.equals((activityElement = (Element)activityNode).getAttribute("Id"))) continue;
                leadingActivityElement = activityElement;
            }
            NodeList transitionRestrictionsList = leadingActivityElement.getElementsByTagName("TransitionRestrictions");
            Element transitionRestrictionElement = (Element)transitionRestrictionsList.item(0);
            NodeList transitionRefList = transitionRestrictionElement.getElementsByTagName("TransitionRef");
            ArrayList<Element> transitionElementList = new ArrayList<Element>();
            if (transitionRefList.getLength() > 1) {
                for (i = 0; i < transitionRefList.getLength(); ++i) {
                    Node transitionRefNode = transitionRefList.item(i);
                    if (transitionRefNode.getNodeType() != 1) continue;
                    Element transitionRefElement = (Element)transitionRefNode;
                    String transitionRefElementId = transitionRefElement.getAttribute("Id");
                    transitionElementList.add(XpdlHelper.findTransitionElement(transitionRefElementId, transitionList));
                }
            }
            for (i = 0; i < transitionElementList.size(); ++i) {
                String transitionName = ((Element)transitionElementList.get(i)).getAttribute("Name");
                if (!transitionName.contains("status")) {
                    isActivityApproval = false;
                    break;
                }
                isActivityApproval = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isActivityApproval;
    }

    public static Element findLeadingActivity(String activityId, NodeList transitionList, NodeList activityList) {
        String leadingActivityId = null;
        Element leadingActivityElement = null;
        Element transitionElement = null;
        for (int i = 0; i < transitionList.getLength(); ++i) {
            Node transitionNode = transitionList.item(i);
            if (transitionNode.getNodeType() != 1 || !activityId.equals((transitionElement = (Element)transitionNode).getAttribute("From"))) continue;
            leadingActivityId = transitionElement.getAttribute("To");
        }
        for (int j = 0; j < activityList.getLength(); ++j) {
            Element activityElement;
            Node activityNode = activityList.item(j);
            if (activityNode.getNodeType() != 1 || !leadingActivityId.equals((activityElement = (Element)activityNode).getAttribute("Id"))) continue;
            leadingActivityElement = activityElement;
        }
        return leadingActivityElement;
    }

    public static Element findTransitionElement(String transitionId, NodeList transitionList) {
        Node transitionNode;
        Element transitionElement = null;
        for (int i = 0; !(i >= transitionList.getLength() || (transitionNode = transitionList.item(i)).getNodeType() == 1 && transitionId.equals((transitionElement = (Element)transitionNode).getAttribute("Id"))); ++i) {
        }
        return transitionElement;
    }

    public static String getTransitionRestrictionsType(NodeList transitionRestrictionList) {
        String transitionRestrictionsType = null;
        if (transitionRestrictionList.getLength() > 0) {
            Element transitionRestrictionElement = (Element)transitionRestrictionList.item(0);
            Node joinNode = transitionRestrictionElement.getElementsByTagName("Join").item(0);
            Node splitNode = transitionRestrictionElement.getElementsByTagName("Split").item(0);
            if (joinNode != null) {
                transitionRestrictionsType = "Join";
            } else if (splitNode != null) {
                transitionRestrictionsType = "Split";
            }
        } else {
            transitionRestrictionsType = "None";
        }
        return transitionRestrictionsType;
    }

    public static void prepareRouteMapping(String activityId, List<Element> transitions, String processId, Map<String, Map<String, String>> generated) {
        String json = null;
        Object ifrules = "";
        String lastTransitionId = null;
        for (int i = 0; i < transitions.size(); ++i) {
            String[] partsD;
            Matcher matcher;
            Pattern pattern;
            Object conditions;
            String[] parts;
            String revert;
            String value;
            String operation;
            String variable;
            String transitionId = transitions.get(i).getAttribute("Id");
            String transitionName = transitions.get(i).getAttribute("Name");
            if (transitionName.contains("&lt;")) {
                transitionName = transitionName.replace("&lt;", "<");
            }
            if (transitionName.contains("&gt;")) {
                transitionName = transitionName.replace("&gt;", ">");
            }
            if (transitionName.contains("&amp;")) {
                transitionName = transitionName.replace("&amp;", "&");
            }
            if (transitionName.contains("&&")) {
                variable = null;
                operation = null;
                value = null;
                revert = "false";
                parts = transitionName.split("&&");
                for (int j = 0; j < parts.length; ++j) {
                    parts[j] = parts[j].trim();
                }
                conditions = "[";
                int counter = 0;
                for (String part : parts) {
                    pattern = Pattern.compile("(<=|>=|==|!=|<|>)");
                    matcher = pattern.matcher(part);
                    if (matcher.find()) {
                        operation = matcher.group();
                        partsD = part.split(Pattern.quote(operation));
                        variable = partsD[0].trim();
                        value = partsD[1].trim();
                        if ("!=".equals(operation)) {
                            operation = "==";
                            revert = "true";
                        }
                    }
                    conditions = ++counter == parts.length ? (String)conditions + "{\"variable\": \"" + variable + "\", \"revert\": " + revert + ",\"operation\": \"" + operation + "\", \"value\": \"" + value + "\"}" : (String)conditions + "{\"variable\": \"" + variable + "\", \"revert\": " + revert + ",\"operation\": \"" + operation + "\", \"value\": \"" + value + "\"},";
                }
                conditions = (String)conditions + "]";
                ifrules = (String)ifrules + "{\"andOr\":\"and\",\"revert\":false,\"conditions\":" + (String)conditions + ",\"actions\":[{\"name\":\"" + transitionId + "\",\"type\":\"transition\",\"value\":\"\"}]}";
                if (transitions.size() - i == 1) {
                    lastTransitionId = transitionId;
                    continue;
                }
                ifrules = (String)ifrules + ",";
                continue;
            }
            if (transitionName.contains("||")) {
                variable = null;
                operation = null;
                value = null;
                revert = "false";
                parts = transitionName.split("\\s*\\|\\|\\s*");
                for (int j = 0; j < parts.length; ++j) {
                    parts[j] = parts[j].trim();
                }
                conditions = "[";
                int counter = 0;
                for (String part : parts) {
                    pattern = Pattern.compile("(<=|>=|==|!=|<|>)");
                    matcher = pattern.matcher(part);
                    if (matcher.find()) {
                        operation = matcher.group();
                        partsD = part.split(Pattern.quote(operation));
                        variable = partsD[0].trim();
                        value = partsD[1].trim();
                        if ("!=".equals(operation)) {
                            operation = "==";
                            revert = "true";
                        }
                    }
                    conditions = ++counter == parts.length ? (String)conditions + "{\"variable\": \"" + variable + "\", \"revert\": " + revert + ",\"operation\": \"" + operation + "\", \"value\": \"" + value + "\"}" : (String)conditions + "{\"variable\": \"" + variable + "\", \"revert\": " + revert + ",\"operation\": \"" + operation + "\", \"value\": \"" + value + "\"},";
                }
                conditions = (String)conditions + "]";
                ifrules = (String)ifrules + "{\"andOr\":\"or\",\"revert\":false,\"conditions\":" + (String)conditions + ",\"actions\":[{\"name\":\"" + transitionId + "\",\"type\":\"transition\",\"value\":\"\"}]}";
                if (transitions.size() - i == 1) {
                    lastTransitionId = transitionId;
                    continue;
                }
                ifrules = (String)ifrules + ",";
                continue;
            }
            variable = null;
            operation = null;
            value = null;
            revert = "false";
            Pattern pattern2 = Pattern.compile("(<=|>=|==|!=|<|>)");
            Matcher matcher2 = pattern2.matcher(transitionName);
            if (!matcher2.find()) continue;
            operation = matcher2.group();
            String[] parts2 = transitionName.split(Pattern.quote(operation));
            variable = parts2[0].trim();
            value = parts2[1].trim();
            if ("!=".equals(operation)) {
                operation = "==";
                revert = "true";
            }
            ifrules = (String)ifrules + "{\"andOr\":\"and\",\"revert\":false,\"conditions\":[{\"variable\":\"" + variable + "\",\"revert\":" + revert + ",\"operation\":\"" + operation + "\",\"value\":\"" + value + "\"}],\"actions\":[{\"name\":\"" + transitionId + "\",\"type\":\"transition\",\"value\":\"\"}]}";
            if (transitions.size() - i == 1) {
                lastTransitionId = transitionId;
                continue;
            }
            ifrules = (String)ifrules + ",";
        }
        json = "{\"rules\": { \"ifrules\": [" + (String)ifrules + "], \"else\": [{\"type\": \"transition\", \"name\": \"" + lastTransitionId + "\", \"value\": \"\"}]}}";
        generated = WorkflowUtils.addGenerated("Route", processId + "::" + activityId, json, generated);
    }

    public static Map<String, Map<String, String>> prepareProcessEnhancementMapping(Element activityElement, boolean isApproval, String connectedForm, Map<String, Map<String, String>> generated, String processId, NodeList transitionList, NodeList activityList) {
        String readonly = "true";
        String json = "";
        String activityId = activityElement.getAttribute("Id");
        if (isApproval) {
            String value;
            String[] parts;
            String operation;
            String approved = "";
            String rejected = "";
            String enabledClarify = "";
            String clarification = "";
            String enabledReassignment = "";
            String reassignment = "";
            Element leadingActivityElement = XpdlHelper.findLeadingActivity(activityId, transitionList, activityList);
            NodeList transitionRestrictionsList = leadingActivityElement.getElementsByTagName("TransitionRestrictions");
            Element transitionRestrictionElement = (Element)transitionRestrictionsList.item(0);
            NodeList transitionRefList = transitionRestrictionElement.getElementsByTagName("TransitionRef");
            ArrayList<Element> transitionElementList = new ArrayList<Element>();
            if (transitionRefList.getLength() > 1) {
                for (int i = 0; i < transitionRefList.getLength(); ++i) {
                    Node transitionRefNode = transitionRefList.item(i);
                    if (transitionRefNode.getNodeType() != 1) continue;
                    Element transitionRefElement = (Element)transitionRefNode;
                    String transitionRefElementId = transitionRefElement.getAttribute("Id");
                    transitionElementList.add(XpdlHelper.findTransitionElement(transitionRefElementId, transitionList));
                }
            }
            String transitionName = ((Element)transitionElementList.get(0)).getAttribute("Name");
            Pattern pattern = Pattern.compile("(<=|>=|==|!=|<|>)");
            Matcher matcher = pattern.matcher(transitionName);
            if (matcher.find()) {
                operation = matcher.group();
                parts = transitionName.split(Pattern.quote(operation));
                approved = value = parts[1].trim();
            }
            transitionName = ((Element)transitionElementList.get(1)).getAttribute("Name");
            pattern = Pattern.compile("(<=|>=|==|!=|<|>)");
            matcher = pattern.matcher(transitionName);
            if (matcher.find()) {
                operation = matcher.group();
                parts = transitionName.split(Pattern.quote(operation));
                rejected = value = parts[1].trim();
            }
            for (int i = 0; i < transitionElementList.size(); ++i) {
                transitionName = ((Element)transitionElementList.get(i)).getAttribute("Name");
                pattern = Pattern.compile("(<=|>=|==|!=|<|>)");
                matcher = pattern.matcher(transitionName);
                if (!matcher.find()) continue;
                String operation2 = matcher.group();
                String[] parts2 = transitionName.split(Pattern.quote(operation2));
                String value2 = parts2[1].trim();
                if ("Clarification".equals(value2)) {
                    enabledClarify = "true";
                    clarification = ((Element)transitionElementList.get(i)).getAttribute("Id");
                    continue;
                }
                if (!"Reassignment".equals(value2)) continue;
                enabledReassignment = "true";
                reassignment = ((Element)transitionElementList.get(i)).getAttribute("Id");
            }
            json = AppUtil.readPluginResource((String)((Object)((Object)aiDesigner)).getClass().getName(), (String)"/resources/generator/ai/approval.json", (Object[])new String[]{readonly, enabledClarify, clarification, enabledReassignment, reassignment, approved, approved, rejected, rejected}, (boolean)true, null);
        } else {
            if (activityId.equalsIgnoreCase("clarification")) {
                readonly = "";
            }
            json = AppUtil.readPluginResource((String)((Object)((Object)aiDesigner)).getClass().getName(), (String)"/resources/generator/ai/activity.json", (Object[])new String[]{readonly}, (boolean)true, null);
        }
        generated = WorkflowUtils.addGenerated("Process Enhancement", processId + "::" + activityId, json, generated);
        generated = XpdlHelper.prepareProcessFormMapping(processId, activityId, connectedForm, generated);
        return generated;
    }

    public static Map<String, Map<String, String>> prepareProcessFormMapping(String processId, String id, String form, Map<String, Map<String, String>> generated) {
        String formId = FormGenerationUtils.findFormId(form, generated);
        generated = WorkflowUtils.addGenerated("Process Form", processId + "::" + id, formId, generated);
        return generated;
    }

    public static String getActivityId(String activityId) {
        if (activityId.equals("runProcess")) {
            activityId = "start";
        }
        return activityId;
    }
}

