/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.designer.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.joget.ai.designer.utils.GenerationUtils.FormGenerationUtils;
import org.joget.ai.designer.utils.GenerationUtils.ListGenerationUtils;
import org.joget.ai.designer.utils.GenerationUtils.XpdlGenerationUtils;
import org.joget.apps.app.model.AppDefinition;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.NodeList;

public class WorkflowUtils {
    public static Map<String, Map<String, String>> addGenerated(String type, String key, String value, Map<String, Map<String, String>> generated) {
        Map<String, String> mapping = generated.get(type);
        if (mapping == null) {
            mapping = new HashMap<String, String>();
        }
        mapping.put(key, value);
        generated.put(type, mapping);
        return generated;
    }

    public static Map<String, String> getGenerated(String type, Map<String, Map<String, String>> generated) {
        Map<String, String> mapping = generated.get(type);
        if (mapping == null) {
            mapping = new HashMap<String, String>();
        }
        return mapping;
    }

    public static String generateFormsAndLists(String jsonFormsAndLists, AppDefinition appDef, Map<String, Collection<String>> formActivityNamesMap, Map<String, Map<String, String>> generated) {
        String runProcessFormName = null;
        try {
            JSONObject jsonObject = new JSONObject(jsonFormsAndLists);
            for (String key : jsonObject.keySet()) {
                JSONObject formObject = jsonObject.getJSONObject(key);
                JSONObject form = formObject.getJSONObject("form");
                JSONObject propertiesObject = form.getJSONObject("properties");
                String tableName = propertiesObject.getString("tableName");
                String formId = propertiesObject.getString("id");
                JSONArray listArray = formObject.getJSONArray("list");
                ArrayList<String> columns = new ArrayList<String>();
                for (int j = 0; j < listArray.length(); ++j) {
                    columns.add(listArray.getString(j));
                }
                JSONArray activityNamesArray = formObject.getJSONArray("activity_names");
                ArrayList<String> activityNames = new ArrayList<String>();
                for (int k = 0; k < activityNamesArray.length(); ++k) {
                    if (activityNamesArray.getString(k).equals("start")) {
                        runProcessFormName = key;
                        continue;
                    }
                    activityNames.add(activityNamesArray.getString(k));
                }
                formActivityNamesMap.put(key, activityNames);
                FormGenerationUtils.generateForm(key, formId, tableName, form.toString(), generated, appDef);
                ListGenerationUtils.generateList(key, columns, generated, appDef);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return runProcessFormName;
    }

    public static Map<String, Map<String, String>> generateAndDeployXpdl(String xml, Map<String, Map<String, String>> generated, AppDefinition appDef, String runProcessFormName, Map<String, Collection<String>> formActivityNamesMap, NodeList activityList, NodeList transitionList, String processId) throws Exception {
        XpdlGenerationUtils generationUtils = new XpdlGenerationUtils(xml, appDef);
        generated = generationUtils.generateProcess(runProcessFormName, processId, generated, transitionList, activityList, formActivityNamesMap);
        generationUtils.deployProcesses(generated);
        return generated;
    }
}

