/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.designer.utils.GenerationUtils;

import java.util.Collection;
import java.util.Map;
import org.joget.ai.designer.utils.DbHelper;
import org.joget.ai.designer.utils.GenerationUtils.FormGenerationUtils;
import org.joget.ai.designer.utils.StringUtils;
import org.joget.ai.designer.utils.WorkflowUtils;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.generator.model.GeneratorPlugin;
import org.joget.plugin.base.PluginManager;

public class ListGenerationUtils {
    public static String findListId(String name, Map<String, Map<String, String>> generated) {
        String entityId = "";
        Map<String, String> generatedLists = generated.get("List");
        if (generatedLists != null && !generatedLists.isEmpty() && generatedLists.containsKey(name)) {
            entityId = generatedLists.get(name);
        }
        return entityId;
    }

    public static Map<String, Map<String, String>> generateList(String name, Collection<String> columns, Map<String, Map<String, String>> generated, AppDefinition appDef) {
        String id = StringUtils.nameToId(name);
        String entityFormId = FormGenerationUtils.findFormId(name, generated);
        PluginManager pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager");
        GeneratorPlugin listGenerator = (GeneratorPlugin)pluginManager.getPlugin("org.joget.plugin.enterprise.DatalistGenerator");
        if (listGenerator != null) {
            listGenerator.setAppDefinition(appDef);
            listGenerator.setFormId(entityFormId);
            listGenerator.setProperty("listId", (Object)id);
            listGenerator.setProperty("listName", (Object)name);
            Object columnsString = "";
            for (String c : columns) {
                if (!((String)columnsString).isEmpty()) {
                    columnsString = (String)columnsString + ";";
                }
                columnsString = (String)columnsString + StringUtils.nameToId(c);
            }
            listGenerator.setProperty("columns", columnsString);
            String listId = listGenerator.generate().getItemId();
            if (listId != null) {
                generated = WorkflowUtils.addGenerated("List", name, listId, generated);
                DbHelper.datafixDatalists(listId, appDef);
            }
        }
        return generated;
    }
}

