/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.designer.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joget.ai.designer.utils.DbHelper;
import org.joget.ai.designer.utils.StringUtils;
import org.joget.apps.app.dao.AppDefinitionDao;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.util.LogUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class ApplicationUtils {
    public static String isUniqueAppId(HttpServletRequest request, HttpServletResponse response) throws IOException, InterruptedException {
        AppDefinitionDao appDefinitionDao = (AppDefinitionDao)AppUtil.getApplicationContext().getBean("appDefinitionDao");
        String appId = request.getParameter("appId");
        Boolean isUnique = true;
        try {
            AppDefinition existingAppDefinition = (AppDefinition)appDefinitionDao.loadById(appId);
            if (existingAppDefinition != null) {
                isUnique = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JSONObject newAppIdJson = new JSONObject();
        newAppIdJson.put("isUnique", (Object)isUnique);
        return newAppIdJson.toString();
    }

    public static void captureAppId(String appId, String appName, JSONObject workflowDocument) throws IOException {
        try {
            if (StringUtils.isBlank(appId) || StringUtils.isBlank(appName)) {
                throw new Exception("AppId and App Name is required");
            }
            appId = appId.trim();
            appName = appName.trim();
            workflowDocument.put("app_id", (Object)appId);
            workflowDocument.put("app_name", (Object)appName);
            DbHelper.saveWorkflowCollection(workflowDocument);
        }
        catch (Exception e) {
            LogUtil.error((String)"ApplicationUtils", (Throwable)e, (String)"Capturing of ID to DB Failed");
        }
    }

    public static String getAppIds(HttpServletRequest request, HttpServletResponse response) throws IOException, InterruptedException {
        AppDefinitionDao appDefinitionDao = (AppDefinitionDao)AppUtil.getApplicationContext().getBean("appDefinitionDao");
        Collection appDefinitionList = appDefinitionDao.findLatestVersions(null, null, null, null, null, null, null);
        ArrayList<String> idList = new ArrayList<String>();
        for (AppDefinition appDefinition : appDefinitionList) {
            idList.add(appDefinition.getId());
        }
        JSONArray jsonArray = new JSONArray(idList);
        return jsonArray.toString();
    }

    public static String getAppVersions(HttpServletRequest request, HttpServletResponse response) throws IOException, InterruptedException {
        AppDefinitionDao appDefinitionDao = (AppDefinitionDao)AppUtil.getApplicationContext().getBean("appDefinitionDao");
        Collection appDefList = appDefinitionDao.findVersions(request.getParameter("_appId"), null, null, null, null);
        ArrayList<Long> versionList = new ArrayList<Long>();
        for (AppDefinition appDefinition : appDefList) {
            versionList.add(appDefinition.getVersion());
        }
        JSONArray jsonArray = new JSONArray(versionList);
        return jsonArray.toString();
    }
}

