/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.designer.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import org.joget.ai.designer.dto.FormDesignResponse;
import org.joget.ai.designer.model.ApiServiceConfig;
import org.joget.ai.designer.service.HttpClientProvider;
import org.joget.commons.util.LogUtil;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Service;

@Service
public class FormApiService {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final String baseUrl;
    private final String defaultApiKey;

    public FormApiService(String baseUrl, String defaultApiKey) {
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
        this.defaultApiKey = defaultApiKey;
    }

    public Try<FormDesignResponse> callFormDesign(String query, ApiServiceConfig config, List<String> imageBase64List) {
        return Try.of((CheckedFunction0 & Serializable)() -> {
            JSONObject req = new JSONObject();
            req.put("query", (Object)query);
            req.put("llm_model_class", (Object)config.modelClass);
            req.put("llm_model_name", (Object)config.modelName);
            req.put("api_key", (Object)this.resolveApiKey(config.apiKey));
            if (imageBase64List != null && !imageBase64List.isEmpty()) {
                req.put("image_base_64_list", (Object)new JSONArray((Collection)imageBase64List));
            } else {
                req.put("image_base_64_list", (Object)new JSONArray());
            }
            if ("Custom".equals(config.modelClass) && config.customLlmUrl != null && !config.customLlmUrl.isEmpty()) {
                req.put("custom_llm_url", (Object)config.customLlmUrl);
            }
            return new FormDesignResponse().parseResponse(this.sendJsonPost(this.baseUrl + "/api/v1/add_form_design", req), this.objectMapper);
        });
    }

    public Try<FormDesignResponse> callFormDesign(String query, ApiServiceConfig config, List<String> imageBase64List, Boolean returnOneForm) {
        return Try.of((CheckedFunction0 & Serializable)() -> {
            JSONObject req = new JSONObject();
            req.put("query", (Object)query);
            req.put("llm_model_class", (Object)config.modelClass);
            req.put("llm_model_name", (Object)config.modelName);
            req.put("api_key", (Object)this.resolveApiKey(config.apiKey));
            if (imageBase64List != null && !imageBase64List.isEmpty()) {
                req.put("image_base_64_list", (Object)new JSONArray((Collection)imageBase64List));
            } else {
                req.put("image_base_64_list", (Object)new JSONArray());
            }
            if ("Custom".equals(config.modelClass) && config.customLlmUrl != null && !config.customLlmUrl.isEmpty()) {
                req.put("custom_llm_url", (Object)config.customLlmUrl);
            }
            req.put("return_single_form", (Object)returnOneForm);
            return new FormDesignResponse().parseResponse(this.sendJsonPost(this.baseUrl + "/api/v1/add_form_design", req), this.objectMapper);
        });
    }

    public Try<FormDesignResponse> callProcessCorrection(String requestedChanges, ApiServiceConfig config, JSONObject designedForms, List<String> imageBase64List) {
        return Try.of((CheckedFunction0 & Serializable)() -> {
            JSONObject req = new JSONObject();
            req.put("llm_model_class", (Object)config.modelClass);
            req.put("llm_model_name", (Object)config.modelName);
            req.put("api_key", (Object)this.resolveApiKey(config.apiKey));
            if ("Custom".equals(config.modelClass) && config.customLlmUrl != null && !config.customLlmUrl.isEmpty()) {
                req.put("custom_llm_url", (Object)config.customLlmUrl);
            } else {
                req.put("custom_llm_url", (Object)"");
            }
            req.put("process_proposal", (Object)new JSONArray());
            req.put("forms", (Object)new JSONArray());
            req.put("participants", (Object)new JSONArray());
            req.put("transitions", (Object)"");
            req.put("designed_forms", (Object)designedForms);
            req.put("analysis_stage", (Object)"add_only_forms_design");
            req.put("requested_changes", (Object)new JSONArray().put((Object)requestedChanges));
            req.put("check_transitions", false);
            if (imageBase64List != null && !imageBase64List.isEmpty()) {
                req.put("image_base_64_list", (Object)new JSONArray((Collection)imageBase64List));
            } else {
                req.put("image_base_64_list", (Object)new JSONArray());
            }
            return new FormDesignResponse().parseResponse(this.sendJsonPost(this.baseUrl + "/api/v1/process_correction", req), this.objectMapper);
        });
    }

    private String sendJsonPost(String url, JSONObject body) throws Exception {
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(240L)).header("Content-Type", "application/json").header("Authorization", "Bearer " + this.resolveApiKey("")).POST(HttpRequest.BodyPublishers.ofString(body.toString())).build();
        HttpResponse<String> resp = HttpClientProvider.getClient().send(req, HttpResponse.BodyHandlers.ofString());
        if (resp.statusCode() >= 200 && resp.statusCode() < 300) {
            return resp.body();
        }
        String resBody = resp.body();
        String errorMessage = "Unknown error";
        try {
            JSONObject errorResponse = new JSONObject(resBody);
            errorMessage = errorResponse.optString("message", errorMessage);
        }
        catch (Exception e) {
            LogUtil.error((String)FormApiService.class.getName(), (Throwable)e, (String)"Failed to parse error response");
            errorMessage = resBody != null && !resBody.isEmpty() ? resBody : errorMessage;
        }
        throw new FormApiException("Non-2xx from " + url + ": " + resp.statusCode() + " " + errorMessage);
    }

    private String resolveApiKey(String override) {
        if (override != null && !override.isBlank()) {
            return override;
        }
        if (this.defaultApiKey != null && !this.defaultApiKey.isBlank()) {
            return this.defaultApiKey;
        }
        throw new FormApiException("No API key provided (neither override nor default available).");
    }

    public static class FormApiException
    extends RuntimeException {
        public FormApiException(String msg) {
            super(msg);
        }
    }
}

