/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.designer.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import org.joget.ai.designer.dto.AgentJogetResponse;
import org.joget.ai.designer.dto.AgentProposalResponse;
import org.joget.ai.designer.dto.AgentStructureResponse;
import org.joget.ai.designer.model.ApiServiceConfig;
import org.joget.ai.designer.service.HttpClientProvider;
import org.joget.commons.util.LogUtil;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Service;

@Service
public class AgentApiService {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final String baseUrl;
    private final String defaultApiKey;

    public AgentApiService(String baseUrl, String defaultApiKey) {
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
        this.defaultApiKey = defaultApiKey;
    }

    public Try<AgentProposalResponse> callAgentProposal(String query, ApiServiceConfig config) {
        return Try.of((CheckedFunction0 & Serializable)() -> {
            JSONObject req = new JSONObject();
            req.put("query", (Object)query);
            req.put("llm_model_class", (Object)config.modelClass);
            req.put("llm_model_name", (Object)config.modelName);
            req.put("api_key", (Object)this.resolveApiKey(config.apiKey));
            return new AgentProposalResponse().parseResponse(this.sendJsonPost(this.baseUrl + "/api/v1/agent_proposal", req), this.objectMapper);
        });
    }

    public Try<AgentStructureResponse> callAgentStructure(String query, ApiServiceConfig config, List<String> agentProposal) {
        return Try.of((CheckedFunction0 & Serializable)() -> {
            JSONObject req = new JSONObject();
            req.put("query", (Object)query);
            req.put("llm_model_class", (Object)config.modelClass);
            req.put("llm_model_name", (Object)config.modelName);
            req.put("api_key", (Object)this.resolveApiKey(config.apiKey));
            req.put("agent_proposal", (Object)new JSONArray((Collection)agentProposal));
            return new AgentStructureResponse().parseResponse(this.sendJsonPost(this.baseUrl + "/api/v1/agent_structure", req), this.objectMapper);
        });
    }

    public Try<AgentJogetResponse> callStructureToJogetAgent(String query, ApiServiceConfig config, JSONObject agentStructure) {
        return Try.of((CheckedFunction0 & Serializable)() -> {
            JSONObject req = new JSONObject();
            req.put("query", (Object)query);
            req.put("llm_model_class", (Object)config.modelClass);
            req.put("llm_model_name", (Object)config.modelName);
            req.put("api_key", (Object)this.resolveApiKey(config.apiKey));
            req.put("agent_structure", (Object)agentStructure);
            return new AgentJogetResponse().parseResponse(this.sendJsonPost(this.baseUrl + "/api/v1/agent_structure_to_joget_agent", req), this.objectMapper);
        });
    }

    private String sendJsonPost(String url, JSONObject body) throws Exception {
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(240L)).header("Content-Type", "application/json").header("Authorization", "Bearer " + this.resolveApiKey("")).POST(HttpRequest.BodyPublishers.ofString(body.toString())).build();
        LogUtil.info((String)AgentApiService.class.getName(), (String)("POST " + url + " => " + body));
        HttpResponse<String> resp = HttpClientProvider.getClient().send(req, HttpResponse.BodyHandlers.ofString());
        LogUtil.info((String)AgentApiService.class.getName(), (String)("Response status= " + resp.statusCode() + "body=" + resp.body()));
        if (resp.statusCode() >= 200 && resp.statusCode() < 300) {
            return resp.body();
        }
        String resBody = resp.body();
        String errorMessage = "Unknown error";
        try {
            JSONObject errorResponse = new JSONObject(resBody);
            errorMessage = errorResponse.optString("message", errorMessage);
        }
        catch (Exception e) {
            LogUtil.error((String)AgentApiService.class.getName(), (Throwable)e, (String)"Failed to parse error response");
            errorMessage = resBody != null && !body.isEmpty() ? resBody : errorMessage;
        }
        throw new AgentApiException("Non-2xx from " + url + ": " + resp.statusCode() + " " + errorMessage);
    }

    private String resolveApiKey(String override) {
        if (override != null && !override.isBlank()) {
            return override;
        }
        if (this.defaultApiKey != null && !this.defaultApiKey.isBlank()) {
            return this.defaultApiKey;
        }
        throw new AgentApiException("No API key provided (neither override nor default available).");
    }

    public static class AgentApiException
    extends RuntimeException {
        public AgentApiException(String msg) {
            super(msg);
        }
    }
}

