/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.designer.feature;

import com.github.underscore.lodash.U;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.joget.ai.designer.feature.UiFeatureAbstract;
import org.joget.apps.app.dao.FormDefinitionDao;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.model.FormDefinition;
import org.joget.apps.app.model.UserviewDefinition;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.form.service.FormService;
import org.joget.apps.form.service.FormUtil;
import org.joget.apps.userview.service.UserviewService;
import org.joget.plugin.base.PluginManager;
import org.joget.plugin.property.service.PropertyUtil;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GenerationPage
extends UiFeatureAbstract {
    public String previewXpdl(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String xpdl = request.getParameter("xpdl");
        JSONObject jsonDef = new JSONObject();
        String xpdlJson = U.xmlToJson((String)xpdl);
        jsonDef.put("xpdl", (Object)new JSONObject(xpdlJson));
        String processId = "";
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(xpdl.getBytes(StandardCharsets.UTF_8));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(input);
            document.getDocumentElement().normalize();
            NodeList workflowProcessList = document.getElementsByTagName("WorkflowProcess");
            for (int i = 0; i < workflowProcessList.getLength(); ++i) {
                Node workflowProcessNode = workflowProcessList.item(i);
                if (workflowProcessNode.getNodeType() != 1) continue;
                Element workflowProcessElement = (Element)workflowProcessNode;
                processId = workflowProcessElement.getAttribute("Id");
            }
        }
        catch (Exception input) {
            // empty catch block
        }
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("processId", processId);
        model.put("json", jsonDef.toString());
        model.put("contextPath", request.getContextPath());
        model.put("buildNumber", "435fc51");
        PluginManager pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager");
        String content = "";
        content = pluginManager.getPluginFreeMarkerTemplate(model, AiDesigner.getClassName(), "/resources/feature/GenerationPage/visualization_templates/pviewer.ftl", null);
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String previewForm(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PluginManager pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager");
        String content = "";
        String json = request.getParameter("json");
        try {
            FormDefinitionDao formDefinitionDao;
            FormDefinition formDef;
            FormUtil.setProcessedFormJson((String)json);
            UserviewService userviewService = (UserviewService)AppUtil.getApplicationContext().getBean("userviewService");
            UserviewDefinition userviewDefinition = userviewService.getDefaultUserview();
            AppDefinition appDef = userviewDefinition.getAppDefinition();
            String tempJson = json;
            if ((tempJson.contains("%%%%") || tempJson.contains("****SECURE_VALUE****-")) && (formDef = (formDefinitionDao = (FormDefinitionDao)AppUtil.getApplicationContext().getBean("formDefinitionDao")).loadById("", appDef)) != null) {
                tempJson = PropertyUtil.propertiesJsonStoreProcessing((String)formDef.getJson(), (String)tempJson);
            }
            FormService formService = (FormService)AppUtil.getApplicationContext().getBean("formService");
            String elementHtml = formService.previewElement(tempJson, false);
            HashMap<String, String> model = new HashMap<String, String>();
            model.put("elementTemplate", elementHtml);
            model.put("contextPath", request.getContextPath());
            model.put("buildNumber", "435fc51");
            content = pluginManager.getPluginFreeMarkerTemplate(model, AiDesigner.getClassName(), "/resources/feature/GenerationPage/visualization_templates/fviewer.ftl", null);
        }
        finally {
            FormUtil.clearProcessedFormJson();
        }
        return content;
    }
}

