/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.designer.feature;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joget.ai.designer.feature.UiFeatureAbstract;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.spring.model.Setting;
import org.joget.commons.util.LogUtil;
import org.joget.commons.util.SetupManager;
import org.joget.commons.util.StringUtil;
import org.joget.plugin.property.service.PropertyUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class ConfigurationPage
extends UiFeatureAbstract {
    public String createNewAiService(HttpServletRequest request) throws IOException {
        JSONObject result = new JSONObject();
        JSONObject createData = new JSONObject(request.getParameter("_createNewAiServiceData"));
        SetupManager setupManager = (SetupManager)AppUtil.getApplicationContext().getBean("setupManager");
        Setting setting = setupManager.getSettingByProperty("MY_AI_SERVICES");
        if (setting == null) {
            setting = new Setting();
            setting.setProperty("MY_AI_SERVICES");
            setting.setValue("{\"className\": \"\", \"properties\": {\"myAiServices\": []}}");
            setupManager.saveSetting(setting);
        }
        String settingValue = setupManager.getSettingValue("MY_AI_SERVICES");
        JSONObject decrypted = new JSONObject(StringUtil.decryptContent((String)settingValue));
        JSONObject decyptedRefined = this.redefineApiKeyValues(decrypted.toString());
        JSONObject decyptedRefinedProperties = decyptedRefined.getJSONObject("properties");
        JSONArray servicesArray = decyptedRefinedProperties.getJSONArray("myAiServices");
        String newServiceName = createData.getString("aiServiceName");
        for (int i = 0; i < servicesArray.length(); ++i) {
            JSONObject existingService = servicesArray.getJSONObject(i);
            if (!existingService.getString("aiServiceName").equals(newServiceName)) continue;
            result.put("success", false);
            result.put("message", (Object)"AI service name already exists");
            return result.toString();
        }
        JSONObject newService = new JSONObject();
        String modelClass = createData.getString("modelClass");
        if (modelClass.equals("AWS Bedrock")) {
            JSONObject apiKey = new JSONObject();
            String awsAccessKeyIdValue = createData.getString("aws_access_key_id");
            String awsSecretAccessKeyValue = createData.getString("aws_secret_access_key");
            apiKey.put("aws_access_key_id", awsAccessKeyIdValue.isEmpty() ? "" : "%%%%" + awsAccessKeyIdValue + "%%%%");
            apiKey.put("aws_secret_access_key", awsSecretAccessKeyValue.isEmpty() ? "" : "%%%%" + awsSecretAccessKeyValue + "%%%%");
            apiKey.put("aws_session_token", (Object)createData.getString("aws_session_token"));
            newService.put("apiKey", (Object)apiKey);
        } else {
            String apiKeyValue = createData.optString("apiKey");
            newService.put("apiKey", apiKeyValue.isEmpty() ? "" : "%%%%" + apiKeyValue + "%%%%");
        }
        newService.put("modelName", (Object)createData.getString("modelName"));
        newService.put("customLlmUrl", (Object)createData.getString("customLlmUrl"));
        newService.put("modelClass", (Object)modelClass);
        newService.put("aiServiceName", (Object)newServiceName);
        newService.put("customModelName", (Object)createData.getString("customModelName"));
        newService.put("using", false);
        servicesArray.put((Object)newService);
        decyptedRefinedProperties.put("myAiServices", (Object)servicesArray);
        decyptedRefined.put("properties", (Object)decyptedRefinedProperties);
        String updatedSetting = PropertyUtil.propertiesJsonStoreProcessing((String)decrypted.toString(), (String)decyptedRefined.toString());
        setting.setValue(updatedSetting);
        setupManager.saveSetting(setting);
        result.put("success", true);
        result.put("myAiServices", (Object)new JSONObject(PropertyUtil.propertiesJsonLoadProcessing((String)setting.getValue())));
        return result.toString();
    }

    public JSONObject redefineApiKeyValues(String myAiServicesString) throws IOException {
        JSONObject myAiServicesObject = new JSONObject(myAiServicesString);
        JSONObject properties = myAiServicesObject.getJSONObject("properties");
        JSONArray myAiServicesArray = properties.getJSONArray("myAiServices");
        if (myAiServicesArray.isEmpty()) {
            return myAiServicesObject;
        }
        for (int i = 0; i < myAiServicesArray.length(); ++i) {
            Object apiKey;
            JSONObject myAiService = myAiServicesArray.getJSONObject(i);
            if (myAiService.getString("modelClass").equals("AWS Bedrock")) {
                apiKey = myAiService.getJSONObject("apiKey");
                apiKey.put("aws_access_key_id", (Object)("%%%%" + apiKey.getString("aws_access_key_id") + "%%%%"));
                apiKey.put("aws_secret_access_key", (Object)("%%%%" + apiKey.getString("aws_secret_access_key") + "%%%%"));
                myAiService.put("apiKey", apiKey);
                continue;
            }
            apiKey = myAiService.getString("apiKey");
            Object redefinedApiKey = ((String)apiKey).isEmpty() ? "" : "%%%%" + (String)apiKey + "%%%%";
            myAiService.put("apiKey", redefinedApiKey);
        }
        properties.put("myAiServices", (Object)myAiServicesArray);
        myAiServicesObject.put("properties", (Object)properties);
        return myAiServicesObject;
    }

    public String revokeMyAiService(HttpServletRequest request) throws IOException {
        JSONObject result = new JSONObject();
        String serviceName = request.getParameter("_myAiServiceName");
        if (serviceName == null || serviceName.isEmpty()) {
            result.put("success", false);
            result.put("error", (Object)"Service name is missing");
            return result.toString();
        }
        SetupManager setupManager = (SetupManager)AppUtil.getApplicationContext().getBean("setupManager");
        Setting myAiSetting = setupManager.getSettingByProperty("MY_AI_SERVICES");
        if (myAiSetting == null) {
            result.put("success", false);
            result.put("error", (Object)"No AI services found");
            return result.toString();
        }
        JSONObject myAiServicesObj = new JSONObject(myAiSetting.getValue());
        JSONObject myAiProps = myAiServicesObj.getJSONObject("properties");
        JSONArray myAiServicesArray = myAiProps.optJSONArray("myAiServices");
        boolean found = false;
        if (myAiServicesArray != null) {
            for (int i = 0; i < myAiServicesArray.length(); ++i) {
                JSONObject aiService = myAiServicesArray.getJSONObject(i);
                if (!serviceName.equals(aiService.optString("aiServiceName"))) continue;
                myAiServicesArray.remove(i);
                found = true;
                break;
            }
        }
        if (!found) {
            result.put("success", false);
            result.put("error", (Object)"Service not found");
            return result.toString();
        }
        myAiProps.put("myAiServices", (Object)myAiServicesArray);
        myAiServicesObj.put("properties", (Object)myAiProps);
        myAiSetting.setValue(myAiServicesObj.toString());
        setupManager.saveSetting(myAiSetting);
        Setting currentAiSetting = setupManager.getSettingByProperty("CURRENT_AI_SERVICE");
        if (currentAiSetting != null) {
            JSONObject currentObj = new JSONObject(currentAiSetting.getValue());
            JSONObject currentProps = currentObj.getJSONObject("properties");
            String currentServiceName = currentProps.optString("aiService");
            if (myAiServicesArray.length() == 0 || serviceName.equals(currentServiceName)) {
                currentProps.put("aiService", (Object)"");
                currentProps.put("modelClass", (Object)"");
                currentProps.put("modelName", (Object)"");
                currentObj.put("properties", (Object)currentProps);
                currentAiSetting.setValue(currentObj.toString());
                setupManager.saveSetting(currentAiSetting);
            }
        }
        result.put("success", true);
        result.put("myAiServices", (Object)new JSONObject(PropertyUtil.propertiesJsonLoadProcessing((String)myAiSetting.getValue())));
        return result.toString();
    }

    public boolean matchingMaskedValues(Integer index, JSONArray jsonArray, String modelClass, String fieldSlug, String maskedValue) {
        boolean isMatching = false;
        for (int i = 0; i < jsonArray.length(); ++i) {
            String apiKey;
            if (i != index) continue;
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (modelClass.equals("Custom")) {
                apiKey = jsonObject.getString("apiKey");
                if (!apiKey.equals(maskedValue)) continue;
                isMatching = true;
                continue;
            }
            if (modelClass.equals("AWS Bedrock")) {
                apiKey = jsonObject.getJSONObject("apiKey");
                if (!apiKey.getString(fieldSlug).equals(maskedValue)) continue;
                isMatching = true;
                continue;
            }
            apiKey = jsonObject.getString("apiKey");
            if (!apiKey.equals(maskedValue)) continue;
            isMatching = true;
        }
        return isMatching;
    }

    public String editMyAiService(HttpServletRequest request) throws IOException {
        JSONObject result = new JSONObject();
        JSONObject editData = new JSONObject(request.getParameter("_editMyAiServiceData"));
        String serviceName = request.getParameter("_myAiServiceName");
        String modelClass = request.getParameter("_modelClass");
        SetupManager setupManager = (SetupManager)AppUtil.getApplicationContext().getBean("setupManager");
        Setting setting = setupManager.getSettingByProperty("MY_AI_SERVICES");
        if (setting == null) {
            result.put("success", false);
            result.put("error", (Object)"No services found");
            return result.toString();
        }
        String settingValue = setupManager.getSettingValue("MY_AI_SERVICES");
        JSONObject decrypted = new JSONObject(StringUtil.decryptContent((String)settingValue));
        JSONObject decyptedRefined = this.redefineApiKeyValues(decrypted.toString());
        JSONObject decyptedRefinedProperties = decyptedRefined.getJSONObject("properties");
        JSONArray servicesArray = decyptedRefinedProperties.getJSONArray("myAiServices");
        JSONObject masked = new JSONObject(PropertyUtil.propertiesJsonLoadProcessing((String)settingValue));
        JSONArray maskedMyAiServices = masked.getJSONObject("properties").getJSONArray("myAiServices");
        block8: for (int i = 0; i < servicesArray.length(); ++i) {
            JSONObject service = servicesArray.getJSONObject(i);
            if (!serviceName.equals(service.getString("aiServiceName"))) continue;
            switch (modelClass) {
                case "Custom": {
                    service.put("customLlmUrl", (Object)editData.getString("customLlmUrl"));
                    service.put("customModelName", (Object)editData.getString("customModelName"));
                    if (this.matchingMaskedValues(i, maskedMyAiServices, modelClass, "apiKey", editData.getString("apiKey"))) break block8;
                    String apiKey = editData.getString("apiKey");
                    service.put("apiKey", apiKey.isEmpty() ? "" : "%%%%" + apiKey + "%%%%");
                    break;
                }
                case "AWS Bedrock": {
                    JSONObject apiKey = service.optJSONObject("apiKey");
                    if (apiKey == null) {
                        apiKey = new JSONObject();
                    }
                    if (!this.matchingMaskedValues(i, maskedMyAiServices, modelClass, "aws_access_key_id", editData.getString("aws_access_key_id"))) {
                        String awsAccessKeyIdValue = editData.getString("aws_access_key_id");
                        apiKey.put("aws_access_key_id", awsAccessKeyIdValue.isEmpty() ? "" : "%%%%" + awsAccessKeyIdValue + "%%%%");
                    }
                    if (!this.matchingMaskedValues(i, maskedMyAiServices, modelClass, "aws_secret_access_key", editData.getString("aws_secret_access_key"))) {
                        String awsSecretAccessKeyValue = editData.getString("aws_secret_access_key");
                        apiKey.put("aws_secret_access_key", awsSecretAccessKeyValue.isEmpty() ? "" : "%%%%" + awsSecretAccessKeyValue + "%%%%");
                    }
                    apiKey.put("aws_session_token", (Object)editData.getString("aws_session_token"));
                    service.put("apiKey", (Object)apiKey);
                    break;
                }
                default: {
                    if (this.matchingMaskedValues(i, maskedMyAiServices, modelClass, "apiKey", editData.getString("apiKey"))) break block8;
                    String apiKeyValue = editData.getString("apiKey");
                    service.put("apiKey", apiKeyValue.isEmpty() ? "" : "%%%%" + apiKeyValue + "%%%%");
                    break;
                }
            }
            break;
        }
        decyptedRefinedProperties.put("myAiServices", (Object)servicesArray);
        decyptedRefined.put("properties", (Object)decyptedRefinedProperties);
        String updatedSetting = PropertyUtil.propertiesJsonStoreProcessing((String)decrypted.toString(), (String)decyptedRefined.toString());
        setting.setValue(updatedSetting);
        setupManager.saveSetting(setting);
        result.put("success", true);
        result.put("myAiServices", (Object)new JSONObject(PropertyUtil.propertiesJsonLoadProcessing((String)setting.getValue())));
        return result.toString();
    }

    public String saveApiServerConfig(HttpServletRequest request) throws IOException {
        JSONObject result = new JSONObject();
        SetupManager setupManager = (SetupManager)AppUtil.getApplicationContext().getBean("setupManager");
        Setting setting = setupManager.getSettingByProperty("API_SERVER_CONFIG");
        if (setting == null) {
            setting = new Setting();
            setting.setProperty("API_SERVER_CONFIG");
            setting.setValue("{\"className\": \"\", \"properties\": {\"apiServerUrl\": \"\", \"apiServerKey\": \"\"}}");
            setupManager.saveSetting(setting);
        }
        String settingValue = setupManager.getSettingValue("API_SERVER_CONFIG");
        JSONObject decrypted = new JSONObject(StringUtil.decryptContent((String)settingValue));
        JSONObject decyptedRefined = this.redefineApiServerConfig(decrypted.toString());
        JSONObject decryptedRefinedProperties = decyptedRefined.getJSONObject("properties");
        String newUrl = request.getParameter("_apiServerUrl");
        String newKey = request.getParameter("_apiServerKey");
        JSONObject masked = new JSONObject(PropertyUtil.propertiesJsonLoadProcessing((String)settingValue));
        String maskedApiServerKey = masked.getJSONObject("properties").optString("apiServerKey", "");
        decryptedRefinedProperties.put("apiServerUrl", (Object)newUrl);
        if (!maskedApiServerKey.equals(newKey)) {
            decryptedRefinedProperties.put("apiServerKey", (Object)("%%%%" + newKey + "%%%%"));
        }
        decyptedRefined.put("properties", (Object)decryptedRefinedProperties);
        String updatedSetting = PropertyUtil.propertiesJsonStoreProcessing((String)decrypted.toString(), (String)decyptedRefined.toString());
        setting.setValue(updatedSetting);
        setupManager.saveSetting(setting);
        result.put("success", true);
        result.put("apiServerConfig", (Object)new JSONObject(PropertyUtil.propertiesJsonLoadProcessing((String)setting.getValue())));
        return result.toString();
    }

    public JSONObject redefineApiServerConfig(String apiServerConfigString) throws IOException {
        JSONObject apiServerConfigObject = new JSONObject(apiServerConfigString);
        JSONObject properties = apiServerConfigObject.getJSONObject("properties");
        properties.put("apiServerKey", (Object)("%%%%" + properties.getString("apiServerKey") + "%%%%"));
        apiServerConfigObject.put("properties", (Object)properties);
        return apiServerConfigObject;
    }

    public String loadApiServerConfig() throws IOException {
        SetupManager setupManager = (SetupManager)AppUtil.getApplicationContext().getBean("setupManager");
        Setting setting = setupManager.getSettingByProperty("API_SERVER_CONFIG");
        JSONObject result = new JSONObject();
        result.put("success", true);
        if (setting == null) {
            JSONObject apiCredentials = new JSONObject();
            apiCredentials.put("apiServerUrl", (Object)AppPluginUtil.getMessage((String)"aiag.defaultApiServerUrl", (String)AiDesigner.getClassName(), (String)"message/ai/AiDesigner"));
            apiCredentials.put("apiServerKey", (Object)"");
            JSONObject apiServerConfig = new JSONObject();
            apiServerConfig.put("properties", (Object)apiCredentials);
            result.put("apiServerConfig", (Object)apiServerConfig);
        } else {
            result.put("apiServerConfig", (Object)new JSONObject(PropertyUtil.propertiesJsonLoadProcessing((String)setting.getValue())));
        }
        return result.toString();
    }

    public String saveCurrentAiService(HttpServletRequest request) throws IOException {
        JSONObject result = new JSONObject();
        SetupManager setupManager = (SetupManager)AppUtil.getApplicationContext().getBean("setupManager");
        try {
            JSONArray servicesArray;
            JSONObject currentObj;
            JSONObject currentProps;
            String currentServiceName = request.getParameter("_currentAiService");
            String modelClass = request.getParameter("_modelClass");
            String modelName = request.getParameter("_modelName");
            if (currentServiceName == null || currentServiceName.isEmpty()) {
                return new JSONObject().put("error", (Object)"Missing required parameter: _currentAiService").toString();
            }
            Setting currentSetting = setupManager.getSettingByProperty("CURRENT_AI_SERVICE");
            if (currentSetting == null) {
                currentSetting = new Setting();
                currentSetting.setProperty("CURRENT_AI_SERVICE");
                currentSetting.setValue("{\"className\": \"\", \"properties\": {\"aiService\": \"\", \"modelClass\": \"\", \"modelName\": \"\"}}");
            }
            if ((currentProps = (currentObj = new JSONObject(currentSetting.getValue())).optJSONObject("properties")) == null) {
                currentProps = new JSONObject();
            }
            currentProps.put("aiService", (Object)currentServiceName);
            currentProps.put("modelClass", (Object)(modelClass != null ? modelClass : ""));
            currentProps.put("modelName", (Object)(modelName != null ? modelName : ""));
            currentObj.put("properties", (Object)currentProps);
            currentSetting.setValue(currentObj.toString());
            setupManager.saveSetting(currentSetting);
            result.put("success", true);
            result.put("currentAiService", (Object)new JSONObject(PropertyUtil.propertiesJsonLoadProcessing((String)currentSetting.getValue())));
            Setting servicesSetting = setupManager.getSettingByProperty("MY_AI_SERVICES");
            if (servicesSetting == null) {
                result.put("myAiServices", (Object)new JSONObject());
                return result.toString();
            }
            JSONObject servicesObj = new JSONObject(servicesSetting.getValue());
            JSONObject servicesProps = servicesObj.optJSONObject("properties");
            JSONArray jSONArray = servicesArray = servicesProps != null ? servicesProps.optJSONArray("myAiServices") : null;
            if (servicesArray == null) {
                result.put("myAiServices", (Object)new JSONObject());
                return result.toString();
            }
            for (int i = 0; i < servicesArray.length(); ++i) {
                JSONObject service = servicesArray.getJSONObject(i);
                service.put("using", currentServiceName.equals(service.optString("aiServiceName")));
            }
            servicesSetting.setValue(servicesObj.toString());
            setupManager.saveSetting(servicesSetting);
            result.put("myAiServices", (Object)new JSONObject(PropertyUtil.propertiesJsonLoadProcessing((String)servicesSetting.getValue())));
        }
        catch (Exception e) {
            result = new JSONObject();
            result.put("success", false);
            result.put("error", (Object)("Failed to save current AI service: " + e.getMessage()));
        }
        return result.toString();
    }

    public String retrieveNewAiServiceFormFields() throws IOException {
        SetupManager setupManager = (SetupManager)AppUtil.getApplicationContext().getBean("setupManager");
        String settingValue = setupManager.getSettingValue("API_SERVER_CONFIG");
        if (settingValue == null || settingValue.isEmpty()) {
            return "{\"error\": \"API server not configured\"}";
        }
        try {
            JSONObject settingValueDecrypted = new JSONObject(StringUtil.decryptContent((String)settingValue));
            JSONObject properties = settingValueDecrypted.getJSONObject("properties");
            String apiServerUrl = properties.getString("apiServerUrl");
            String apiServerKey = properties.getString("apiServerKey");
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest httpRequest = HttpRequest.newBuilder().GET().uri(URI.create(apiServerUrl + "/api/v1/available_models")).header("accept", "application/json").header("Authorization", apiServerKey).build();
            HttpResponse<String> httpResponse = client.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            String translatedJson = AppPluginUtil.getMessage((String)httpResponse.body(), (String)AiDesigner.getClassName(), (String)"message/ai/AiDesigner");
            return translatedJson.replaceAll("^@@|@@$", "");
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClass().getName(), (Throwable)e, (String)"Failed to retrieve AI service form fields");
            return "{\"error\": \"Failed to retrieve form fields\"}";
        }
    }

    public String validateApiServerUrl(HttpServletRequest request) throws IOException {
        String url = request.getParameter("_apiServerUrl");
        try {
            HttpClient client = HttpClient.newBuilder().build();
            HttpRequest httpRequest = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString("")).uri(URI.create(url + "/health-check")).header("accept", "application/json").timeout(Duration.ofSeconds(30L)).build();
            HttpResponse<String> httpResponse = client.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            return httpResponse.statusCode() == 200 ? "true" : "false";
        }
        catch (Exception e) {
            LogUtil.error((String)AiDesigner.getClassName(), (Throwable)e, (String)("Failed to validate API server URL: " + url));
            return "false";
        }
    }

    public String validateApiServerKey(HttpServletRequest request) throws IOException {
        SetupManager setupManager = (SetupManager)AppUtil.getApplicationContext().getBean("setupManager");
        Setting setting = setupManager.getSettingByProperty("API_SERVER_CONFIG");
        String newApiKey = request.getParameter("_apiServerKey");
        String apiServerUrl = request.getParameter("_apiServerUrl");
        boolean isValid = false;
        if (setting != null) {
            try {
                String configValue = PropertyUtil.propertiesJsonLoadProcessing((String)setting.getValue());
                JSONObject configObj = new JSONObject(configValue);
                JSONObject properties = configObj.getJSONObject("properties");
                String storedKey = properties.getString("apiServerKey");
                if (storedKey.equals("%%%%" + newApiKey + "%%%%")) {
                    return "true";
                }
            }
            catch (Exception e) {
                LogUtil.error((String)AiDesigner.getClassName(), (Throwable)e, (String)"Failed to load API key config.");
            }
        }
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest httpRequest = HttpRequest.newBuilder().GET().uri(URI.create(apiServerUrl + "/api/v1/available_models")).header("accept", "application/json").header("Authorization", newApiKey).build();
            HttpResponse<String> httpResponse = client.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            isValid = httpResponse.statusCode() == 200;
        }
        catch (Exception e) {
            LogUtil.error((String)AiDesigner.getClassName(), (Throwable)e, (String)"Failed to validate API key via HTTP.");
        }
        return isValid ? "true" : "false";
    }

    public String updateMyPiiMaskingRules(HttpServletRequest request, HttpServletResponse response) throws IOException {
        JSONObject result = new JSONObject();
        JSONObject newMyPiiMaskingRulesConfig = new JSONObject(request.getParameter("newMyPiiMaskingRulesConfig"));
        SetupManager setupManager = (SetupManager)AppUtil.getApplicationContext().getBean("setupManager");
        Setting setting = setupManager.getSettingByProperty("MY_PII_MASKING_RULES_CONFIG");
        String settingValue = setupManager.getSettingValue("MY_PII_MASKING_RULES_CONFIG");
        String myPiiMaskingRulesString = settingValue.toString();
        JSONObject myPiiMaskingRulesObject = new JSONObject(myPiiMaskingRulesString);
        JSONObject properties = myPiiMaskingRulesObject.getJSONObject("properties");
        JSONObject properties2 = newMyPiiMaskingRulesConfig.getJSONObject("properties");
        JSONArray myPiiMaskingRulesArray2 = properties2.getJSONArray("myPiiMaskingRules");
        properties.put("myPiiMaskingRules", (Object)myPiiMaskingRulesArray2);
        myPiiMaskingRulesObject.put("properties", (Object)properties);
        myPiiMaskingRulesString = PropertyUtil.propertiesJsonStoreProcessing((String)myPiiMaskingRulesString, (String)myPiiMaskingRulesObject.toString(4));
        setting.setValue(myPiiMaskingRulesString);
        setupManager.saveSetting(setting);
        result.put("success", true);
        result.put("myPiiMaskingRules", (Object)new JSONObject(PropertyUtil.propertiesJsonLoadProcessing((String)setting.getValue())));
        return result.toString();
    }
}

