/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.designer.feature;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.websocket.Session;
import org.joget.ai.designer.feature.AgentInjectorPopUp;
import org.joget.apps.app.model.UiHtmlInjectorPluginAbstract;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.util.LogUtil;
import org.joget.plugin.base.PluginManager;
import org.joget.plugin.base.PluginWebSocket;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseInjectorPopUp<TState extends BaseConversationState>
extends UiHtmlInjectorPluginAbstract
implements PluginWebSocket {
    protected static ScheduledExecutorService pingScheduler = Executors.newScheduledThreadPool(1);
    private static final AtomicInteger WORKER_INDEX = new AtomicInteger(0);
    protected ExecutorService executor;
    protected static final Set<Session> sessions = new CopyOnWriteArraySet<Session>();
    protected static final int MAX_BUFFER_SIZE = 0x200000;

    public abstract String getName();

    public abstract String getVersion();

    public abstract String getDescription();

    public abstract String[] getInjectUrlPatterns();

    protected abstract String getTemplatePath();

    protected abstract String[] getSteps();

    protected abstract JSONArray getActions();

    protected abstract TState createState();

    protected abstract void handleInitMessage(Session var1, JSONObject var2);

    protected abstract void handlePipelineStep(Session var1, int var2, TState var3);

    public String getHtml(HttpServletRequest request) {
        PluginManager pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("contextPath", request.getContextPath());
        data.put("debug", "true".equalsIgnoreCase(System.getenv("debug")));
        return pluginManager.getPluginFreeMarkerTemplate(data, this.getClassName(), this.getTemplatePath(), null);
    }

    public void onOpen(Session session) {
        try {
            session.setMaxTextMessageBufferSize(0x200000);
            session.setMaxBinaryMessageBufferSize(0x200000);
            if (this.executor == null || this.executor.isShutdown()) {
                WORKER_INDEX.set(0);
                this.executor = Executors.newCachedThreadPool(r -> {
                    Thread t = new Thread(r);
                    t.setName("Base-Injector-Worker-" + WORKER_INDEX.getAndIncrement());
                    return t;
                });
                LogUtil.info((String)this.getClassName(), (String)"Executor service initialized for WebSocket handling.");
            }
            sessions.add(session);
            LogUtil.info((String)this.getClassName(), (String)("WebSocket connected. Session ID: " + session.getId()));
            if (pingScheduler == null || pingScheduler.isShutdown()) {
                pingScheduler = Executors.newSingleThreadScheduledExecutor(r -> {
                    Thread t = new Thread(r);
                    t.setName("Base-Injector-Ping-0");
                    return t;
                });
            }
            pingScheduler.scheduleAtFixedRate(() -> {
                try {
                    if (session.isOpen()) {
                        session.getAsyncRemote().sendPing(ByteBuffer.wrap(new byte[0]));
                        LogUtil.debug((String)this.getClassName(), (String)("Ping sent for session: " + session.getId()));
                    }
                }
                catch (IOException e) {
                    LogUtil.error((String)this.getClassName(), (Throwable)e, (String)("Ping failed for session: " + session.getId()));
                }
            }, 1L, 240L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"onOpen Error");
        }
    }

    public void onClose(Session session) {
        try {
            sessions.remove(session);
            if (sessions.isEmpty() && this.executor != null) {
                this.executor.shutdown();
                this.executor = null;
                pingScheduler.shutdown();
                pingScheduler = null;
                LogUtil.info((String)this.getClassName(), (String)"All WebSocket sessions closed, shutting down executor.");
            }
            LogUtil.info((String)this.getClassName(), (String)("WebSocket disconnected. Session ID: " + session.getId()));
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"onClose Error");
        }
    }

    public void onError(Session session, Throwable throwable) {
        LogUtil.error((String)this.getClassName(), (Throwable)throwable, (String)("WebSocket Error for session: " + session.getId()));
        try {
            Helper.sendErrorMessage(session, "Connection error occurred. Please try again.");
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)("Error sending error message to session: " + session.getId()));
            sessions.remove(session);
        }
    }

    public void onMessage(String message, Session session) {
    }

    public boolean isIncludeForAjaxThemePageSwitching() {
        return false;
    }

    public static class Helper {
        public static void sendMessage(Session session, String message) {
            try {
                if (session.isOpen()) {
                    session.getBasicRemote().sendText(message);
                }
            }
            catch (IOException e) {
                LogUtil.error((String)AgentInjectorPopUp.class.getCanonicalName(), (Throwable)e, (String)("Error sending message to session: " + session.getId()));
            }
        }

        public static void sendErrorMessage(Session session, String errorMessage) {
            try {
                JSONObject error = new JSONObject();
                error.put("type", (Object)"error");
                error.put("message", (Object)errorMessage);
                Helper.sendMessage(session, error.toString());
            }
            catch (Exception e) {
                LogUtil.error((String)AgentInjectorPopUp.class.getCanonicalName(), (Throwable)e, (String)"Error sending error message");
            }
        }

        public static JSONArray actionsForStep(int step, int maxSteps, JSONArray customActions) {
            JSONArray actions = new JSONArray();
            if (step >= 1 && step < maxSteps) {
                actions.putAll(customActions);
            }
            actions.put((Object)"restart");
            return actions;
        }

        public static String stepMessage(String type, Object content, int step, int maxSteps, JSONArray customActions, Object extra) {
            JSONObject o = new JSONObject();
            o.put("type", (Object)type);
            o.put("content", content);
            o.put("step", step);
            o.put("actions", (Object)Helper.actionsForStep(step, maxSteps, customActions));
            if (extra != null) {
                o.put("extra", extra);
            }
            return o.toString();
        }
    }

    protected static class BaseConversationState {
        protected int step = 0;
        protected String query = null;

        protected BaseConversationState() {
        }
    }
}

