/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.designer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joget.ai.designer.utils.DbHelper;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.model.AppImportExportAwarePlugin;
import org.joget.apps.app.model.ConsolePagePluginAbstract;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.userview.service.UserviewUtil;
import org.joget.commons.util.LogUtil;
import org.joget.plugin.base.ConsolePagePlugin;
import org.joget.plugin.base.PluginManager;
import org.joget.workflow.model.service.WorkflowUserManager;
import org.json.JSONArray;
import org.json.JSONObject;

public class AiDesignerGovernance
extends ConsolePagePluginAbstract
implements AppImportExportAwarePlugin {
    public String getName() {
        return "AI Designer Governance";
    }

    public String getVersion() {
        return "8.2.0";
    }

    public String getDescription() {
        return "";
    }

    public String getLabel() {
        return "AI Designer Governance";
    }

    public String getPluginIcon() {
        return "<i class=\"fas fa-envelope\"></i>";
    }

    public int getOrder() {
        return 350;
    }

    public ConsolePagePlugin.Location getLocation() {
        return ConsolePagePlugin.Location.MONITOR;
    }

    public boolean isAuthorized() {
        WorkflowUserManager wum = (WorkflowUserManager)AppUtil.getApplicationContext().getBean("workflowUserManager");
        return wum.isCurrentUserInRole("ROLE_ADMIN");
    }

    public String render(HttpServletRequest request, HttpServletResponse response) {
        PluginManager pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager");
        HashMap<String, Object> tabledata = new HashMap<String, Object>();
        tabledata.put("divId", "sampleList");
        String queryString = "";
        if (request.getQueryString() != null) {
            queryString = request.getQueryString();
        }
        URI uri = null;
        try {
            uri = new URI(null, null, request.getContextPath() + "/web/console/plugin/" + this.getName() + "/list" + queryString, null);
        }
        catch (URISyntaxException e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"Failed to encode getName() as URI path segment");
        }
        tabledata.put("url", uri.toString());
        tabledata.put("fields", "['llmModelClass', 'app_id', 'llmModelName', 'query', 'createdAt']");
        HashMap<String, String> dynamicAttributes = new HashMap<String, String>();
        dynamicAttributes.put("rowsPerPage", "15");
        dynamicAttributes.put("width", "100%");
        dynamicAttributes.put("sort", "createdAt");
        dynamicAttributes.put("desc", "true");
        dynamicAttributes.put("column1", "{\"key\": \"app_id\", \"label\": \"App ID\", \"sortable\": true, \"width\": \"10%\"}");
        dynamicAttributes.put("column2", "{\"key\": \"llmModelClass\", \"label\": \"LLM Class\", \"sortable\": true, \"width\": \"7%\"}");
        dynamicAttributes.put("column3", "{\"key\": \"llmModelName\", \"label\": \"Model Name\", \"sortable\": true, \"width\": \"7%\"}");
        dynamicAttributes.put("column4", "{\"key\": \"query\", \"label\": \"Query\", \"sortable\": true, \"width\": \"66%\"}");
        dynamicAttributes.put("column5", "{\"key\": \"createdAt\", \"label\": \"Created At\", \"sortable\": true, \"width\": \"10%\"}");
        tabledata.put("dynamicAttributes", dynamicAttributes);
        String tableHtml = UserviewUtil.renderJspAsString((String)"console/page/jsontable.jsp", tabledata);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("tableHtml", tableHtml);
        return pluginManager.getPluginFreeMarkerTemplate(data, this.getClassName(), "/templates/ConsolePage.ftl", null);
    }

    @ConsolePagePlugin.Path(value={"/list"})
    public void renderListJsonData(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String callback = request.getParameter("callback");
        String sort = request.getParameter("sort");
        Boolean desc = request.getParameter("desc") != null ? Boolean.valueOf(request.getParameter("desc")) : null;
        Integer start = request.getParameter("start") != null ? Integer.valueOf(request.getParameter("start")) : null;
        Integer rows = request.getParameter("rows") != null ? Integer.valueOf(request.getParameter("rows")) : null;
        JSONArray workflowDocuments = DbHelper.findAllWorkflows(sort, desc, start, rows);
        Integer total = workflowDocuments.length();
        JSONObject jsonObject = new JSONObject();
        for (int i = 0; i < workflowDocuments.length(); ++i) {
            JSONObject workflowDocument = workflowDocuments.getJSONObject(i);
            JSONObject data = new JSONObject();
            data.put("id", (Object)workflowDocument.optString("id"));
            if (workflowDocument.has("app_id")) {
                data.put("app_id", (Object)workflowDocument.optString("app_id"));
            } else {
                data.put("app_id", (Object)"");
            }
            data.put("llmModelClass", (Object)workflowDocument.optString("llmModelClass"));
            data.put("llmModelName", (Object)workflowDocument.optString("llmModelName"));
            data.put("query", (Object)workflowDocument.optString("query"));
            data.put("createdAt", (Object)workflowDocument.optString("created_at"));
            jsonObject.accumulate("data", (Object)data);
        }
        jsonObject.accumulate("total", (Object)total);
        jsonObject.accumulate("start", (Object)start);
        jsonObject.accumulate("sort", (Object)sort);
        jsonObject.accumulate("desc", (Object)desc);
        AppUtil.writeJson((Writer)response.getWriter(), (JSONObject)jsonObject, (String)callback);
    }

    public String importAppConfigHtml() {
        return "AppImportExportAwarePlugin is injected";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importAppPostProcessing(AppDefinition appDef, byte[] zip) {
        ZipInputStream in = new ZipInputStream(new ByteArrayInputStream(zip));
        ZipEntry entry = null;
        try {
            while ((entry = in.getNextEntry()) != null) {
                if (entry.isDirectory() || !entry.getName().startsWith("testing.txt")) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    int length;
                    byte[] temp = new byte[1024];
                    while ((length = in.read(temp, 0, 1024)) != -1) {
                        out.write(temp, 0, length);
                    }
                    String text = new String(out.toByteArray(), "UTF-8");
                    LogUtil.info((String)this.getClassName(), (String)text);
                    return;
                }
                finally {
                    out.flush();
                    out.close();
                    return;
                }
            }
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"fail to read zip");
            return;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String exportAppConfigHtml() {
        return "AppImportExportAwarePlugin is injected";
    }

    public void exportAppPostProcessing(AppDefinition appDef, ZipOutputStream zip) {
        try {
            zip.putNextEntry(new ZipEntry("testing.txt"));
            zip.write("this is a test string".getBytes("UTF-8"));
            zip.closeEntry();
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"Fail to export system variables");
        }
    }
}

