/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.designer;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joget.ai.designer.feature.ConfigurationPage;
import org.joget.apps.app.model.ConsolePagePluginAbstract;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.spring.model.Setting;
import org.joget.commons.util.LogUtil;
import org.joget.commons.util.SecurityUtil;
import org.joget.commons.util.SetupManager;
import org.joget.plugin.base.ConsolePagePlugin;
import org.joget.plugin.base.PluginManager;
import org.joget.plugin.base.PluginWebSupport;
import org.joget.plugin.property.service.PropertyUtil;
import org.joget.workflow.model.service.WorkflowUserManager;
import org.json.JSONArray;
import org.json.JSONObject;

public class AiDesignerCentralConfig
extends ConsolePagePluginAbstract
implements PluginWebSupport {
    ConfigurationPage configurationPage = new ConfigurationPage();

    public String getName() {
        return "AI Designer Central Config";
    }

    public String getVersion() {
        return "8.2.0";
    }

    public String getDescription() {
        return "Central configuration for AI Designer";
    }

    public String getLabel() {
        return "AI Designer Central Config";
    }

    public String getPluginIcon() {
        return "<i class=\"fas fa-cog\"></i>";
    }

    public int getOrder() {
        return 350;
    }

    public ConsolePagePlugin.Location getLocation() {
        return ConsolePagePlugin.Location.SETTINGS;
    }

    public boolean isAuthorized() {
        WorkflowUserManager wum = (WorkflowUserManager)AppUtil.getApplicationContext().getBean("workflowUserManager");
        return wum.isCurrentUserInRole("ROLE_ADMIN");
    }

    public String render(HttpServletRequest request, HttpServletResponse response) {
        PluginManager pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("contextPath", request.getContextPath());
        data.put("debug", "true".equalsIgnoreCase(System.getenv("debug")));
        data.put("css", AppUtil.readPluginResource((String)this.getClassName(), (String)"resources/feature/CentralConfig/CentralConfig.css"));
        data.put("js", AppUtil.readPluginResource((String)this.getClassName(), (String)"resources/feature/CentralConfig/CentralConfig.js", (Object[])new Object[0], (boolean)false, (String)"message/ai/AiDesigner"));
        return pluginManager.getPluginFreeMarkerTemplate(data, this.getClassName(), "/templates/CentralConfig.ftl", "message/ai/AiDesigner");
    }

    public void webService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isAuthorized()) {
            response.sendError(401);
            return;
        }
        String action = SecurityUtil.validateStringInput((String)request.getParameter("_a"));
        String method = request.getMethod();
        try {
            String responseData = this.handleAction(action, method, request, response);
            this.writeJsonResponse(response, responseData);
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)("Exception occurred while processing action: " + action));
            response.sendError(500, "Internal error");
        }
    }

    private String handleAction(String action, String method, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!"POST".equalsIgnoreCase(method)) {
            throw new Exception("For this API endpoint only POST method is accepted.");
        }
        switch (action) {
            case "saveApiServerConfig": {
                return this.configurationPage.saveApiServerConfig(request);
            }
            case "validateApiServerUrl": {
                return this.configurationPage.validateApiServerUrl(request);
            }
            case "validateApiServerKey": {
                return this.configurationPage.validateApiServerKey(request);
            }
            case "retrieveNewAiServiceFormFields": {
                return this.configurationPage.retrieveNewAiServiceFormFields();
            }
            case "createNewAiService": {
                return this.configurationPage.createNewAiService(request);
            }
            case "revokeMyAiService": {
                return this.configurationPage.revokeMyAiService(request);
            }
            case "editMyAiService": {
                return this.configurationPage.editMyAiService(request);
            }
            case "loadApiServerConfig": {
                return this.loadApiServerConfig();
            }
            case "saveCurrentAiService": {
                return this.configurationPage.saveCurrentAiService(request);
            }
            case "loadMyAiServices": {
                return this.loadMyAiServices();
            }
            case "loadCurrentAiService": {
                return this.loadCurrentAiService();
            }
            case "loadPiiMaskingRules": {
                return this.loadPiiMaskingRules();
            }
            case "addPiiMaskingRule": {
                return this.addPiiMaskingRule(request);
            }
            case "removePiiMaskingRule": {
                return this.removePiiMaskingRule(request);
            }
        }
        throw new Exception("Action for this endpoint is not recognized.");
    }

    private void writeJsonResponse(HttpServletResponse response, String responseData) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        try (PrintWriter out = response.getWriter();){
            out.print(responseData);
            out.flush();
        }
    }

    public String loadApiServerConfig() throws IOException {
        SetupManager setupManager = (SetupManager)AppUtil.getApplicationContext().getBean("setupManager");
        Setting setting = setupManager.getSettingByProperty("API_SERVER_CONFIG");
        JSONObject result = new JSONObject();
        result.put("success", true);
        if (setting == null) {
            JSONObject apiCredentials = new JSONObject();
            apiCredentials.put("apiServerUrl", (Object)AppPluginUtil.getMessage((String)"aiag.defaultApiServerUrl", (String)this.getClassName(), (String)"message/ai/AiDesigner"));
            apiCredentials.put("apiServerKey", (Object)"");
            JSONObject apiServerConfig = new JSONObject();
            apiServerConfig.put("properties", (Object)apiCredentials);
            result.put("apiServerConfig", (Object)apiServerConfig);
        } else {
            result.put("apiServerConfig", (Object)new JSONObject(PropertyUtil.propertiesJsonLoadProcessing((String)setting.getValue())));
        }
        return result.toString();
    }

    public String loadMyAiServices() throws IOException {
        SetupManager setupManager = (SetupManager)AppUtil.getApplicationContext().getBean("setupManager");
        Setting setting = setupManager.getSettingByProperty("MY_AI_SERVICES");
        JSONObject result = new JSONObject();
        result.put("success", true);
        if (setting == null) {
            result.put("myAiServices", (Object)new JSONObject("{\"properties\": {\"myAiServices\": []}}"));
        } else {
            result.put("myAiServices", (Object)new JSONObject(PropertyUtil.propertiesJsonLoadProcessing((String)setting.getValue())));
        }
        return result.toString();
    }

    public String loadCurrentAiService() throws IOException {
        SetupManager setupManager = (SetupManager)AppUtil.getApplicationContext().getBean("setupManager");
        Setting setting = setupManager.getSettingByProperty("CURRENT_AI_SERVICE");
        JSONObject result = new JSONObject();
        result.put("success", true);
        if (setting == null) {
            result.put("currentAiService", (Object)new JSONObject("{\"properties\": {\"aiService\": \"\", \"modelClass\": \"\", \"modelName\": \"\"}}"));
        } else {
            result.put("currentAiService", (Object)new JSONObject(PropertyUtil.propertiesJsonLoadProcessing((String)setting.getValue())));
        }
        return result.toString();
    }

    public String loadPiiMaskingRules() throws IOException {
        SetupManager setupManager = (SetupManager)AppUtil.getApplicationContext().getBean("setupManager");
        Setting setting = setupManager.getSettingByProperty("MY_PII_MASKING_RULES_CONFIG");
        JSONObject result = new JSONObject();
        result.put("success", true);
        if (setting == null) {
            result.put("piiMaskingRules", (Object)new JSONObject("{\"properties\": {\"myPiiMaskingRules\": []}}"));
        } else {
            result.put("piiMaskingRules", (Object)new JSONObject(PropertyUtil.propertiesJsonLoadProcessing((String)setting.getValue())));
        }
        return result.toString();
    }

    public String addPiiMaskingRule(HttpServletRequest request) throws IOException {
        JSONObject result = new JSONObject();
        String newRule = request.getParameter("_piiRule");
        if (newRule == null || newRule.trim().isEmpty()) {
            result.put("success", false);
            result.put("error", (Object)"PII rule cannot be empty");
            return result.toString();
        }
        SetupManager setupManager = (SetupManager)AppUtil.getApplicationContext().getBean("setupManager");
        Setting setting = setupManager.getSettingByProperty("MY_PII_MASKING_RULES_CONFIG");
        if (setting == null) {
            setting = new Setting();
            setting.setProperty("MY_PII_MASKING_RULES_CONFIG");
            setting.setValue("{\"className\": \"\", \"properties\": {\"myPiiMaskingRules\": []}}");
            setupManager.saveSetting(setting);
        }
        String settingValue = setting.getValue();
        JSONObject rulesObj = new JSONObject(settingValue);
        JSONObject properties = rulesObj.getJSONObject("properties");
        JSONArray rulesArray = properties.getJSONArray("myPiiMaskingRules");
        for (int i = 0; i < rulesArray.length(); ++i) {
            if (!rulesArray.getString(i).equals(newRule.trim())) continue;
            result.put("success", false);
            result.put("error", (Object)"PII Masking Rule already exists");
            return result.toString();
        }
        rulesArray.put((Object)newRule.trim());
        properties.put("myPiiMaskingRules", (Object)rulesArray);
        rulesObj.put("properties", (Object)properties);
        String updatedSetting = PropertyUtil.propertiesJsonStoreProcessing((String)settingValue, (String)rulesObj.toString(4));
        setting.setValue(updatedSetting);
        setupManager.saveSetting(setting);
        result.put("success", true);
        result.put("piiMaskingRules", (Object)new JSONObject(PropertyUtil.propertiesJsonLoadProcessing((String)setting.getValue())));
        return result.toString();
    }

    public String removePiiMaskingRule(HttpServletRequest request) throws IOException {
        JSONObject result = new JSONObject();
        String ruleToRemove = request.getParameter("_piiRule");
        SetupManager setupManager = (SetupManager)AppUtil.getApplicationContext().getBean("setupManager");
        Setting setting = setupManager.getSettingByProperty("MY_PII_MASKING_RULES_CONFIG");
        if (setting == null) {
            result.put("success", false);
            result.put("error", (Object)"No PII rules found");
            return result.toString();
        }
        String settingValue = setting.getValue();
        JSONObject rulesObj = new JSONObject(settingValue);
        JSONObject properties = rulesObj.getJSONObject("properties");
        JSONArray rulesArray = properties.getJSONArray("myPiiMaskingRules");
        for (int i = 0; i < rulesArray.length(); ++i) {
            if (!rulesArray.getString(i).equals(ruleToRemove)) continue;
            rulesArray.remove(i);
            break;
        }
        properties.put("myPiiMaskingRules", (Object)rulesArray);
        rulesObj.put("properties", (Object)properties);
        setting.setValue(rulesObj.toString());
        setupManager.saveSetting(setting);
        result.put("success", true);
        result.put("piiMaskingRules", (Object)new JSONObject(PropertyUtil.propertiesJsonLoadProcessing((String)setting.getValue())));
        return result.toString();
    }
}

