/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.designer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.joget.ai.designer.feature.AiServiceQuickSwitch;
import org.joget.ai.designer.feature.ConfigurationPage;
import org.joget.ai.designer.feature.GenerationPage;
import org.joget.ai.designer.feature.LauncherPage;
import org.joget.ai.designer.utils.ApiHelper;
import org.joget.ai.designer.utils.ApplicationUtils;
import org.joget.ai.designer.utils.Constants;
import org.joget.ai.designer.utils.DbHelper;
import org.joget.ai.designer.utils.GenerationUtils.UiGenerationUtils;
import org.joget.ai.designer.utils.GenericUtils;
import org.joget.ai.designer.utils.StringUtils;
import org.joget.ai.designer.utils.WorkflowUtils;
import org.joget.ai.designer.utils.XpdlHelper;
import org.joget.apps.app.dao.AppDefinitionDao;
import org.joget.apps.app.model.AbstractVersionedObject;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.model.CreateAppOption;
import org.joget.apps.app.model.FormDefinition;
import org.joget.apps.app.model.PackageActivityForm;
import org.joget.apps.app.model.PackageDefinition;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppService;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.spring.model.Setting;
import org.joget.commons.util.LogUtil;
import org.joget.commons.util.SecurityUtil;
import org.joget.commons.util.SetupManager;
import org.joget.plugin.base.ExtDefaultPlugin;
import org.joget.plugin.base.PluginManager;
import org.joget.plugin.base.PluginWebSupport;
import org.joget.plugin.property.service.PropertyUtil;
import org.joget.workflow.model.service.WorkflowManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AiDesigner
extends ExtDefaultPlugin
implements CreateAppOption,
PluginWebSupport {
    public JSONObject workflowDocument = null;
    public ApiHelper apiHelper = new ApiHelper();
    AiServiceQuickSwitch aiServiceQuickSwitch = new AiServiceQuickSwitch();
    ConfigurationPage configurationPage = new ConfigurationPage();
    GenerationPage generationPage = new GenerationPage();
    LauncherPage launcher = new LauncherPage();

    public String getName() {
        return "AI Designer";
    }

    public String getVersion() {
        return "8.2-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)"AiDesigner.pluginDesc", (String)this.getClassName(), (String)"message/ai/AiDesigner");
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)"AiDesigner.pluginLabel", (String)this.getClassName(), (String)"message/ai/AiDesigner");
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)"/properties/ai/AiDesigner.json", null, (boolean)true, (String)"message/ai/AiDesigner");
    }

    public String getPluginIcon() {
        return "<i class=\"fas fa-robot\"></i>";
    }

    public Boolean isAvailable() {
        return true;
    }

    public Collection<String> createAppDefinition(String appId, String appName, HttpServletRequest request) {
        ArrayList<String> result;
        block11: {
            result = new ArrayList<String>();
            AppDefinitionDao appDefinitionDao = (AppDefinitionDao)AppUtil.getApplicationContext().getBean("appDefinitionDao");
            String processName = null;
            AppDefinition appDef = null;
            String runProcessFormName = null;
            Map<String, Map<String, String>> generated = new HashMap<String, Map<String, String>>();
            HashMap<String, Collection<String>> formActivityNamesMap = new HashMap<String, Collection<String>>();
            NodeList activityList = null;
            NodeList transitionList = null;
            String processId = null;
            try {
                String xml = this.getPropertyString("xml");
                if (!StringUtils.isBlank(xml)) {
                    xml = xml.replaceAll("\r", "");
                    xml = xml.replaceAll("\n", "");
                    ByteArrayInputStream input = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document document = builder.parse(input);
                    document.getDocumentElement().normalize();
                    NodeList workflowProcessList = document.getElementsByTagName("WorkflowProcess");
                    for (int i = 0; i < workflowProcessList.getLength(); ++i) {
                        Node workflowProcessNode = workflowProcessList.item(i);
                        if (workflowProcessNode.getNodeType() != 1) continue;
                        Element workflowProcessElement = (Element)workflowProcessNode;
                        processId = workflowProcessElement.getAttribute("Id");
                        processName = workflowProcessElement.getAttribute("Name");
                        activityList = workflowProcessElement.getElementsByTagName("Activity");
                        transitionList = workflowProcessElement.getElementsByTagName("Transition");
                    }
                } else {
                    LogUtil.info((String)this.getClassName(), (String)"This app does not contain any process, proceeding with trying to add forms and lists");
                }
                String jsonFormsAndLists = this.getPropertyString("json");
                appDef = new AppDefinition();
                appDef.setAppId(appId);
                appDef.setVersion(Long.valueOf(1L));
                appDef.setId(appId);
                appDef.setName(appName);
                appDef.setPublished(Boolean.FALSE);
                appDef.setDateCreated(new Date());
                appDef.setDateModified(new Date());
                appDefinitionDao.saveOrUpdate((AbstractVersionedObject)appDef);
                if (jsonFormsAndLists.length() > 0) {
                    runProcessFormName = WorkflowUtils.generateFormsAndLists(jsonFormsAndLists, appDef, formActivityNamesMap, generated);
                    if (!StringUtils.isBlank(xml)) {
                        generated = WorkflowUtils.generateAndDeployXpdl(xml, generated, appDef, runProcessFormName, formActivityNamesMap, activityList, transitionList, processId);
                    }
                } else {
                    runProcessFormName = "";
                }
                ArrayList<String> entities = new ArrayList<String>();
                if (jsonFormsAndLists.length() <= 0) break block11;
                try {
                    JSONObject jsonObject = new JSONObject(jsonFormsAndLists);
                    for (String key : jsonObject.keySet()) {
                        entities.add(key);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                UiGenerationUtils.generateUI(this, entities, generated, appDef);
            }
            catch (Exception e) {
                appDefinitionDao.deleteAllVersions(appId);
                result.add(AppPluginUtil.getMessage((String)("aiDesigner.unrecognizedDefinition" + e), (String)this.getClassName(), (String)"message/ai/AiDesigner"));
                e.printStackTrace();
            }
        }
        return result;
    }

    private void initializeWorkflowDocumentIfRequired(String action, HttpServletRequest request) {
        if (Constants.databaseDependentStages.contains(action)) {
            this.workflowDocument = DbHelper.findWorkflowCollection(request.getParameter("user_id"), request.getParameter("session_id"));
        }
    }

    private String handleAction(String action, String method, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if ("script".equals(action)) {
            return this.handleScript(request, response);
        }
        if (!"POST".equalsIgnoreCase(method)) {
            throw new Exception("For this API endpoint only POST method is accepted.");
        }
        switch (action) {
            case "createApp": {
                ApplicationUtils.captureAppId(request.getParameter("appId"), request.getParameter("appName"), this.workflowDocument);
                return "{}";
            }
            case "validateUniqueAppId": {
                return ApplicationUtils.isUniqueAppId(request, response);
            }
            case "saveCurrentAiService": {
                return this.configurationPage.saveCurrentAiService(request);
            }
            case "saveApiServerConfig": {
                return this.configurationPage.saveApiServerConfig(request);
            }
            case "previewXpdl": {
                return this.generationPage.previewXpdl(request, response);
            }
            case "previewForm": {
                return this.generationPage.previewForm(request, response);
            }
            case "retrieveNewAiServiceFormFields": {
                return this.configurationPage.retrieveNewAiServiceFormFields();
            }
            case "createNewAiService": {
                return this.configurationPage.createNewAiService(request);
            }
            case "revokeMyAiService": {
                return this.configurationPage.revokeMyAiService(request);
            }
            case "editMyAiService": {
                return this.configurationPage.editMyAiService(request);
            }
            case "validateApiServerUrl": {
                return this.configurationPage.validateApiServerUrl(request);
            }
            case "validateApiServerKey": {
                return this.configurationPage.validateApiServerKey(request);
            }
            case "updateMyPiiMaskingRules": {
                return this.configurationPage.updateMyPiiMaskingRules(request, response);
            }
            case "getAppIds": {
                try {
                    return ApplicationUtils.getAppIds(request, response);
                }
                catch (IOException | InterruptedException e) {
                    LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"Failed to get App IDs");
                    throw e;
                }
            }
            case "getAppVersions": {
                try {
                    return ApplicationUtils.getAppVersions(request, response);
                }
                catch (IOException | InterruptedException e) {
                    LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"Failed to get App Versions");
                    throw e;
                }
            }
            case "getAppData": {
                try {
                    this.getAppData(request, response);
                    return this.workflowDocument.get("responseBodyData").toString();
                }
                catch (IOException | InterruptedException e) {
                    LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"Failed to get App Data");
                    throw e;
                }
            }
            case "workflowDesign": 
            case "add_forms_design": 
            case "replace_form_design": 
            case "remove_form_design": 
            case "query_enhancer": 
            case "pii_analyser": 
            case "jogetFormToForms": 
            case "xpdlToYaml": {
                try {
                    this.workflowDocument = this.generationPage.driver(request, response, this.workflowDocument);
                    return this.workflowDocument.get("responseBodyData").toString();
                }
                catch (IOException | InterruptedException e) {
                    LogUtil.error((String)this.getClassName(), (Throwable)e, (String)("Failed to call AI Designer API for action: " + action));
                    throw e;
                }
            }
        }
        throw new Exception("Action for this endpoint is not recognized.");
    }

    private void writeJsonResponse(HttpServletRequest request, HttpServletResponse response, String responseData) throws IOException {
        String action = SecurityUtil.validateStringInput((String)request.getParameter("_a"));
        if (action.equals("previewXpdl") || action.equals("previewForm")) {
            response.setContentType("text/html");
        } else {
            response.setContentType("application/json");
        }
        response.setCharacterEncoding("UTF-8");
        try (PrintWriter out = response.getWriter();){
            out.print(responseData);
            out.flush();
        }
    }

    public void webService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!GenericUtils.isUserAdmin(response)) {
            return;
        }
        String action = SecurityUtil.validateStringInput((String)request.getParameter("_a"));
        String method = request.getMethod();
        this.initializeWorkflowDocumentIfRequired(action, request);
        try {
            String responseData = this.handleAction(action, method, request, response);
            this.writeJsonResponse(request, response, responseData);
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)("Exception occurred while processing action: " + action));
            response.sendError(500, "Internal error");
        }
    }

    public void getAppData(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
        AppDefinition appDef = appService.getAppDefinition(request.getParameter("_appId"), request.getParameter("_appVersion"));
        WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
        PackageDefinition packageDef = appDef.getPackageDefinition();
        String processXpdl = null;
        JSONArray activityArray = new JSONArray();
        if (packageDef != null) {
            byte[] content = workflowManager.getPackageContent(packageDef.getId(), packageDef.getVersion().toString());
            if (content != null) {
                processXpdl = new String(content, "UTF-8");
            }
            Map packageActivityFormMap = packageDef.getPackageActivityFormMap();
            for (Map.Entry entry : packageActivityFormMap.entrySet()) {
                PackageActivityForm form = (PackageActivityForm)entry.getValue();
                JSONObject activity = new JSONObject();
                activity.put("activity_id", (Object)XpdlHelper.getActivityId(form.getActivityDefId()));
                activity.put("form_id", (Object)form.getFormId());
                activityArray.put((Object)activity);
            }
        } else {
            processXpdl = "";
        }
        Collection formDefList = appDef.getFormDefinitionList();
        JSONObject formJson = new JSONObject();
        if (formDefList != null) {
            for (FormDefinition formDefinition : formDefList) {
                JSONObject innerFormJson = new JSONObject();
                innerFormJson.put("form", (Object)new JSONObject(formDefinition.getJson()));
                innerFormJson.put("activity_names", (Object)new JSONArray());
                innerFormJson.put("list", new ArrayList());
                formJson.put(formDefinition.getId(), (Object)innerFormJson);
            }
        } else {
            formJson = new JSONObject();
        }
        this.workflowDocument.put("designed_form_joget_format", (Object)formJson);
        this.workflowDocument.put("process_xpdl", (Object)processXpdl);
        JSONObject formDesign = ApiHelper.callAiDesignerApi(request, response, this.workflowDocument);
        this.workflowDocument.put("designed_form", (Object)formDesign.getString("form_mapping"));
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("xpdl", (Object)processXpdl);
        jSONObject.put("json", (Object)formJson);
        this.workflowDocument.put("responseBodyData", (Object)jSONObject);
        DbHelper.saveWorkflowCollection(this.workflowDocument);
    }

    public String handleScript(HttpServletRequest request, HttpServletResponse response) throws IOException {
        SetupManager setupManager = (SetupManager)AppUtil.getApplicationContext().getBean("setupManager");
        String currentAiServiceString = null;
        Setting setting = setupManager.getSettingByProperty("CURRENT_AI_SERVICE");
        if (setting != null) {
            currentAiServiceString = PropertyUtil.propertiesJsonLoadProcessing((String)setting.getValue());
        } else {
            setting = new Setting();
            setting.setProperty("CURRENT_AI_SERVICE");
            currentAiServiceString = "{\"className\": \"\", \"properties\": {\"aiService\": \"\"}}";
            JSONObject currentAiServiceObject = new JSONObject(currentAiServiceString);
            setting.setValue(currentAiServiceObject.toString());
            setupManager.saveSetting(setting);
        }
        String myAiServicesString = null;
        setting = setupManager.getSettingByProperty("MY_AI_SERVICES");
        if (setting != null) {
            myAiServicesString = PropertyUtil.propertiesJsonLoadProcessing((String)setting.getValue());
        } else {
            setting = new Setting();
            setting.setProperty("MY_AI_SERVICES");
            myAiServicesString = "{\"className\": \"\", \"properties\": {\"myAiServices\": []}}";
            JSONObject myAiServicesObject = new JSONObject(myAiServicesString);
            setting.setValue(myAiServicesObject.toString());
            setupManager.saveSetting(setting);
        }
        String apiServerConfigString = null;
        setting = setupManager.getSettingByProperty("API_SERVER_CONFIG");
        if (setting != null) {
            apiServerConfigString = PropertyUtil.propertiesJsonLoadProcessing((String)setting.getValue());
        } else {
            setting = new Setting();
            setting.setProperty("API_SERVER_CONFIG");
            apiServerConfigString = "{\"className\": \"\", \"properties\": {\"apiServerUrl\": \"\", \"apiServerKey\": \"\"}}";
            JSONObject apiServerConfigObject = new JSONObject(apiServerConfigString);
            setting.setValue(apiServerConfigObject.toString());
            setupManager.saveSetting(setting);
        }
        String myPiiMaskingRulesConfigString = null;
        setting = setupManager.getSettingByProperty("MY_PII_MASKING_RULES_CONFIG");
        if (setting != null) {
            myPiiMaskingRulesConfigString = PropertyUtil.propertiesJsonLoadProcessing((String)setting.getValue());
        } else {
            setting = new Setting();
            setting.setProperty("MY_PII_MASKING_RULES_CONFIG");
            myPiiMaskingRulesConfigString = "{\"className\": \"\", \"properties\": {\"myPiiMaskingRules\": []}}";
            JSONObject myPiiMaskingRulesConfigObject = new JSONObject(myPiiMaskingRulesConfigString);
            setting.setValue(myPiiMaskingRulesConfigObject.toString());
            setupManager.saveSetting(setting);
        }
        PluginManager pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager");
        JSONObject resources = new JSONObject();
        resources.put("Global", (Object)this.generationPage.getResources(pluginManager, "Global"));
        resources.put("LauncherPage", (Object)this.launcher.getResources(pluginManager, "LauncherPage"));
        resources.put("AddFormDesign", (Object)this.generationPage.getResources(pluginManager, "AddFormDesign"));
        resources.put("ReplaceRemoveFormDesign", (Object)this.generationPage.getResources(pluginManager, "ReplaceRemoveFormDesign"));
        resources.put("AiServiceQuickSwitch", (Object)this.aiServiceQuickSwitch.getResources(pluginManager, "AiServiceQuickSwitch"));
        resources.put("RestartProgress", (Object)this.generationPage.getResources(pluginManager, "RestartProgress"));
        resources.put("QueryPreprocess", (Object)this.generationPage.getResources(pluginManager, "QueryPreprocess"));
        resources.put("ConfigurationPage", (Object)this.configurationPage.getResources(pluginManager, "ConfigurationPage"));
        resources.put("EditQuery", (Object)this.generationPage.getResources(pluginManager, "EditQuery"));
        resources.put("GenerationPage", (Object)this.generationPage.getResources(pluginManager, "GenerationPage"));
        String script = AppUtil.readPluginResource((String)this.getClassName(), (String)"/script.js", (Object[])new Object[]{resources.toString(), currentAiServiceString, myAiServicesString, apiServerConfigString, myPiiMaskingRulesConfigString}, (boolean)false, (String)"message/ai/AiDesigner");
        return script;
    }
}

