/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.joget.ai.agent.lib.AgentExecutionTrace;
import org.joget.ai.agent.model.AgentEnhancerAbstract;
import org.joget.ai.agent.model.AgentLLMAbstract;
import org.joget.ai.agent.model.AgentPromptAbstract;
import org.joget.ai.agent.model.AgentToolAbstract;
import org.joget.ai.agent.model.AgentTraceEvent;
import org.joget.ai.agent.model.AgentTraceStatus;
import org.joget.ai.agent.model.Messages;
import org.joget.ai.agent.model.Response;
import org.joget.ai.agent.model.ToolExecution;
import org.joget.ai.agent.model.Traceable;
import org.joget.ai.agent.utils.AgentExecutionContext;
import org.joget.ai.agent.utils.ResponseAdapter;
import org.joget.commons.util.UuidGenerator;

@Aspect
public class TraceableAspect {
    private final Gson gson = new GsonBuilder().registerTypeAdapter(Response.class, (Object)new ResponseAdapter()).create();
    private static final Map<String, Class<?>> TYPE_CLASS_MAP = Map.of("Tool", ToolExecution.class, "Enhancer", Response.class, "LLM", Messages.class, "Task", Messages.class, "Prompt", Messages.class);
    private static final ThreadLocal<Set<String>> activeMethods = ThreadLocal.withInitial(HashSet::new);

    @Around(value="@annotation(traceable)")
    public Object traceExecution(ProceedingJoinPoint pjp, Traceable traceable) throws Throwable {
        Object result;
        boolean alreadyActive;
        String runId = (String)AgentExecutionContext.get("runId");
        String promptType = (String)AgentExecutionContext.get("promptType");
        boolean agentDebugMode = (Boolean)AgentExecutionContext.get("agentDebugMode");
        if (promptType != null && promptType.equalsIgnoreCase("agentPrompt")) {
            return pjp.proceed();
        }
        String signature = pjp.getSignature().toLongString();
        Set<String> active = activeMethods.get();
        boolean bl = alreadyActive = !active.add(signature);
        if (alreadyActive) {
            return pjp.proceed();
        }
        Object[] args = pjp.getArgs();
        Object target = pjp.getTarget();
        String type = TraceableAspect.getAgentType(target);
        AgentTraceEvent event = new AgentTraceEvent();
        event.setRunId(runId);
        event.setNodeId(UuidGenerator.getInstance().getUuid());
        event.setDefId(this.getProperty(target, "id"));
        event.setParentId((String)AgentExecutionContext.get("parentId"));
        event.setType(type);
        event.setLabel(this.getLabel(target));
        event.setStatus(AgentTraceStatus.RUNNING);
        AgentExecutionTrace.publishTraceEvent(event, true, agentDebugMode);
        AgentTraceEvent finalEvent = new AgentTraceEvent(event);
        finalEvent.setRunId(runId);
        try {
            result = pjp.proceed();
            String requestJson = this.extractRequest(type, args);
            finalEvent.setRequest(requestJson);
            finalEvent.setStatus(AgentTraceStatus.SUCCESS);
            finalEvent.setResponse(this.toJson(result));
        }
        catch (Exception e) {
            String requestJson = this.extractRequest(type, args);
            finalEvent.setRequest(requestJson);
            finalEvent.setStatus(AgentTraceStatus.FAILED);
            finalEvent.setResponse(this.toJson(e.getMessage()));
            throw e;
        }
        finally {
            active.remove(signature);
            if (active.isEmpty()) {
                activeMethods.remove();
            }
            AgentExecutionContext.put("runId", runId);
            AgentExecutionTrace.publishTraceEvent(finalEvent, true, agentDebugMode);
        }
        return result;
    }

    private String toJson(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            if (obj instanceof String) {
                String str = obj.toString().trim();
                if (str.startsWith("{") && str.endsWith("}") || str.startsWith("[") && str.endsWith("]")) {
                    return this.gson.toJson(this.gson.fromJson(str, Object.class));
                }
                return this.gson.toJson((Object)str);
            }
            return this.gson.toJson(obj);
        }
        catch (Exception e) {
            return obj.toString();
        }
    }

    private String getLabel(Object target) {
        try {
            Method method = target.getClass().getMethod("getLabel", new Class[0]);
            return Optional.ofNullable(method.invoke(target, new Object[0])).map(Object::toString).orElse("");
        }
        catch (Exception ignored) {
            return "";
        }
    }

    private String extractRequest(String type, Object[] args) {
        if (type == null || args == null || args.length == 0) {
            return null;
        }
        Class<?> expectedClass = TYPE_CLASS_MAP.get(type);
        if (expectedClass == null) {
            return null;
        }
        for (Object arg : args) {
            if (!expectedClass.isInstance(arg)) continue;
            return this.toJson(arg);
        }
        return null;
    }

    public static String getAgentType(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof AgentEnhancerAbstract) {
            return "Enhancer";
        }
        if (obj instanceof AgentPromptAbstract) {
            return "Prompt";
        }
        if (obj instanceof AgentToolAbstract) {
            return "Tool";
        }
        if (obj instanceof AgentLLMAbstract) {
            return "LLM";
        }
        return null;
    }

    private String getProperty(Object target, String key) {
        if (target == null) {
            return null;
        }
        try {
            Method method = target.getClass().getMethod("getProperty", String.class);
            Object value = method.invoke(target, key);
            return value != null ? value.toString() : null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

