/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.utils;

import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.topic.ITopic;
import java.util.Properties;
import org.joget.ai.agent.utils.NoSystemHazelcastProperties;
import org.joget.commons.util.LogUtil;
import org.joget.commons.util.UuidGenerator;

public class HazelcastManager {
    private static HazelcastInstance hazelcastInstance;

    public static synchronized HazelcastInstance getInstance() {
        if (hazelcastInstance == null) {
            Config config = new Config();
            config.setClusterName("agent-builder-cluster");
            config.setInstanceName("agent-builder-instance-" + UuidGenerator.getInstance().getUuid());
            NoSystemHazelcastProperties safeProps = new NoSystemHazelcastProperties(new Properties());
            config.setProperties(safeProps.getInternalProps());
            config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(false);
            config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
            config.getNetworkConfig().getJoin().getAutoDetectionConfig().setEnabled(false);
            hazelcastInstance = Hazelcast.newHazelcastInstance((Config)config);
        }
        return hazelcastInstance;
    }

    public static void shutdown() {
        if (hazelcastInstance != null) {
            try {
                hazelcastInstance.shutdown();
            }
            catch (Exception e) {
                LogUtil.error((String)HazelcastManager.class.getName(), (Throwable)e, (String)e.getMessage());
            }
            finally {
                hazelcastInstance = null;
            }
        }
    }

    public static ITopic<String> getTopic(String topicName) {
        return HazelcastManager.getInstance().getTopic(topicName);
    }

    public static void publish(String topicName, String message) {
        try {
            HazelcastManager.getTopic(topicName).publish((Object)message);
        }
        catch (Exception e) {
            LogUtil.error((String)HazelcastManager.class.getName(), (Throwable)e, (String)e.getMessage());
        }
    }
}

